/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jdk.internal.misc.CDS;
import jdk.internal.vm.annotation.Stable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Byte
extends Number
implements Comparable<Byte> {
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class<Byte> TYPE = Class.getPrimitiveClass("byte");
    private final byte value;
    public static final int SIZE = 8;
    private static final long serialVersionUID = -7183698231559129828L;

    public static String toString(byte by) {
        return Integer.toString(by, 10);
    }

    public static Byte valueOf(byte by) {
        return ByteCache.cache[by + 128];
    }

    public static byte parseByte(String string) throws NumberFormatException {
        return Byte.parseByte(string, 10);
    }

    public static byte parseByte(String string, int n) throws NumberFormatException {
        int n2 = Integer.parseInt(string, n);
        if (n2 < -128 || n2 > 127) {
            throw new NumberFormatException("Value out of range. Value:\"" + string + "\" Radix:" + n);
        }
        return (byte)n2;
    }

    public static Byte valueOf(String string, int n) throws NumberFormatException {
        return new Byte(Byte.parseByte(string, n));
    }

    public static Byte valueOf(String string) throws NumberFormatException {
        return Byte.valueOf(string, 10);
    }

    public static Byte decode(String string) throws NumberFormatException {
        Byte by;
        int n = 10;
        int n2 = 0;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            ++n2;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n2 += 2;
            n = 16;
        } else if (string.startsWith("#", n2)) {
            ++n2;
            n = 16;
        } else if (string.startsWith("0", n2) && string.length() > 1 + n2) {
            ++n2;
            n = 8;
        }
        if (string.startsWith("-", n2)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            by = Byte.valueOf(string.substring(n2), n);
            by = bl ? new Byte(-by.byteValue()) : by;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = bl ? new String("-" + string.substring(n2)) : string.substring(n2);
            by = Byte.valueOf(string2, n);
        }
        return by;
    }

    public Byte(byte by) {
        this.value = by;
    }

    public Byte(String string) throws NumberFormatException {
        this.value = Byte.parseByte(string, 10);
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Byte) {
            return this.value == (Byte)object;
        }
        return false;
    }

    @Override
    public int compareTo(Byte by) {
        return this.value - by.value;
    }

    private static final class ByteCache {
        @Stable
        static final Byte[] cache;
        static Byte[] archivedCache;

        private ByteCache() {
        }

        static {
            int size = 256;
            CDS.initializeFromArchive(ByteCache.class);
            if (archivedCache == null || archivedCache.length != 256) {
                Byte[] c = new Byte[256];
                byte value = -128;
                for (int i = 0; i < 256; ++i) {
                    byte by = value;
                    value = (byte)(value + 1);
                    c[i] = new Byte(by);
                }
                archivedCache = c;
            }
            cache = archivedCache;
        }
    }
}

