/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jdk.internal.misc.CDS;
import jdk.internal.vm.annotation.Stable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Character
implements Serializable,
Comparable<Character> {
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX = 36;
    public static final char MIN_VALUE = '\u0000';
    public static final char MAX_VALUE = '\uffff';
    public static final Class<Character> TYPE = Class.getPrimitiveClass("char");
    public static final byte UNASSIGNED = 0;
    public static final byte UPPERCASE_LETTER = 1;
    public static final byte LOWERCASE_LETTER = 2;
    public static final byte TITLECASE_LETTER = 3;
    public static final byte MODIFIER_LETTER = 4;
    public static final byte OTHER_LETTER = 5;
    public static final byte NON_SPACING_MARK = 6;
    public static final byte ENCLOSING_MARK = 7;
    public static final byte COMBINING_SPACING_MARK = 8;
    public static final byte DECIMAL_DIGIT_NUMBER = 9;
    public static final byte LETTER_NUMBER = 10;
    public static final byte OTHER_NUMBER = 11;
    public static final byte SPACE_SEPARATOR = 12;
    public static final byte LINE_SEPARATOR = 13;
    public static final byte PARAGRAPH_SEPARATOR = 14;
    public static final byte CONTROL = 15;
    public static final byte FORMAT = 16;
    public static final byte PRIVATE_USE = 18;
    public static final byte SURROGATE = 19;
    public static final byte DASH_PUNCTUATION = 20;
    public static final byte START_PUNCTUATION = 21;
    public static final byte END_PUNCTUATION = 22;
    public static final byte CONNECTOR_PUNCTUATION = 23;
    public static final byte OTHER_PUNCTUATION = 24;
    public static final byte MATH_SYMBOL = 25;
    public static final byte CURRENCY_SYMBOL = 26;
    public static final byte MODIFIER_SYMBOL = 27;
    public static final byte OTHER_SYMBOL = 28;
    public static final byte INITIAL_QUOTE_PUNCTUATION = 29;
    public static final byte FINAL_QUOTE_PUNCTUATION = 30;
    static final int ERROR = -1;
    public static final byte DIRECTIONALITY_UNDEFINED = -1;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT = 0;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT = 1;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_ARABIC = 2;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER = 3;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_SEPARATOR = 4;
    public static final byte DIRECTIONALITY_EUROPEAN_NUMBER_TERMINATOR = 5;
    public static final byte DIRECTIONALITY_ARABIC_NUMBER = 6;
    public static final byte DIRECTIONALITY_COMMON_NUMBER_SEPARATOR = 7;
    public static final byte DIRECTIONALITY_NONSPACING_MARK = 8;
    public static final byte DIRECTIONALITY_BOUNDARY_NEUTRAL = 9;
    public static final byte DIRECTIONALITY_PARAGRAPH_SEPARATOR = 10;
    public static final byte DIRECTIONALITY_SEGMENT_SEPARATOR = 11;
    public static final byte DIRECTIONALITY_WHITESPACE = 12;
    public static final byte DIRECTIONALITY_OTHER_NEUTRALS = 13;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_EMBEDDING = 14;
    public static final byte DIRECTIONALITY_LEFT_TO_RIGHT_OVERRIDE = 15;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_EMBEDDING = 16;
    public static final byte DIRECTIONALITY_RIGHT_TO_LEFT_OVERRIDE = 17;
    public static final byte DIRECTIONALITY_POP_DIRECTIONAL_FORMAT = 18;
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    private final char value;
    private static final long serialVersionUID = 3786198910865385080L;
    private static final int FAST_PATH_MAX = 255;
    public static final int SIZE = 16;

    public Character(char c) {
        this.value = c;
    }

    public static Character valueOf(char c) {
        if (c <= '\u007f') {
            return CharacterCache.cache[c];
        }
        return new Character(c);
    }

    public char charValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof Character) {
            return this.value == ((Character)object).charValue();
        }
        return false;
    }

    public String toString() {
        char[] cArray = new char[]{this.value};
        return String.valueOf(cArray);
    }

    public static String toString(char c) {
        return String.valueOf(c);
    }

    private static int getPlane(int n) {
        return n >>> 16;
    }

    public static boolean isValidCodePoint(int n) {
        return n >= 0 && n <= 0x10FFFF;
    }

    public static boolean isSupplementaryCodePoint(int n) {
        return n >= 65536 && n <= 0x10FFFF;
    }

    public static boolean isHighSurrogate(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isLowSurrogate(char c) {
        return c >= '\udc00' && c <= '\udfff';
    }

    public static boolean isSurrogatePair(char c, char c2) {
        return Character.isHighSurrogate(c) && Character.isLowSurrogate(c2);
    }

    public static int charCount(int n) {
        return n >= 65536 ? 2 : 1;
    }

    public static int toCodePoint(char c, char c2) {
        return (c - 55296 << 10) + (c2 - 56320) + 65536;
    }

    public static int codePointAt(CharSequence charSequence, int n) {
        char c;
        char c2;
        if (Character.isHighSurrogate(c2 = charSequence.charAt(n++)) && n < charSequence.length() && Character.isLowSurrogate(c = charSequence.charAt(n))) {
            return Character.toCodePoint(c2, c);
        }
        return c2;
    }

    public static int codePointAt(char[] cArray, int n) {
        return Character.codePointAtImpl(cArray, n, cArray.length);
    }

    public static int codePointAt(char[] cArray, int n, int n2) {
        if (n >= n2 || n2 < 0 || n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointAtImpl(cArray, n, n2);
    }

    static int codePointAtImpl(char[] cArray, int n, int n2) {
        char c;
        char c2;
        if (Character.isHighSurrogate(c2 = cArray[n++]) && n < n2 && Character.isLowSurrogate(c = cArray[n])) {
            return Character.toCodePoint(c2, c);
        }
        return c2;
    }

    public static int codePointBefore(CharSequence charSequence, int n) {
        char c;
        char c2;
        if (Character.isLowSurrogate(c2 = charSequence.charAt(--n)) && n > 0 && Character.isHighSurrogate(c = charSequence.charAt(--n))) {
            return Character.toCodePoint(c, c2);
        }
        return c2;
    }

    public static int codePointBefore(char[] cArray, int n) {
        return Character.codePointBeforeImpl(cArray, n, 0);
    }

    public static int codePointBefore(char[] cArray, int n, int n2) {
        if (n <= n2 || n2 < 0 || n2 >= cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointBeforeImpl(cArray, n, n2);
    }

    static int codePointBeforeImpl(char[] cArray, int n, int n2) {
        char c;
        char c2;
        if (Character.isLowSurrogate(c2 = cArray[--n]) && n > n2 && Character.isHighSurrogate(c = cArray[--n])) {
            return Character.toCodePoint(c, c2);
        }
        return c2;
    }

    public static int toChars(int n, char[] cArray, int n2) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException();
        }
        if (n < 65536) {
            cArray[n2] = (char)n;
            return 1;
        }
        Character.toSurrogates(n, cArray, n2);
        return 2;
    }

    public static char[] toChars(int n) {
        if (n < 0 || n > 0x10FFFF) {
            throw new IllegalArgumentException();
        }
        if (n < 65536) {
            return new char[]{(char)n};
        }
        char[] cArray = new char[2];
        Character.toSurrogates(n, cArray, 0);
        return cArray;
    }

    static void toSurrogates(int n, char[] cArray, int n2) {
        int n3 = n - 65536;
        cArray[n2 + 1] = (char)((n3 & 0x3FF) + 56320);
        cArray[n2] = (char)((n3 >>> 10) + 55296);
    }

    public static int codePointCount(CharSequence charSequence, int n, int n2) {
        int n3 = charSequence.length();
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            ++n4;
            if (!Character.isHighSurrogate(charSequence.charAt(n5++)) || n5 >= n2 || !Character.isLowSurrogate(charSequence.charAt(n5))) continue;
            ++n5;
        }
        return n4;
    }

    public static int codePointCount(char[] cArray, int n, int n2) {
        if (n2 > cArray.length - n || n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(cArray, n, n2);
    }

    static int codePointCountImpl(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            ++n4;
            if (!Character.isHighSurrogate(cArray[n5++]) || n5 >= n3 || !Character.isLowSurrogate(cArray[n5])) continue;
            ++n5;
        }
        return n4;
    }

    public static int offsetByCodePoints(CharSequence charSequence, int n, int n2) {
        int n3 = charSequence.length();
        if (n < 0 || n > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n;
        if (n2 >= 0) {
            int n5;
            for (n5 = 0; n4 < n3 && n5 < n2; ++n5) {
                if (!Character.isHighSurrogate(charSequence.charAt(n4++)) || n4 >= n3 || !Character.isLowSurrogate(charSequence.charAt(n4))) continue;
                ++n4;
            }
            if (n5 < n2) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int n6;
            for (n6 = n2; n4 > 0 && n6 < 0; ++n6) {
                if (!Character.isLowSurrogate(charSequence.charAt(--n4)) || n4 <= 0 || !Character.isHighSurrogate(charSequence.charAt(n4 - 1))) continue;
                --n4;
            }
            if (n6 < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return n4;
    }

    public static int offsetByCodePoints(char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 > cArray.length - n || n < 0 || n2 < 0 || n3 < n || n3 > n + n2) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(cArray, n, n2, n3, n4);
    }

    static int offsetByCodePointsImpl(char[] cArray, int n, int n2, int n3, int n4) {
        int n5 = n3;
        if (n4 >= 0) {
            int n6;
            int n7 = n + n2;
            for (n6 = 0; n5 < n7 && n6 < n4; ++n6) {
                if (!Character.isHighSurrogate(cArray[n5++]) || n5 >= n7 || !Character.isLowSurrogate(cArray[n5])) continue;
                ++n5;
            }
            if (n6 < n4) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            int n8;
            for (n8 = n4; n5 > n && n8 < 0; ++n8) {
                if (!Character.isLowSurrogate(cArray[--n5]) || n5 <= n || !Character.isHighSurrogate(cArray[n5 - 1])) continue;
                --n5;
            }
            if (n8 < 0) {
                throw new IndexOutOfBoundsException();
            }
        }
        return n5;
    }

    public static boolean isLowerCase(char c) {
        return Character.isLowerCase((int)c);
    }

    public static boolean isLowerCase(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isLowerCase(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isLowerCase(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isLowerCase(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isLowerCase(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isLowerCase(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isLowerCase(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isLowerCase(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isUpperCase(char c) {
        return Character.isUpperCase((int)c);
    }

    public static boolean isUpperCase(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isUpperCase(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isUpperCase(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isUpperCase(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isUpperCase(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isUpperCase(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isUpperCase(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isUpperCase(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isTitleCase(char c) {
        return Character.isTitleCase((int)c);
    }

    public static boolean isTitleCase(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isTitleCase((int)n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isTitleCase((int)n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isTitleCase((int)n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isTitleCase((int)n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isTitleCase((int)n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isTitleCase((int)n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isTitleCase((int)n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isDigit(char c) {
        return Character.isDigit((int)c);
    }

    public static boolean isDigit(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isDigit(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isDigit(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isDigit(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isDigit(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isDigit(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isDigit(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isDigit(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isDefined(char c) {
        return Character.isDefined((int)c);
    }

    public static boolean isDefined(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isDefined((int)n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isDefined((int)n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isDefined((int)n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isDefined((int)n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isDefined((int)n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isDefined((int)n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isDefined((int)n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isLetter(char c) {
        return Character.isLetter((int)c);
    }

    public static boolean isLetter(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isLetter((int)n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isLetter((int)n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isLetter((int)n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isLetter((int)n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isLetter((int)n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isLetter((int)n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isLetter((int)n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit((int)c);
    }

    public static boolean isLetterOrDigit(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isLetterOrDigit((int)n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isLetterOrDigit((int)n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isLetterOrDigit((int)n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isLetterOrDigit((int)n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isLetterOrDigit((int)n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isLetterOrDigit((int)n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isLetterOrDigit((int)n);
                    break;
                }
            }
        }
        return bl;
    }

    @Deprecated
    public static boolean isJavaLetter(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    @Deprecated
    public static boolean isJavaLetterOrDigit(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public static boolean isJavaIdentifierStart(char c) {
        return Character.isJavaIdentifierStart((int)c);
    }

    public static boolean isJavaIdentifierStart(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isJavaIdentifierStart(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isJavaIdentifierStart(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isJavaIdentifierStart(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isJavaIdentifierStart(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isJavaIdentifierStart(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isJavaIdentifierStart(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isJavaIdentifierStart(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isJavaIdentifierPart(char c) {
        return Character.isJavaIdentifierPart((int)c);
    }

    public static boolean isJavaIdentifierPart(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isJavaIdentifierPart(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isJavaIdentifierPart(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isJavaIdentifierPart(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isJavaIdentifierPart(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isJavaIdentifierPart(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isJavaIdentifierPart(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isJavaIdentifierPart(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isUnicodeIdentifierStart(char c) {
        return Character.isUnicodeIdentifierStart((int)c);
    }

    public static boolean isUnicodeIdentifierStart(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isUnicodeIdentifierStart(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isUnicodeIdentifierStart(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isUnicodeIdentifierStart(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isUnicodeIdentifierStart(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isUnicodeIdentifierStart(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isUnicodeIdentifierStart(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isUnicodeIdentifierStart(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isUnicodeIdentifierPart(char c) {
        return Character.isUnicodeIdentifierPart((int)c);
    }

    public static boolean isUnicodeIdentifierPart(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isUnicodeIdentifierPart(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isUnicodeIdentifierPart(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isUnicodeIdentifierPart(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isUnicodeIdentifierPart(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isUnicodeIdentifierPart(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isUnicodeIdentifierPart(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isUnicodeIdentifierPart(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isIdentifierIgnorable(char c) {
        return Character.isIdentifierIgnorable((int)c);
    }

    public static boolean isIdentifierIgnorable(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isIdentifierIgnorable(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isIdentifierIgnorable(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isIdentifierIgnorable(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isIdentifierIgnorable(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isIdentifierIgnorable(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isIdentifierIgnorable(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isIdentifierIgnorable(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static char toLowerCase(char c) {
        return (char)Character.toLowerCase((int)c);
    }

    public static int toLowerCase(int n) {
        int n2 = n;
        int n3 = 0;
        if (n >= 0 && n <= 255) {
            n2 = CharacterDataLatin1.toLowerCase(n);
        } else {
            n3 = Character.getPlane(n);
            switch (n3) {
                case 0: {
                    n2 = CharacterData00.toLowerCase(n);
                    break;
                }
                case 1: {
                    n2 = CharacterData01.toLowerCase(n);
                    break;
                }
                case 2: {
                    n2 = CharacterData02.toLowerCase(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = CharacterDataUndefined.toLowerCase(n);
                    break;
                }
                case 14: {
                    n2 = CharacterData0E.toLowerCase(n);
                    break;
                }
                case 15: 
                case 16: {
                    n2 = CharacterDataPrivateUse.toLowerCase(n);
                    break;
                }
            }
        }
        return n2;
    }

    public static char toUpperCase(char c) {
        return (char)Character.toUpperCase((int)c);
    }

    public static int toUpperCase(int n) {
        int n2 = n;
        int n3 = 0;
        if (n >= 0 && n <= 255) {
            n2 = CharacterDataLatin1.toUpperCase(n);
        } else {
            n3 = Character.getPlane(n);
            switch (n3) {
                case 0: {
                    n2 = CharacterData00.toUpperCase(n);
                    break;
                }
                case 1: {
                    n2 = CharacterData01.toUpperCase(n);
                    break;
                }
                case 2: {
                    n2 = CharacterData02.toUpperCase(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = CharacterDataUndefined.toUpperCase(n);
                    break;
                }
                case 14: {
                    n2 = CharacterData0E.toUpperCase(n);
                    break;
                }
                case 15: 
                case 16: {
                    n2 = CharacterDataPrivateUse.toUpperCase(n);
                    break;
                }
            }
        }
        return n2;
    }

    public static char toTitleCase(char c) {
        return (char)Character.toTitleCase((int)c);
    }

    public static int toTitleCase(int n) {
        int n2 = n;
        int n3 = 0;
        if (n >= 0 && n <= 255) {
            n2 = CharacterDataLatin1.toTitleCase(n);
        } else {
            n3 = Character.getPlane(n);
            switch (n3) {
                case 0: {
                    n2 = CharacterData00.toTitleCase(n);
                    break;
                }
                case 1: {
                    n2 = CharacterData01.toTitleCase(n);
                    break;
                }
                case 2: {
                    n2 = CharacterData02.toTitleCase(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = CharacterDataUndefined.toTitleCase(n);
                    break;
                }
                case 14: {
                    n2 = CharacterData0E.toTitleCase(n);
                    break;
                }
                case 15: 
                case 16: {
                    n2 = CharacterDataPrivateUse.toTitleCase(n);
                    break;
                }
            }
        }
        return n2;
    }

    public static int digit(char c, int n) {
        return Character.digit((int)c, n);
    }

    public static int digit(int n, int n2) {
        int n3 = -1;
        if (n >= 0 && n <= 255) {
            n3 = CharacterDataLatin1.digit(n, n2);
        } else {
            int n4 = Character.getPlane(n);
            switch (n4) {
                case 0: {
                    n3 = CharacterData00.digit(n, n2);
                    break;
                }
                case 1: {
                    n3 = CharacterData01.digit(n, n2);
                    break;
                }
                case 2: {
                    n3 = CharacterData02.digit(n, n2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n3 = CharacterDataUndefined.digit(n, n2);
                    break;
                }
                case 14: {
                    n3 = CharacterData0E.digit(n, n2);
                    break;
                }
                case 15: 
                case 16: {
                    n3 = CharacterDataPrivateUse.digit(n, n2);
                    break;
                }
            }
        }
        return n3;
    }

    public static int getNumericValue(char c) {
        return Character.getNumericValue((int)c);
    }

    public static int getNumericValue(int n) {
        int n2 = -1;
        if (n >= 0 && n <= 255) {
            n2 = CharacterDataLatin1.getNumericValue(n);
        } else {
            int n3 = Character.getPlane(n);
            switch (n3) {
                case 0: {
                    n2 = CharacterData00.getNumericValue(n);
                    break;
                }
                case 1: {
                    n2 = CharacterData01.getNumericValue(n);
                    break;
                }
                case 2: {
                    n2 = CharacterData02.getNumericValue(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = CharacterDataUndefined.getNumericValue(n);
                    break;
                }
                case 14: {
                    n2 = CharacterData0E.getNumericValue(n);
                    break;
                }
                case 15: 
                case 16: {
                    n2 = CharacterDataPrivateUse.getNumericValue(n);
                    break;
                }
            }
        }
        return n2;
    }

    @Deprecated
    public static boolean isSpace(char c) {
        return c <= ' ' && (4294981120L >> c & 1L) != 0L;
    }

    public static boolean isSpaceChar(char c) {
        return Character.isSpaceChar((int)c);
    }

    public static boolean isSpaceChar(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isSpaceChar((int)n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isSpaceChar((int)n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isSpaceChar((int)n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isSpaceChar((int)n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isSpaceChar((int)n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isSpaceChar((int)n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isSpaceChar((int)n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace((int)c);
    }

    public static boolean isWhitespace(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isWhitespace(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isWhitespace(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isWhitespace(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isWhitespace(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isWhitespace(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isWhitespace(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isWhitespace(n);
                    break;
                }
            }
        }
        return bl;
    }

    public static boolean isISOControl(char c) {
        return Character.isISOControl((int)c);
    }

    public static boolean isISOControl(int n) {
        return n >= 0 && n <= 31 || n >= 127 && n <= 159;
    }

    public static int getType(char c) {
        return Character.getType((int)c);
    }

    public static int getType(int n) {
        int n2 = 0;
        if (n >= 0 && n <= 255) {
            n2 = CharacterDataLatin1.getType(n);
        } else {
            int n3 = Character.getPlane(n);
            switch (n3) {
                case 0: {
                    n2 = CharacterData00.getType(n);
                    break;
                }
                case 1: {
                    n2 = CharacterData01.getType(n);
                    break;
                }
                case 2: {
                    n2 = CharacterData02.getType(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = CharacterDataUndefined.getType(n);
                    break;
                }
                case 14: {
                    n2 = CharacterData0E.getType(n);
                    break;
                }
                case 15: 
                case 16: {
                    n2 = CharacterDataPrivateUse.getType(n);
                    break;
                }
            }
        }
        return n2;
    }

    public static char forDigit(int n, int n2) {
        if (n >= n2 || n < 0) {
            return '\u0000';
        }
        if (n2 < 2 || n2 > 36) {
            return '\u0000';
        }
        if (n < 10) {
            return (char)(48 + n);
        }
        return (char)(87 + n);
    }

    public static byte getDirectionality(char c) {
        return Character.getDirectionality((int)c);
    }

    public static byte getDirectionality(int n) {
        byte by = -1;
        if (n >= 0 && n <= 255) {
            by = CharacterDataLatin1.getDirectionality(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    by = CharacterData00.getDirectionality(n);
                    break;
                }
                case 1: {
                    by = CharacterData01.getDirectionality(n);
                    break;
                }
                case 2: {
                    by = CharacterData02.getDirectionality(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    by = CharacterDataUndefined.getDirectionality(n);
                    break;
                }
                case 14: {
                    by = CharacterData0E.getDirectionality(n);
                    break;
                }
                case 15: 
                case 16: {
                    by = CharacterDataPrivateUse.getDirectionality(n);
                    break;
                }
            }
        }
        return by;
    }

    public static boolean isMirrored(char c) {
        return Character.isMirrored((int)c);
    }

    public static boolean isMirrored(int n) {
        boolean bl = false;
        if (n >= 0 && n <= 255) {
            bl = CharacterDataLatin1.isMirrored(n);
        } else {
            int n2 = Character.getPlane(n);
            switch (n2) {
                case 0: {
                    bl = CharacterData00.isMirrored(n);
                    break;
                }
                case 1: {
                    bl = CharacterData01.isMirrored(n);
                    break;
                }
                case 2: {
                    bl = CharacterData02.isMirrored(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    bl = CharacterDataUndefined.isMirrored(n);
                    break;
                }
                case 14: {
                    bl = CharacterData0E.isMirrored(n);
                    break;
                }
                case 15: 
                case 16: {
                    bl = CharacterDataPrivateUse.isMirrored(n);
                    break;
                }
            }
        }
        return bl;
    }

    @Override
    public int compareTo(Character c) {
        return this.value - c.value;
    }

    static int toUpperCaseEx(int n) {
        int n2 = n;
        int n3 = 0;
        assert (Character.isValidCodePoint(n));
        if (n <= 255) {
            n2 = CharacterDataLatin1.toUpperCaseEx(n);
        } else {
            n3 = Character.getPlane(n);
            switch (n3) {
                case 0: {
                    n2 = CharacterData00.toUpperCaseEx(n);
                    break;
                }
                case 1: {
                    n2 = CharacterData01.toUpperCase(n);
                    break;
                }
                case 2: {
                    n2 = CharacterData02.toUpperCase(n);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = CharacterDataUndefined.toUpperCase(n);
                    break;
                }
                case 14: {
                    n2 = CharacterData0E.toUpperCase(n);
                    break;
                }
                case 15: 
                case 16: {
                    n2 = CharacterDataPrivateUse.toUpperCase(n);
                    break;
                }
            }
        }
        return n2;
    }

    static char[] toUpperCaseCharArray(int n) {
        char[] cArray = null;
        assert (Character.isValidCodePoint(n) && !Character.isSupplementaryCodePoint(n));
        cArray = n <= 255 ? CharacterDataLatin1.toUpperCaseCharArray(n) : CharacterData00.toUpperCaseCharArray(n);
        return cArray;
    }

    public static char reverseBytes(char c) {
        return (char)((c & 0xFF00) >> 8 | c << 8);
    }

    private static final class CharacterCache {
        @Stable
        static final Character[] cache;
        static Character[] archivedCache;

        private CharacterCache() {
        }

        static {
            int size = 128;
            CDS.initializeFromArchive(CharacterCache.class);
            if (archivedCache == null || archivedCache.length != size) {
                Character[] c = new Character[size];
                for (int i = 0; i < size; ++i) {
                    c[i] = new Character((char)i);
                }
                archivedCache = c;
            }
            cache = archivedCache;
        }
    }

    public static class Subset {
        private String name;

        protected Subset(String name) {
            if (name == null) {
                throw new NullPointerException("name");
            }
            this.name = name;
        }

        public final boolean equals(Object obj) {
            return this == obj;
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.name;
        }
    }

    public static final class UnicodeBlock
    extends Subset {
        private static final int NUM_ENTITIES = 756;
        private static Map<String, UnicodeBlock> map = HashMap.newHashMap(756);
        public static final UnicodeBlock BASIC_LATIN = new UnicodeBlock("BASIC_LATIN", "BASIC LATIN", "BASICLATIN");
        public static final UnicodeBlock LATIN_1_SUPPLEMENT = new UnicodeBlock("LATIN_1_SUPPLEMENT", "LATIN-1 SUPPLEMENT", "LATIN-1SUPPLEMENT");
        public static final UnicodeBlock LATIN_EXTENDED_A = new UnicodeBlock("LATIN_EXTENDED_A", "LATIN EXTENDED-A", "LATINEXTENDED-A");
        public static final UnicodeBlock LATIN_EXTENDED_B = new UnicodeBlock("LATIN_EXTENDED_B", "LATIN EXTENDED-B", "LATINEXTENDED-B");
        public static final UnicodeBlock IPA_EXTENSIONS = new UnicodeBlock("IPA_EXTENSIONS", "IPA EXTENSIONS", "IPAEXTENSIONS");
        public static final UnicodeBlock SPACING_MODIFIER_LETTERS = new UnicodeBlock("SPACING_MODIFIER_LETTERS", "SPACING MODIFIER LETTERS", "SPACINGMODIFIERLETTERS");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS", "COMBINING DIACRITICAL MARKS", "COMBININGDIACRITICALMARKS");
        public static final UnicodeBlock GREEK = new UnicodeBlock("GREEK", "GREEK AND COPTIC", "GREEKANDCOPTIC");
        public static final UnicodeBlock CYRILLIC = new UnicodeBlock("CYRILLIC");
        public static final UnicodeBlock ARMENIAN = new UnicodeBlock("ARMENIAN");
        public static final UnicodeBlock HEBREW = new UnicodeBlock("HEBREW");
        public static final UnicodeBlock ARABIC = new UnicodeBlock("ARABIC");
        public static final UnicodeBlock DEVANAGARI = new UnicodeBlock("DEVANAGARI");
        public static final UnicodeBlock BENGALI = new UnicodeBlock("BENGALI");
        public static final UnicodeBlock GURMUKHI = new UnicodeBlock("GURMUKHI");
        public static final UnicodeBlock GUJARATI = new UnicodeBlock("GUJARATI");
        public static final UnicodeBlock ORIYA = new UnicodeBlock("ORIYA");
        public static final UnicodeBlock TAMIL = new UnicodeBlock("TAMIL");
        public static final UnicodeBlock TELUGU = new UnicodeBlock("TELUGU");
        public static final UnicodeBlock KANNADA = new UnicodeBlock("KANNADA");
        public static final UnicodeBlock MALAYALAM = new UnicodeBlock("MALAYALAM");
        public static final UnicodeBlock THAI = new UnicodeBlock("THAI");
        public static final UnicodeBlock LAO = new UnicodeBlock("LAO");
        public static final UnicodeBlock TIBETAN = new UnicodeBlock("TIBETAN");
        public static final UnicodeBlock GEORGIAN = new UnicodeBlock("GEORGIAN");
        public static final UnicodeBlock HANGUL_JAMO = new UnicodeBlock("HANGUL_JAMO", "HANGUL JAMO", "HANGULJAMO");
        public static final UnicodeBlock LATIN_EXTENDED_ADDITIONAL = new UnicodeBlock("LATIN_EXTENDED_ADDITIONAL", "LATIN EXTENDED ADDITIONAL", "LATINEXTENDEDADDITIONAL");
        public static final UnicodeBlock GREEK_EXTENDED = new UnicodeBlock("GREEK_EXTENDED", "GREEK EXTENDED", "GREEKEXTENDED");
        public static final UnicodeBlock GENERAL_PUNCTUATION = new UnicodeBlock("GENERAL_PUNCTUATION", "GENERAL PUNCTUATION", "GENERALPUNCTUATION");
        public static final UnicodeBlock SUPERSCRIPTS_AND_SUBSCRIPTS = new UnicodeBlock("SUPERSCRIPTS_AND_SUBSCRIPTS", "SUPERSCRIPTS AND SUBSCRIPTS", "SUPERSCRIPTSANDSUBSCRIPTS");
        public static final UnicodeBlock CURRENCY_SYMBOLS = new UnicodeBlock("CURRENCY_SYMBOLS", "CURRENCY SYMBOLS", "CURRENCYSYMBOLS");
        public static final UnicodeBlock COMBINING_MARKS_FOR_SYMBOLS = new UnicodeBlock("COMBINING_MARKS_FOR_SYMBOLS", "COMBINING DIACRITICAL MARKS FOR SYMBOLS", "COMBININGDIACRITICALMARKSFORSYMBOLS", "COMBINING MARKS FOR SYMBOLS", "COMBININGMARKSFORSYMBOLS");
        public static final UnicodeBlock LETTERLIKE_SYMBOLS = new UnicodeBlock("LETTERLIKE_SYMBOLS", "LETTERLIKE SYMBOLS", "LETTERLIKESYMBOLS");
        public static final UnicodeBlock NUMBER_FORMS = new UnicodeBlock("NUMBER_FORMS", "NUMBER FORMS", "NUMBERFORMS");
        public static final UnicodeBlock ARROWS = new UnicodeBlock("ARROWS");
        public static final UnicodeBlock MATHEMATICAL_OPERATORS = new UnicodeBlock("MATHEMATICAL_OPERATORS", "MATHEMATICAL OPERATORS", "MATHEMATICALOPERATORS");
        public static final UnicodeBlock MISCELLANEOUS_TECHNICAL = new UnicodeBlock("MISCELLANEOUS_TECHNICAL", "MISCELLANEOUS TECHNICAL", "MISCELLANEOUSTECHNICAL");
        public static final UnicodeBlock CONTROL_PICTURES = new UnicodeBlock("CONTROL_PICTURES", "CONTROL PICTURES", "CONTROLPICTURES");
        public static final UnicodeBlock OPTICAL_CHARACTER_RECOGNITION = new UnicodeBlock("OPTICAL_CHARACTER_RECOGNITION", "OPTICAL CHARACTER RECOGNITION", "OPTICALCHARACTERRECOGNITION");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERICS = new UnicodeBlock("ENCLOSED_ALPHANUMERICS", "ENCLOSED ALPHANUMERICS", "ENCLOSEDALPHANUMERICS");
        public static final UnicodeBlock BOX_DRAWING = new UnicodeBlock("BOX_DRAWING", "BOX DRAWING", "BOXDRAWING");
        public static final UnicodeBlock BLOCK_ELEMENTS = new UnicodeBlock("BLOCK_ELEMENTS", "BLOCK ELEMENTS", "BLOCKELEMENTS");
        public static final UnicodeBlock GEOMETRIC_SHAPES = new UnicodeBlock("GEOMETRIC_SHAPES", "GEOMETRIC SHAPES", "GEOMETRICSHAPES");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS", "MISCELLANEOUS SYMBOLS", "MISCELLANEOUSSYMBOLS");
        public static final UnicodeBlock DINGBATS = new UnicodeBlock("DINGBATS");
        public static final UnicodeBlock CJK_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("CJK_SYMBOLS_AND_PUNCTUATION", "CJK SYMBOLS AND PUNCTUATION", "CJKSYMBOLSANDPUNCTUATION");
        public static final UnicodeBlock HIRAGANA = new UnicodeBlock("HIRAGANA");
        public static final UnicodeBlock KATAKANA = new UnicodeBlock("KATAKANA");
        public static final UnicodeBlock BOPOMOFO = new UnicodeBlock("BOPOMOFO");
        public static final UnicodeBlock HANGUL_COMPATIBILITY_JAMO = new UnicodeBlock("HANGUL_COMPATIBILITY_JAMO", "HANGUL COMPATIBILITY JAMO", "HANGULCOMPATIBILITYJAMO");
        public static final UnicodeBlock KANBUN = new UnicodeBlock("KANBUN");
        public static final UnicodeBlock ENCLOSED_CJK_LETTERS_AND_MONTHS = new UnicodeBlock("ENCLOSED_CJK_LETTERS_AND_MONTHS", "ENCLOSED CJK LETTERS AND MONTHS", "ENCLOSEDCJKLETTERSANDMONTHS");
        public static final UnicodeBlock CJK_COMPATIBILITY = new UnicodeBlock("CJK_COMPATIBILITY", "CJK COMPATIBILITY", "CJKCOMPATIBILITY");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS", "CJK UNIFIED IDEOGRAPHS", "CJKUNIFIEDIDEOGRAPHS");
        public static final UnicodeBlock HANGUL_SYLLABLES = new UnicodeBlock("HANGUL_SYLLABLES", "HANGUL SYLLABLES", "HANGULSYLLABLES");
        public static final UnicodeBlock PRIVATE_USE_AREA = new UnicodeBlock("PRIVATE_USE_AREA", "PRIVATE USE AREA", "PRIVATEUSEAREA");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS", "CJK COMPATIBILITY IDEOGRAPHS", "CJKCOMPATIBILITYIDEOGRAPHS");
        public static final UnicodeBlock ALPHABETIC_PRESENTATION_FORMS = new UnicodeBlock("ALPHABETIC_PRESENTATION_FORMS", "ALPHABETIC PRESENTATION FORMS", "ALPHABETICPRESENTATIONFORMS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_A = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_A", "ARABIC PRESENTATION FORMS-A", "ARABICPRESENTATIONFORMS-A");
        public static final UnicodeBlock COMBINING_HALF_MARKS = new UnicodeBlock("COMBINING_HALF_MARKS", "COMBINING HALF MARKS", "COMBININGHALFMARKS");
        public static final UnicodeBlock CJK_COMPATIBILITY_FORMS = new UnicodeBlock("CJK_COMPATIBILITY_FORMS", "CJK COMPATIBILITY FORMS", "CJKCOMPATIBILITYFORMS");
        public static final UnicodeBlock SMALL_FORM_VARIANTS = new UnicodeBlock("SMALL_FORM_VARIANTS", "SMALL FORM VARIANTS", "SMALLFORMVARIANTS");
        public static final UnicodeBlock ARABIC_PRESENTATION_FORMS_B = new UnicodeBlock("ARABIC_PRESENTATION_FORMS_B", "ARABIC PRESENTATION FORMS-B", "ARABICPRESENTATIONFORMS-B");
        public static final UnicodeBlock HALFWIDTH_AND_FULLWIDTH_FORMS = new UnicodeBlock("HALFWIDTH_AND_FULLWIDTH_FORMS", "HALFWIDTH AND FULLWIDTH FORMS", "HALFWIDTHANDFULLWIDTHFORMS");
        public static final UnicodeBlock SPECIALS = new UnicodeBlock("SPECIALS");
        @Deprecated(since="1.5")
        public static final UnicodeBlock SURROGATES_AREA = new UnicodeBlock("SURROGATES_AREA");
        public static final UnicodeBlock SYRIAC = new UnicodeBlock("SYRIAC");
        public static final UnicodeBlock THAANA = new UnicodeBlock("THAANA");
        public static final UnicodeBlock SINHALA = new UnicodeBlock("SINHALA");
        public static final UnicodeBlock MYANMAR = new UnicodeBlock("MYANMAR");
        public static final UnicodeBlock ETHIOPIC = new UnicodeBlock("ETHIOPIC");
        public static final UnicodeBlock CHEROKEE = new UnicodeBlock("CHEROKEE");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS", "UNIFIED CANADIAN ABORIGINAL SYLLABICS", "UNIFIEDCANADIANABORIGINALSYLLABICS");
        public static final UnicodeBlock OGHAM = new UnicodeBlock("OGHAM");
        public static final UnicodeBlock RUNIC = new UnicodeBlock("RUNIC");
        public static final UnicodeBlock KHMER = new UnicodeBlock("KHMER");
        public static final UnicodeBlock MONGOLIAN = new UnicodeBlock("MONGOLIAN");
        public static final UnicodeBlock BRAILLE_PATTERNS = new UnicodeBlock("BRAILLE_PATTERNS", "BRAILLE PATTERNS", "BRAILLEPATTERNS");
        public static final UnicodeBlock CJK_RADICALS_SUPPLEMENT = new UnicodeBlock("CJK_RADICALS_SUPPLEMENT", "CJK RADICALS SUPPLEMENT", "CJKRADICALSSUPPLEMENT");
        public static final UnicodeBlock KANGXI_RADICALS = new UnicodeBlock("KANGXI_RADICALS", "KANGXI RADICALS", "KANGXIRADICALS");
        public static final UnicodeBlock IDEOGRAPHIC_DESCRIPTION_CHARACTERS = new UnicodeBlock("IDEOGRAPHIC_DESCRIPTION_CHARACTERS", "IDEOGRAPHIC DESCRIPTION CHARACTERS", "IDEOGRAPHICDESCRIPTIONCHARACTERS");
        public static final UnicodeBlock BOPOMOFO_EXTENDED = new UnicodeBlock("BOPOMOFO_EXTENDED", "BOPOMOFO EXTENDED", "BOPOMOFOEXTENDED");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A", "CJK UNIFIED IDEOGRAPHS EXTENSION A", "CJKUNIFIEDIDEOGRAPHSEXTENSIONA");
        public static final UnicodeBlock YI_SYLLABLES = new UnicodeBlock("YI_SYLLABLES", "YI SYLLABLES", "YISYLLABLES");
        public static final UnicodeBlock YI_RADICALS = new UnicodeBlock("YI_RADICALS", "YI RADICALS", "YIRADICALS");
        public static final UnicodeBlock CYRILLIC_SUPPLEMENTARY = new UnicodeBlock("CYRILLIC_SUPPLEMENTARY", "CYRILLIC SUPPLEMENTARY", "CYRILLICSUPPLEMENTARY", "CYRILLIC SUPPLEMENT", "CYRILLICSUPPLEMENT");
        public static final UnicodeBlock TAGALOG = new UnicodeBlock("TAGALOG");
        public static final UnicodeBlock HANUNOO = new UnicodeBlock("HANUNOO");
        public static final UnicodeBlock BUHID = new UnicodeBlock("BUHID");
        public static final UnicodeBlock TAGBANWA = new UnicodeBlock("TAGBANWA");
        public static final UnicodeBlock LIMBU = new UnicodeBlock("LIMBU");
        public static final UnicodeBlock TAI_LE = new UnicodeBlock("TAI_LE", "TAI LE", "TAILE");
        public static final UnicodeBlock KHMER_SYMBOLS = new UnicodeBlock("KHMER_SYMBOLS", "KHMER SYMBOLS", "KHMERSYMBOLS");
        public static final UnicodeBlock PHONETIC_EXTENSIONS = new UnicodeBlock("PHONETIC_EXTENSIONS", "PHONETIC EXTENSIONS", "PHONETICEXTENSIONS");
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A", "MISCELLANEOUS MATHEMATICAL SYMBOLS-A", "MISCELLANEOUSMATHEMATICALSYMBOLS-A");
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_A = new UnicodeBlock("SUPPLEMENTAL_ARROWS_A", "SUPPLEMENTAL ARROWS-A", "SUPPLEMENTALARROWS-A");
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_B = new UnicodeBlock("SUPPLEMENTAL_ARROWS_B", "SUPPLEMENTAL ARROWS-B", "SUPPLEMENTALARROWS-B");
        public static final UnicodeBlock MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B = new UnicodeBlock("MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B", "MISCELLANEOUS MATHEMATICAL SYMBOLS-B", "MISCELLANEOUSMATHEMATICALSYMBOLS-B");
        public static final UnicodeBlock SUPPLEMENTAL_MATHEMATICAL_OPERATORS = new UnicodeBlock("SUPPLEMENTAL_MATHEMATICAL_OPERATORS", "SUPPLEMENTAL MATHEMATICAL OPERATORS", "SUPPLEMENTALMATHEMATICALOPERATORS");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_ARROWS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS_AND_ARROWS", "MISCELLANEOUS SYMBOLS AND ARROWS", "MISCELLANEOUSSYMBOLSANDARROWS");
        public static final UnicodeBlock KATAKANA_PHONETIC_EXTENSIONS = new UnicodeBlock("KATAKANA_PHONETIC_EXTENSIONS", "KATAKANA PHONETIC EXTENSIONS", "KATAKANAPHONETICEXTENSIONS");
        public static final UnicodeBlock YIJING_HEXAGRAM_SYMBOLS = new UnicodeBlock("YIJING_HEXAGRAM_SYMBOLS", "YIJING HEXAGRAM SYMBOLS", "YIJINGHEXAGRAMSYMBOLS");
        public static final UnicodeBlock VARIATION_SELECTORS = new UnicodeBlock("VARIATION_SELECTORS", "VARIATION SELECTORS", "VARIATIONSELECTORS");
        public static final UnicodeBlock LINEAR_B_SYLLABARY = new UnicodeBlock("LINEAR_B_SYLLABARY", "LINEAR B SYLLABARY", "LINEARBSYLLABARY");
        public static final UnicodeBlock LINEAR_B_IDEOGRAMS = new UnicodeBlock("LINEAR_B_IDEOGRAMS", "LINEAR B IDEOGRAMS", "LINEARBIDEOGRAMS");
        public static final UnicodeBlock AEGEAN_NUMBERS = new UnicodeBlock("AEGEAN_NUMBERS", "AEGEAN NUMBERS", "AEGEANNUMBERS");
        public static final UnicodeBlock OLD_ITALIC = new UnicodeBlock("OLD_ITALIC", "OLD ITALIC", "OLDITALIC");
        public static final UnicodeBlock GOTHIC = new UnicodeBlock("GOTHIC");
        public static final UnicodeBlock UGARITIC = new UnicodeBlock("UGARITIC");
        public static final UnicodeBlock DESERET = new UnicodeBlock("DESERET");
        public static final UnicodeBlock SHAVIAN = new UnicodeBlock("SHAVIAN");
        public static final UnicodeBlock OSMANYA = new UnicodeBlock("OSMANYA");
        public static final UnicodeBlock CYPRIOT_SYLLABARY = new UnicodeBlock("CYPRIOT_SYLLABARY", "CYPRIOT SYLLABARY", "CYPRIOTSYLLABARY");
        public static final UnicodeBlock BYZANTINE_MUSICAL_SYMBOLS = new UnicodeBlock("BYZANTINE_MUSICAL_SYMBOLS", "BYZANTINE MUSICAL SYMBOLS", "BYZANTINEMUSICALSYMBOLS");
        public static final UnicodeBlock MUSICAL_SYMBOLS = new UnicodeBlock("MUSICAL_SYMBOLS", "MUSICAL SYMBOLS", "MUSICALSYMBOLS");
        public static final UnicodeBlock TAI_XUAN_JING_SYMBOLS = new UnicodeBlock("TAI_XUAN_JING_SYMBOLS", "TAI XUAN JING SYMBOLS", "TAIXUANJINGSYMBOLS");
        public static final UnicodeBlock MATHEMATICAL_ALPHANUMERIC_SYMBOLS = new UnicodeBlock("MATHEMATICAL_ALPHANUMERIC_SYMBOLS", "MATHEMATICAL ALPHANUMERIC SYMBOLS", "MATHEMATICALALPHANUMERICSYMBOLS");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B", "CJK UNIFIED IDEOGRAPHS EXTENSION B", "CJKUNIFIEDIDEOGRAPHSEXTENSIONB");
        public static final UnicodeBlock CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT = new UnicodeBlock("CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT", "CJK COMPATIBILITY IDEOGRAPHS SUPPLEMENT", "CJKCOMPATIBILITYIDEOGRAPHSSUPPLEMENT");
        public static final UnicodeBlock TAGS = new UnicodeBlock("TAGS");
        public static final UnicodeBlock VARIATION_SELECTORS_SUPPLEMENT = new UnicodeBlock("VARIATION_SELECTORS_SUPPLEMENT", "VARIATION SELECTORS SUPPLEMENT", "VARIATIONSELECTORSSUPPLEMENT");
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_A = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_A", "SUPPLEMENTARY PRIVATE USE AREA-A", "SUPPLEMENTARYPRIVATEUSEAREA-A");
        public static final UnicodeBlock SUPPLEMENTARY_PRIVATE_USE_AREA_B = new UnicodeBlock("SUPPLEMENTARY_PRIVATE_USE_AREA_B", "SUPPLEMENTARY PRIVATE USE AREA-B", "SUPPLEMENTARYPRIVATEUSEAREA-B");
        public static final UnicodeBlock HIGH_SURROGATES = new UnicodeBlock("HIGH_SURROGATES", "HIGH SURROGATES", "HIGHSURROGATES");
        public static final UnicodeBlock HIGH_PRIVATE_USE_SURROGATES = new UnicodeBlock("HIGH_PRIVATE_USE_SURROGATES", "HIGH PRIVATE USE SURROGATES", "HIGHPRIVATEUSESURROGATES");
        public static final UnicodeBlock LOW_SURROGATES = new UnicodeBlock("LOW_SURROGATES", "LOW SURROGATES", "LOWSURROGATES");
        public static final UnicodeBlock ARABIC_SUPPLEMENT = new UnicodeBlock("ARABIC_SUPPLEMENT", "ARABIC SUPPLEMENT", "ARABICSUPPLEMENT");
        public static final UnicodeBlock NKO = new UnicodeBlock("NKO");
        public static final UnicodeBlock SAMARITAN = new UnicodeBlock("SAMARITAN");
        public static final UnicodeBlock MANDAIC = new UnicodeBlock("MANDAIC");
        public static final UnicodeBlock ETHIOPIC_SUPPLEMENT = new UnicodeBlock("ETHIOPIC_SUPPLEMENT", "ETHIOPIC SUPPLEMENT", "ETHIOPICSUPPLEMENT");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED", "UNIFIED CANADIAN ABORIGINAL SYLLABICS EXTENDED", "UNIFIEDCANADIANABORIGINALSYLLABICSEXTENDED");
        public static final UnicodeBlock NEW_TAI_LUE = new UnicodeBlock("NEW_TAI_LUE", "NEW TAI LUE", "NEWTAILUE");
        public static final UnicodeBlock BUGINESE = new UnicodeBlock("BUGINESE");
        public static final UnicodeBlock TAI_THAM = new UnicodeBlock("TAI_THAM", "TAI THAM", "TAITHAM");
        public static final UnicodeBlock BALINESE = new UnicodeBlock("BALINESE");
        public static final UnicodeBlock SUNDANESE = new UnicodeBlock("SUNDANESE");
        public static final UnicodeBlock BATAK = new UnicodeBlock("BATAK");
        public static final UnicodeBlock LEPCHA = new UnicodeBlock("LEPCHA");
        public static final UnicodeBlock OL_CHIKI = new UnicodeBlock("OL_CHIKI", "OL CHIKI", "OLCHIKI");
        public static final UnicodeBlock VEDIC_EXTENSIONS = new UnicodeBlock("VEDIC_EXTENSIONS", "VEDIC EXTENSIONS", "VEDICEXTENSIONS");
        public static final UnicodeBlock PHONETIC_EXTENSIONS_SUPPLEMENT = new UnicodeBlock("PHONETIC_EXTENSIONS_SUPPLEMENT", "PHONETIC EXTENSIONS SUPPLEMENT", "PHONETICEXTENSIONSSUPPLEMENT");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS_SUPPLEMENT = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS_SUPPLEMENT", "COMBINING DIACRITICAL MARKS SUPPLEMENT", "COMBININGDIACRITICALMARKSSUPPLEMENT");
        public static final UnicodeBlock GLAGOLITIC = new UnicodeBlock("GLAGOLITIC");
        public static final UnicodeBlock LATIN_EXTENDED_C = new UnicodeBlock("LATIN_EXTENDED_C", "LATIN EXTENDED-C", "LATINEXTENDED-C");
        public static final UnicodeBlock COPTIC = new UnicodeBlock("COPTIC");
        public static final UnicodeBlock GEORGIAN_SUPPLEMENT = new UnicodeBlock("GEORGIAN_SUPPLEMENT", "GEORGIAN SUPPLEMENT", "GEORGIANSUPPLEMENT");
        public static final UnicodeBlock TIFINAGH = new UnicodeBlock("TIFINAGH");
        public static final UnicodeBlock ETHIOPIC_EXTENDED = new UnicodeBlock("ETHIOPIC_EXTENDED", "ETHIOPIC EXTENDED", "ETHIOPICEXTENDED");
        public static final UnicodeBlock CYRILLIC_EXTENDED_A = new UnicodeBlock("CYRILLIC_EXTENDED_A", "CYRILLIC EXTENDED-A", "CYRILLICEXTENDED-A");
        public static final UnicodeBlock SUPPLEMENTAL_PUNCTUATION = new UnicodeBlock("SUPPLEMENTAL_PUNCTUATION", "SUPPLEMENTAL PUNCTUATION", "SUPPLEMENTALPUNCTUATION");
        public static final UnicodeBlock CJK_STROKES = new UnicodeBlock("CJK_STROKES", "CJK STROKES", "CJKSTROKES");
        public static final UnicodeBlock LISU = new UnicodeBlock("LISU");
        public static final UnicodeBlock VAI = new UnicodeBlock("VAI");
        public static final UnicodeBlock CYRILLIC_EXTENDED_B = new UnicodeBlock("CYRILLIC_EXTENDED_B", "CYRILLIC EXTENDED-B", "CYRILLICEXTENDED-B");
        public static final UnicodeBlock BAMUM = new UnicodeBlock("BAMUM");
        public static final UnicodeBlock MODIFIER_TONE_LETTERS = new UnicodeBlock("MODIFIER_TONE_LETTERS", "MODIFIER TONE LETTERS", "MODIFIERTONELETTERS");
        public static final UnicodeBlock LATIN_EXTENDED_D = new UnicodeBlock("LATIN_EXTENDED_D", "LATIN EXTENDED-D", "LATINEXTENDED-D");
        public static final UnicodeBlock SYLOTI_NAGRI = new UnicodeBlock("SYLOTI_NAGRI", "SYLOTI NAGRI", "SYLOTINAGRI");
        public static final UnicodeBlock COMMON_INDIC_NUMBER_FORMS = new UnicodeBlock("COMMON_INDIC_NUMBER_FORMS", "COMMON INDIC NUMBER FORMS", "COMMONINDICNUMBERFORMS");
        public static final UnicodeBlock PHAGS_PA = new UnicodeBlock("PHAGS_PA", "PHAGS-PA");
        public static final UnicodeBlock SAURASHTRA = new UnicodeBlock("SAURASHTRA");
        public static final UnicodeBlock DEVANAGARI_EXTENDED = new UnicodeBlock("DEVANAGARI_EXTENDED", "DEVANAGARI EXTENDED", "DEVANAGARIEXTENDED");
        public static final UnicodeBlock KAYAH_LI = new UnicodeBlock("KAYAH_LI", "KAYAH LI", "KAYAHLI");
        public static final UnicodeBlock REJANG = new UnicodeBlock("REJANG");
        public static final UnicodeBlock HANGUL_JAMO_EXTENDED_A = new UnicodeBlock("HANGUL_JAMO_EXTENDED_A", "HANGUL JAMO EXTENDED-A", "HANGULJAMOEXTENDED-A");
        public static final UnicodeBlock JAVANESE = new UnicodeBlock("JAVANESE");
        public static final UnicodeBlock CHAM = new UnicodeBlock("CHAM");
        public static final UnicodeBlock MYANMAR_EXTENDED_A = new UnicodeBlock("MYANMAR_EXTENDED_A", "MYANMAR EXTENDED-A", "MYANMAREXTENDED-A");
        public static final UnicodeBlock TAI_VIET = new UnicodeBlock("TAI_VIET", "TAI VIET", "TAIVIET");
        public static final UnicodeBlock ETHIOPIC_EXTENDED_A = new UnicodeBlock("ETHIOPIC_EXTENDED_A", "ETHIOPIC EXTENDED-A", "ETHIOPICEXTENDED-A");
        public static final UnicodeBlock MEETEI_MAYEK = new UnicodeBlock("MEETEI_MAYEK", "MEETEI MAYEK", "MEETEIMAYEK");
        public static final UnicodeBlock HANGUL_JAMO_EXTENDED_B = new UnicodeBlock("HANGUL_JAMO_EXTENDED_B", "HANGUL JAMO EXTENDED-B", "HANGULJAMOEXTENDED-B");
        public static final UnicodeBlock VERTICAL_FORMS = new UnicodeBlock("VERTICAL_FORMS", "VERTICAL FORMS", "VERTICALFORMS");
        public static final UnicodeBlock ANCIENT_GREEK_NUMBERS = new UnicodeBlock("ANCIENT_GREEK_NUMBERS", "ANCIENT GREEK NUMBERS", "ANCIENTGREEKNUMBERS");
        public static final UnicodeBlock ANCIENT_SYMBOLS = new UnicodeBlock("ANCIENT_SYMBOLS", "ANCIENT SYMBOLS", "ANCIENTSYMBOLS");
        public static final UnicodeBlock PHAISTOS_DISC = new UnicodeBlock("PHAISTOS_DISC", "PHAISTOS DISC", "PHAISTOSDISC");
        public static final UnicodeBlock LYCIAN = new UnicodeBlock("LYCIAN");
        public static final UnicodeBlock CARIAN = new UnicodeBlock("CARIAN");
        public static final UnicodeBlock OLD_PERSIAN = new UnicodeBlock("OLD_PERSIAN", "OLD PERSIAN", "OLDPERSIAN");
        public static final UnicodeBlock IMPERIAL_ARAMAIC = new UnicodeBlock("IMPERIAL_ARAMAIC", "IMPERIAL ARAMAIC", "IMPERIALARAMAIC");
        public static final UnicodeBlock PHOENICIAN = new UnicodeBlock("PHOENICIAN");
        public static final UnicodeBlock LYDIAN = new UnicodeBlock("LYDIAN");
        public static final UnicodeBlock KHAROSHTHI = new UnicodeBlock("KHAROSHTHI");
        public static final UnicodeBlock OLD_SOUTH_ARABIAN = new UnicodeBlock("OLD_SOUTH_ARABIAN", "OLD SOUTH ARABIAN", "OLDSOUTHARABIAN");
        public static final UnicodeBlock AVESTAN = new UnicodeBlock("AVESTAN");
        public static final UnicodeBlock INSCRIPTIONAL_PARTHIAN = new UnicodeBlock("INSCRIPTIONAL_PARTHIAN", "INSCRIPTIONAL PARTHIAN", "INSCRIPTIONALPARTHIAN");
        public static final UnicodeBlock INSCRIPTIONAL_PAHLAVI = new UnicodeBlock("INSCRIPTIONAL_PAHLAVI", "INSCRIPTIONAL PAHLAVI", "INSCRIPTIONALPAHLAVI");
        public static final UnicodeBlock OLD_TURKIC = new UnicodeBlock("OLD_TURKIC", "OLD TURKIC", "OLDTURKIC");
        public static final UnicodeBlock RUMI_NUMERAL_SYMBOLS = new UnicodeBlock("RUMI_NUMERAL_SYMBOLS", "RUMI NUMERAL SYMBOLS", "RUMINUMERALSYMBOLS");
        public static final UnicodeBlock BRAHMI = new UnicodeBlock("BRAHMI");
        public static final UnicodeBlock KAITHI = new UnicodeBlock("KAITHI");
        public static final UnicodeBlock CUNEIFORM = new UnicodeBlock("CUNEIFORM");
        public static final UnicodeBlock CUNEIFORM_NUMBERS_AND_PUNCTUATION = new UnicodeBlock("CUNEIFORM_NUMBERS_AND_PUNCTUATION", "CUNEIFORM NUMBERS AND PUNCTUATION", "CUNEIFORMNUMBERSANDPUNCTUATION");
        public static final UnicodeBlock EGYPTIAN_HIEROGLYPHS = new UnicodeBlock("EGYPTIAN_HIEROGLYPHS", "EGYPTIAN HIEROGLYPHS", "EGYPTIANHIEROGLYPHS");
        public static final UnicodeBlock BAMUM_SUPPLEMENT = new UnicodeBlock("BAMUM_SUPPLEMENT", "BAMUM SUPPLEMENT", "BAMUMSUPPLEMENT");
        public static final UnicodeBlock KANA_SUPPLEMENT = new UnicodeBlock("KANA_SUPPLEMENT", "KANA SUPPLEMENT", "KANASUPPLEMENT");
        public static final UnicodeBlock ANCIENT_GREEK_MUSICAL_NOTATION = new UnicodeBlock("ANCIENT_GREEK_MUSICAL_NOTATION", "ANCIENT GREEK MUSICAL NOTATION", "ANCIENTGREEKMUSICALNOTATION");
        public static final UnicodeBlock COUNTING_ROD_NUMERALS = new UnicodeBlock("COUNTING_ROD_NUMERALS", "COUNTING ROD NUMERALS", "COUNTINGRODNUMERALS");
        public static final UnicodeBlock MAHJONG_TILES = new UnicodeBlock("MAHJONG_TILES", "MAHJONG TILES", "MAHJONGTILES");
        public static final UnicodeBlock DOMINO_TILES = new UnicodeBlock("DOMINO_TILES", "DOMINO TILES", "DOMINOTILES");
        public static final UnicodeBlock PLAYING_CARDS = new UnicodeBlock("PLAYING_CARDS", "PLAYING CARDS", "PLAYINGCARDS");
        public static final UnicodeBlock ENCLOSED_ALPHANUMERIC_SUPPLEMENT = new UnicodeBlock("ENCLOSED_ALPHANUMERIC_SUPPLEMENT", "ENCLOSED ALPHANUMERIC SUPPLEMENT", "ENCLOSEDALPHANUMERICSUPPLEMENT");
        public static final UnicodeBlock ENCLOSED_IDEOGRAPHIC_SUPPLEMENT = new UnicodeBlock("ENCLOSED_IDEOGRAPHIC_SUPPLEMENT", "ENCLOSED IDEOGRAPHIC SUPPLEMENT", "ENCLOSEDIDEOGRAPHICSUPPLEMENT");
        public static final UnicodeBlock MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS = new UnicodeBlock("MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS", "MISCELLANEOUS SYMBOLS AND PICTOGRAPHS", "MISCELLANEOUSSYMBOLSANDPICTOGRAPHS");
        public static final UnicodeBlock EMOTICONS = new UnicodeBlock("EMOTICONS");
        public static final UnicodeBlock TRANSPORT_AND_MAP_SYMBOLS = new UnicodeBlock("TRANSPORT_AND_MAP_SYMBOLS", "TRANSPORT AND MAP SYMBOLS", "TRANSPORTANDMAPSYMBOLS");
        public static final UnicodeBlock ALCHEMICAL_SYMBOLS = new UnicodeBlock("ALCHEMICAL_SYMBOLS", "ALCHEMICAL SYMBOLS", "ALCHEMICALSYMBOLS");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C", "CJK UNIFIED IDEOGRAPHS EXTENSION C", "CJKUNIFIEDIDEOGRAPHSEXTENSIONC");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D", "CJK UNIFIED IDEOGRAPHS EXTENSION D", "CJKUNIFIEDIDEOGRAPHSEXTENSIOND");
        public static final UnicodeBlock ARABIC_EXTENDED_A = new UnicodeBlock("ARABIC_EXTENDED_A", "ARABIC EXTENDED-A", "ARABICEXTENDED-A");
        public static final UnicodeBlock SUNDANESE_SUPPLEMENT = new UnicodeBlock("SUNDANESE_SUPPLEMENT", "SUNDANESE SUPPLEMENT", "SUNDANESESUPPLEMENT");
        public static final UnicodeBlock MEETEI_MAYEK_EXTENSIONS = new UnicodeBlock("MEETEI_MAYEK_EXTENSIONS", "MEETEI MAYEK EXTENSIONS", "MEETEIMAYEKEXTENSIONS");
        public static final UnicodeBlock MEROITIC_HIEROGLYPHS = new UnicodeBlock("MEROITIC_HIEROGLYPHS", "MEROITIC HIEROGLYPHS", "MEROITICHIEROGLYPHS");
        public static final UnicodeBlock MEROITIC_CURSIVE = new UnicodeBlock("MEROITIC_CURSIVE", "MEROITIC CURSIVE", "MEROITICCURSIVE");
        public static final UnicodeBlock SORA_SOMPENG = new UnicodeBlock("SORA_SOMPENG", "SORA SOMPENG", "SORASOMPENG");
        public static final UnicodeBlock CHAKMA = new UnicodeBlock("CHAKMA");
        public static final UnicodeBlock SHARADA = new UnicodeBlock("SHARADA");
        public static final UnicodeBlock TAKRI = new UnicodeBlock("TAKRI");
        public static final UnicodeBlock MIAO = new UnicodeBlock("MIAO");
        public static final UnicodeBlock ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS = new UnicodeBlock("ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS", "ARABIC MATHEMATICAL ALPHABETIC SYMBOLS", "ARABICMATHEMATICALALPHABETICSYMBOLS");
        public static final UnicodeBlock COMBINING_DIACRITICAL_MARKS_EXTENDED = new UnicodeBlock("COMBINING_DIACRITICAL_MARKS_EXTENDED", "COMBINING DIACRITICAL MARKS EXTENDED", "COMBININGDIACRITICALMARKSEXTENDED");
        public static final UnicodeBlock MYANMAR_EXTENDED_B = new UnicodeBlock("MYANMAR_EXTENDED_B", "MYANMAR EXTENDED-B", "MYANMAREXTENDED-B");
        public static final UnicodeBlock LATIN_EXTENDED_E = new UnicodeBlock("LATIN_EXTENDED_E", "LATIN EXTENDED-E", "LATINEXTENDED-E");
        public static final UnicodeBlock COPTIC_EPACT_NUMBERS = new UnicodeBlock("COPTIC_EPACT_NUMBERS", "COPTIC EPACT NUMBERS", "COPTICEPACTNUMBERS");
        public static final UnicodeBlock OLD_PERMIC = new UnicodeBlock("OLD_PERMIC", "OLD PERMIC", "OLDPERMIC");
        public static final UnicodeBlock ELBASAN = new UnicodeBlock("ELBASAN");
        public static final UnicodeBlock CAUCASIAN_ALBANIAN = new UnicodeBlock("CAUCASIAN_ALBANIAN", "CAUCASIAN ALBANIAN", "CAUCASIANALBANIAN");
        public static final UnicodeBlock LINEAR_A = new UnicodeBlock("LINEAR_A", "LINEAR A", "LINEARA");
        public static final UnicodeBlock PALMYRENE = new UnicodeBlock("PALMYRENE");
        public static final UnicodeBlock NABATAEAN = new UnicodeBlock("NABATAEAN");
        public static final UnicodeBlock OLD_NORTH_ARABIAN = new UnicodeBlock("OLD_NORTH_ARABIAN", "OLD NORTH ARABIAN", "OLDNORTHARABIAN");
        public static final UnicodeBlock MANICHAEAN = new UnicodeBlock("MANICHAEAN");
        public static final UnicodeBlock PSALTER_PAHLAVI = new UnicodeBlock("PSALTER_PAHLAVI", "PSALTER PAHLAVI", "PSALTERPAHLAVI");
        public static final UnicodeBlock MAHAJANI = new UnicodeBlock("MAHAJANI");
        public static final UnicodeBlock SINHALA_ARCHAIC_NUMBERS = new UnicodeBlock("SINHALA_ARCHAIC_NUMBERS", "SINHALA ARCHAIC NUMBERS", "SINHALAARCHAICNUMBERS");
        public static final UnicodeBlock KHOJKI = new UnicodeBlock("KHOJKI");
        public static final UnicodeBlock KHUDAWADI = new UnicodeBlock("KHUDAWADI");
        public static final UnicodeBlock GRANTHA = new UnicodeBlock("GRANTHA");
        public static final UnicodeBlock TIRHUTA = new UnicodeBlock("TIRHUTA");
        public static final UnicodeBlock SIDDHAM = new UnicodeBlock("SIDDHAM");
        public static final UnicodeBlock MODI = new UnicodeBlock("MODI");
        public static final UnicodeBlock WARANG_CITI = new UnicodeBlock("WARANG_CITI", "WARANG CITI", "WARANGCITI");
        public static final UnicodeBlock PAU_CIN_HAU = new UnicodeBlock("PAU_CIN_HAU", "PAU CIN HAU", "PAUCINHAU");
        public static final UnicodeBlock MRO = new UnicodeBlock("MRO");
        public static final UnicodeBlock BASSA_VAH = new UnicodeBlock("BASSA_VAH", "BASSA VAH", "BASSAVAH");
        public static final UnicodeBlock PAHAWH_HMONG = new UnicodeBlock("PAHAWH_HMONG", "PAHAWH HMONG", "PAHAWHHMONG");
        public static final UnicodeBlock DUPLOYAN = new UnicodeBlock("DUPLOYAN");
        public static final UnicodeBlock SHORTHAND_FORMAT_CONTROLS = new UnicodeBlock("SHORTHAND_FORMAT_CONTROLS", "SHORTHAND FORMAT CONTROLS", "SHORTHANDFORMATCONTROLS");
        public static final UnicodeBlock MENDE_KIKAKUI = new UnicodeBlock("MENDE_KIKAKUI", "MENDE KIKAKUI", "MENDEKIKAKUI");
        public static final UnicodeBlock ORNAMENTAL_DINGBATS = new UnicodeBlock("ORNAMENTAL_DINGBATS", "ORNAMENTAL DINGBATS", "ORNAMENTALDINGBATS");
        public static final UnicodeBlock GEOMETRIC_SHAPES_EXTENDED = new UnicodeBlock("GEOMETRIC_SHAPES_EXTENDED", "GEOMETRIC SHAPES EXTENDED", "GEOMETRICSHAPESEXTENDED");
        public static final UnicodeBlock SUPPLEMENTAL_ARROWS_C = new UnicodeBlock("SUPPLEMENTAL_ARROWS_C", "SUPPLEMENTAL ARROWS-C", "SUPPLEMENTALARROWS-C");
        public static final UnicodeBlock CHEROKEE_SUPPLEMENT = new UnicodeBlock("CHEROKEE_SUPPLEMENT", "CHEROKEE SUPPLEMENT", "CHEROKEESUPPLEMENT");
        public static final UnicodeBlock HATRAN = new UnicodeBlock("HATRAN");
        public static final UnicodeBlock OLD_HUNGARIAN = new UnicodeBlock("OLD_HUNGARIAN", "OLD HUNGARIAN", "OLDHUNGARIAN");
        public static final UnicodeBlock MULTANI = new UnicodeBlock("MULTANI");
        public static final UnicodeBlock AHOM = new UnicodeBlock("AHOM");
        public static final UnicodeBlock EARLY_DYNASTIC_CUNEIFORM = new UnicodeBlock("EARLY_DYNASTIC_CUNEIFORM", "EARLY DYNASTIC CUNEIFORM", "EARLYDYNASTICCUNEIFORM");
        public static final UnicodeBlock ANATOLIAN_HIEROGLYPHS = new UnicodeBlock("ANATOLIAN_HIEROGLYPHS", "ANATOLIAN HIEROGLYPHS", "ANATOLIANHIEROGLYPHS");
        public static final UnicodeBlock SUTTON_SIGNWRITING = new UnicodeBlock("SUTTON_SIGNWRITING", "SUTTON SIGNWRITING", "SUTTONSIGNWRITING");
        public static final UnicodeBlock SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS = new UnicodeBlock("SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS", "SUPPLEMENTAL SYMBOLS AND PICTOGRAPHS", "SUPPLEMENTALSYMBOLSANDPICTOGRAPHS");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E", "CJK UNIFIED IDEOGRAPHS EXTENSION E", "CJKUNIFIEDIDEOGRAPHSEXTENSIONE");
        public static final UnicodeBlock SYRIAC_SUPPLEMENT = new UnicodeBlock("SYRIAC_SUPPLEMENT", "SYRIAC SUPPLEMENT", "SYRIACSUPPLEMENT");
        public static final UnicodeBlock CYRILLIC_EXTENDED_C = new UnicodeBlock("CYRILLIC_EXTENDED_C", "CYRILLIC EXTENDED-C", "CYRILLICEXTENDED-C");
        public static final UnicodeBlock OSAGE = new UnicodeBlock("OSAGE");
        public static final UnicodeBlock NEWA = new UnicodeBlock("NEWA");
        public static final UnicodeBlock MONGOLIAN_SUPPLEMENT = new UnicodeBlock("MONGOLIAN_SUPPLEMENT", "MONGOLIAN SUPPLEMENT", "MONGOLIANSUPPLEMENT");
        public static final UnicodeBlock MARCHEN = new UnicodeBlock("MARCHEN");
        public static final UnicodeBlock IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION = new UnicodeBlock("IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION", "IDEOGRAPHIC SYMBOLS AND PUNCTUATION", "IDEOGRAPHICSYMBOLSANDPUNCTUATION");
        public static final UnicodeBlock TANGUT = new UnicodeBlock("TANGUT");
        public static final UnicodeBlock TANGUT_COMPONENTS = new UnicodeBlock("TANGUT_COMPONENTS", "TANGUT COMPONENTS", "TANGUTCOMPONENTS");
        public static final UnicodeBlock KANA_EXTENDED_A = new UnicodeBlock("KANA_EXTENDED_A", "KANA EXTENDED-A", "KANAEXTENDED-A");
        public static final UnicodeBlock GLAGOLITIC_SUPPLEMENT = new UnicodeBlock("GLAGOLITIC_SUPPLEMENT", "GLAGOLITIC SUPPLEMENT", "GLAGOLITICSUPPLEMENT");
        public static final UnicodeBlock ADLAM = new UnicodeBlock("ADLAM");
        public static final UnicodeBlock MASARAM_GONDI = new UnicodeBlock("MASARAM_GONDI", "MASARAM GONDI", "MASARAMGONDI");
        public static final UnicodeBlock ZANABAZAR_SQUARE = new UnicodeBlock("ZANABAZAR_SQUARE", "ZANABAZAR SQUARE", "ZANABAZARSQUARE");
        public static final UnicodeBlock NUSHU = new UnicodeBlock("NUSHU");
        public static final UnicodeBlock SOYOMBO = new UnicodeBlock("SOYOMBO");
        public static final UnicodeBlock BHAIKSUKI = new UnicodeBlock("BHAIKSUKI");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F", "CJK UNIFIED IDEOGRAPHS EXTENSION F", "CJKUNIFIEDIDEOGRAPHSEXTENSIONF");
        public static final UnicodeBlock GEORGIAN_EXTENDED = new UnicodeBlock("GEORGIAN_EXTENDED", "GEORGIAN EXTENDED", "GEORGIANEXTENDED");
        public static final UnicodeBlock HANIFI_ROHINGYA = new UnicodeBlock("HANIFI_ROHINGYA", "HANIFI ROHINGYA", "HANIFIROHINGYA");
        public static final UnicodeBlock OLD_SOGDIAN = new UnicodeBlock("OLD_SOGDIAN", "OLD SOGDIAN", "OLDSOGDIAN");
        public static final UnicodeBlock SOGDIAN = new UnicodeBlock("SOGDIAN");
        public static final UnicodeBlock DOGRA = new UnicodeBlock("DOGRA");
        public static final UnicodeBlock GUNJALA_GONDI = new UnicodeBlock("GUNJALA_GONDI", "GUNJALA GONDI", "GUNJALAGONDI");
        public static final UnicodeBlock MAKASAR = new UnicodeBlock("MAKASAR");
        public static final UnicodeBlock MEDEFAIDRIN = new UnicodeBlock("MEDEFAIDRIN");
        public static final UnicodeBlock MAYAN_NUMERALS = new UnicodeBlock("MAYAN_NUMERALS", "MAYAN NUMERALS", "MAYANNUMERALS");
        public static final UnicodeBlock INDIC_SIYAQ_NUMBERS = new UnicodeBlock("INDIC_SIYAQ_NUMBERS", "INDIC SIYAQ NUMBERS", "INDICSIYAQNUMBERS");
        public static final UnicodeBlock CHESS_SYMBOLS = new UnicodeBlock("CHESS_SYMBOLS", "CHESS SYMBOLS", "CHESSSYMBOLS");
        public static final UnicodeBlock ELYMAIC = new UnicodeBlock("ELYMAIC");
        public static final UnicodeBlock NANDINAGARI = new UnicodeBlock("NANDINAGARI");
        public static final UnicodeBlock TAMIL_SUPPLEMENT = new UnicodeBlock("TAMIL_SUPPLEMENT", "TAMIL SUPPLEMENT", "TAMILSUPPLEMENT");
        public static final UnicodeBlock EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS = new UnicodeBlock("EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS", "EGYPTIAN HIEROGLYPH FORMAT CONTROLS", "EGYPTIANHIEROGLYPHFORMATCONTROLS");
        public static final UnicodeBlock SMALL_KANA_EXTENSION = new UnicodeBlock("SMALL_KANA_EXTENSION", "SMALL KANA EXTENSION", "SMALLKANAEXTENSION");
        public static final UnicodeBlock NYIAKENG_PUACHUE_HMONG = new UnicodeBlock("NYIAKENG_PUACHUE_HMONG", "NYIAKENG PUACHUE HMONG", "NYIAKENGPUACHUEHMONG");
        public static final UnicodeBlock WANCHO = new UnicodeBlock("WANCHO");
        public static final UnicodeBlock OTTOMAN_SIYAQ_NUMBERS = new UnicodeBlock("OTTOMAN_SIYAQ_NUMBERS", "OTTOMAN SIYAQ NUMBERS", "OTTOMANSIYAQNUMBERS");
        public static final UnicodeBlock SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A = new UnicodeBlock("SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A", "SYMBOLS AND PICTOGRAPHS EXTENDED-A", "SYMBOLSANDPICTOGRAPHSEXTENDED-A");
        public static final UnicodeBlock YEZIDI = new UnicodeBlock("YEZIDI");
        public static final UnicodeBlock CHORASMIAN = new UnicodeBlock("CHORASMIAN");
        public static final UnicodeBlock DIVES_AKURU = new UnicodeBlock("DIVES_AKURU", "DIVES AKURU", "DIVESAKURU");
        public static final UnicodeBlock LISU_SUPPLEMENT = new UnicodeBlock("LISU_SUPPLEMENT", "LISU SUPPLEMENT", "LISUSUPPLEMENT");
        public static final UnicodeBlock KHITAN_SMALL_SCRIPT = new UnicodeBlock("KHITAN_SMALL_SCRIPT", "KHITAN SMALL SCRIPT", "KHITANSMALLSCRIPT");
        public static final UnicodeBlock TANGUT_SUPPLEMENT = new UnicodeBlock("TANGUT_SUPPLEMENT", "TANGUT SUPPLEMENT", "TANGUTSUPPLEMENT");
        public static final UnicodeBlock SYMBOLS_FOR_LEGACY_COMPUTING = new UnicodeBlock("SYMBOLS_FOR_LEGACY_COMPUTING", "SYMBOLS FOR LEGACY COMPUTING", "SYMBOLSFORLEGACYCOMPUTING");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G", "CJK UNIFIED IDEOGRAPHS EXTENSION G", "CJKUNIFIEDIDEOGRAPHSEXTENSIONG");
        public static final UnicodeBlock ARABIC_EXTENDED_B = new UnicodeBlock("ARABIC_EXTENDED_B", "ARABIC EXTENDED-B", "ARABICEXTENDED-B");
        public static final UnicodeBlock VITHKUQI = new UnicodeBlock("VITHKUQI");
        public static final UnicodeBlock LATIN_EXTENDED_F = new UnicodeBlock("LATIN_EXTENDED_F", "LATIN EXTENDED-F", "LATINEXTENDED-F");
        public static final UnicodeBlock OLD_UYGHUR = new UnicodeBlock("OLD_UYGHUR", "OLD UYGHUR", "OLDUYGHUR");
        public static final UnicodeBlock UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_A = new UnicodeBlock("UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_A", "UNIFIED CANADIAN ABORIGINAL SYLLABICS EXTENDED-A", "UNIFIEDCANADIANABORIGINALSYLLABICSEXTENDED-A");
        public static final UnicodeBlock CYPRO_MINOAN = new UnicodeBlock("CYPRO_MINOAN", "CYPRO-MINOAN", "CYPRO-MINOAN");
        public static final UnicodeBlock TANGSA = new UnicodeBlock("TANGSA");
        public static final UnicodeBlock KANA_EXTENDED_B = new UnicodeBlock("KANA_EXTENDED_B", "KANA EXTENDED-B", "KANAEXTENDED-B");
        public static final UnicodeBlock ZNAMENNY_MUSICAL_NOTATION = new UnicodeBlock("ZNAMENNY_MUSICAL_NOTATION", "ZNAMENNY MUSICAL NOTATION", "ZNAMENNYMUSICALNOTATION");
        public static final UnicodeBlock LATIN_EXTENDED_G = new UnicodeBlock("LATIN_EXTENDED_G", "LATIN EXTENDED-G", "LATINEXTENDED-G");
        public static final UnicodeBlock TOTO = new UnicodeBlock("TOTO");
        public static final UnicodeBlock ETHIOPIC_EXTENDED_B = new UnicodeBlock("ETHIOPIC_EXTENDED_B", "ETHIOPIC EXTENDED-B", "ETHIOPICEXTENDED-B");
        public static final UnicodeBlock ARABIC_EXTENDED_C = new UnicodeBlock("ARABIC_EXTENDED_C", "ARABIC EXTENDED-C", "ARABICEXTENDED-C");
        public static final UnicodeBlock DEVANAGARI_EXTENDED_A = new UnicodeBlock("DEVANAGARI_EXTENDED_A", "DEVANAGARI EXTENDED-A", "DEVANAGARIEXTENDED-A");
        public static final UnicodeBlock KAWI = new UnicodeBlock("KAWI");
        public static final UnicodeBlock KAKTOVIK_NUMERALS = new UnicodeBlock("KAKTOVIK_NUMERALS", "KAKTOVIK NUMERALS", "KAKTOVIKNUMERALS");
        public static final UnicodeBlock CYRILLIC_EXTENDED_D = new UnicodeBlock("CYRILLIC_EXTENDED_D", "CYRILLIC EXTENDED-D", "CYRILLICEXTENDED-D");
        public static final UnicodeBlock NAG_MUNDARI = new UnicodeBlock("NAG_MUNDARI", "NAG MUNDARI", "NAGMUNDARI");
        public static final UnicodeBlock CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H = new UnicodeBlock("CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H", "CJK UNIFIED IDEOGRAPHS EXTENSION H", "CJKUNIFIEDIDEOGRAPHSEXTENSIONH");
        private static final int[] blockStarts = new int[]{0, 128, 256, 384, 592, 688, 768, 880, 1024, 1280, 1328, 1424, 1536, 1792, 1872, 1920, 1984, 2048, 2112, 2144, 2160, 2208, 2304, 2432, 2560, 2688, 2816, 2944, 3072, 3200, 3328, 3456, 3584, 3712, 3840, 4096, 4256, 4352, 4608, 4992, 5024, 5120, 5760, 5792, 5888, 5920, 5952, 5984, 6016, 6144, 6320, 6400, 6480, 6528, 6624, 6656, 6688, 6832, 6912, 7040, 7104, 7168, 7248, 7296, 7312, 7360, 7376, 7424, 7552, 7616, 7680, 7936, 8192, 8304, 8352, 8400, 8448, 8528, 8592, 8704, 8960, 9216, 9280, 9312, 9472, 9600, 9632, 9728, 9984, 10176, 10224, 10240, 10496, 10624, 10752, 11008, 11264, 11360, 11392, 11520, 11568, 11648, 11744, 11776, 11904, 12032, 12256, 12272, 12288, 12352, 12448, 12544, 12592, 12688, 12704, 12736, 12784, 12800, 13056, 13312, 19904, 19968, 40960, 42128, 42192, 42240, 42560, 42656, 42752, 42784, 43008, 43056, 43072, 43136, 43232, 43264, 43312, 43360, 43392, 43488, 43520, 43616, 43648, 43744, 43776, 43824, 43888, 43968, 44032, 55216, 55296, 56192, 56320, 57344, 63744, 64256, 64336, 65024, 65040, 65056, 65072, 65104, 65136, 65280, 65520, 65536, 65664, 65792, 65856, 65936, 66000, 66048, 66176, 66208, 66272, 66304, 66352, 66384, 66432, 66464, 66528, 66560, 66640, 66688, 66736, 66816, 66864, 66928, 67008, 67072, 67456, 67520, 67584, 67648, 67680, 67712, 67760, 67808, 67840, 67872, 67904, 67968, 68000, 68096, 68192, 68224, 68256, 68288, 68352, 68416, 68448, 68480, 68528, 68608, 68688, 68736, 68864, 68928, 69216, 69248, 69312, 69376, 69424, 69488, 69552, 69600, 69632, 69760, 69840, 69888, 69968, 70016, 70112, 70144, 70224, 70272, 70320, 70400, 70528, 70656, 70784, 70880, 71040, 71168, 71264, 71296, 71376, 71424, 71504, 71680, 71760, 71840, 71936, 72032, 72096, 72192, 72272, 72368, 72384, 72448, 72544, 72704, 72816, 72896, 72960, 73056, 73136, 73440, 73472, 73568, 73648, 73664, 73728, 74752, 74880, 75088, 77712, 77824, 78896, 78944, 82944, 83584, 92160, 92736, 92784, 92880, 92928, 93072, 93760, 93856, 93952, 94112, 94176, 94208, 100352, 101120, 101632, 101760, 110576, 110592, 110848, 110896, 110960, 111360, 113664, 113824, 113840, 118528, 118736, 118784, 119040, 119296, 119376, 119488, 119520, 119552, 119648, 119680, 119808, 120832, 121520, 122624, 122880, 122928, 123024, 123136, 123216, 123536, 123584, 123648, 124112, 124160, 124896, 124928, 125152, 125184, 125280, 126064, 126144, 126208, 126288, 126464, 126720, 126976, 127024, 127136, 127232, 127488, 127744, 128512, 128592, 128640, 128768, 128896, 129024, 129280, 129536, 129648, 129792, 130048, 131072, 173792, 173824, 177984, 178208, 183984, 191472, 194560, 195104, 196608, 201552, 205744, 917504, 917632, 917760, 918000, 983040, 0x100000};
        private static final UnicodeBlock[] blocks = new UnicodeBlock[]{BASIC_LATIN, LATIN_1_SUPPLEMENT, LATIN_EXTENDED_A, LATIN_EXTENDED_B, IPA_EXTENSIONS, SPACING_MODIFIER_LETTERS, COMBINING_DIACRITICAL_MARKS, GREEK, CYRILLIC, CYRILLIC_SUPPLEMENTARY, ARMENIAN, HEBREW, ARABIC, SYRIAC, ARABIC_SUPPLEMENT, THAANA, NKO, SAMARITAN, MANDAIC, SYRIAC_SUPPLEMENT, ARABIC_EXTENDED_B, ARABIC_EXTENDED_A, DEVANAGARI, BENGALI, GURMUKHI, GUJARATI, ORIYA, TAMIL, TELUGU, KANNADA, MALAYALAM, SINHALA, THAI, LAO, TIBETAN, MYANMAR, GEORGIAN, HANGUL_JAMO, ETHIOPIC, ETHIOPIC_SUPPLEMENT, CHEROKEE, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS, OGHAM, RUNIC, TAGALOG, HANUNOO, BUHID, TAGBANWA, KHMER, MONGOLIAN, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED, LIMBU, TAI_LE, NEW_TAI_LUE, KHMER_SYMBOLS, BUGINESE, TAI_THAM, COMBINING_DIACRITICAL_MARKS_EXTENDED, BALINESE, SUNDANESE, BATAK, LEPCHA, OL_CHIKI, CYRILLIC_EXTENDED_C, GEORGIAN_EXTENDED, SUNDANESE_SUPPLEMENT, VEDIC_EXTENSIONS, PHONETIC_EXTENSIONS, PHONETIC_EXTENSIONS_SUPPLEMENT, COMBINING_DIACRITICAL_MARKS_SUPPLEMENT, LATIN_EXTENDED_ADDITIONAL, GREEK_EXTENDED, GENERAL_PUNCTUATION, SUPERSCRIPTS_AND_SUBSCRIPTS, CURRENCY_SYMBOLS, COMBINING_MARKS_FOR_SYMBOLS, LETTERLIKE_SYMBOLS, NUMBER_FORMS, ARROWS, MATHEMATICAL_OPERATORS, MISCELLANEOUS_TECHNICAL, CONTROL_PICTURES, OPTICAL_CHARACTER_RECOGNITION, ENCLOSED_ALPHANUMERICS, BOX_DRAWING, BLOCK_ELEMENTS, GEOMETRIC_SHAPES, MISCELLANEOUS_SYMBOLS, DINGBATS, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A, SUPPLEMENTAL_ARROWS_A, BRAILLE_PATTERNS, SUPPLEMENTAL_ARROWS_B, MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B, SUPPLEMENTAL_MATHEMATICAL_OPERATORS, MISCELLANEOUS_SYMBOLS_AND_ARROWS, GLAGOLITIC, LATIN_EXTENDED_C, COPTIC, GEORGIAN_SUPPLEMENT, TIFINAGH, ETHIOPIC_EXTENDED, CYRILLIC_EXTENDED_A, SUPPLEMENTAL_PUNCTUATION, CJK_RADICALS_SUPPLEMENT, KANGXI_RADICALS, null, IDEOGRAPHIC_DESCRIPTION_CHARACTERS, CJK_SYMBOLS_AND_PUNCTUATION, HIRAGANA, KATAKANA, BOPOMOFO, HANGUL_COMPATIBILITY_JAMO, KANBUN, BOPOMOFO_EXTENDED, CJK_STROKES, KATAKANA_PHONETIC_EXTENSIONS, ENCLOSED_CJK_LETTERS_AND_MONTHS, CJK_COMPATIBILITY, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A, YIJING_HEXAGRAM_SYMBOLS, CJK_UNIFIED_IDEOGRAPHS, YI_SYLLABLES, YI_RADICALS, LISU, VAI, CYRILLIC_EXTENDED_B, BAMUM, MODIFIER_TONE_LETTERS, LATIN_EXTENDED_D, SYLOTI_NAGRI, COMMON_INDIC_NUMBER_FORMS, PHAGS_PA, SAURASHTRA, DEVANAGARI_EXTENDED, KAYAH_LI, REJANG, HANGUL_JAMO_EXTENDED_A, JAVANESE, MYANMAR_EXTENDED_B, CHAM, MYANMAR_EXTENDED_A, TAI_VIET, MEETEI_MAYEK_EXTENSIONS, ETHIOPIC_EXTENDED_A, LATIN_EXTENDED_E, CHEROKEE_SUPPLEMENT, MEETEI_MAYEK, HANGUL_SYLLABLES, HANGUL_JAMO_EXTENDED_B, HIGH_SURROGATES, HIGH_PRIVATE_USE_SURROGATES, LOW_SURROGATES, PRIVATE_USE_AREA, CJK_COMPATIBILITY_IDEOGRAPHS, ALPHABETIC_PRESENTATION_FORMS, ARABIC_PRESENTATION_FORMS_A, VARIATION_SELECTORS, VERTICAL_FORMS, COMBINING_HALF_MARKS, CJK_COMPATIBILITY_FORMS, SMALL_FORM_VARIANTS, ARABIC_PRESENTATION_FORMS_B, HALFWIDTH_AND_FULLWIDTH_FORMS, SPECIALS, LINEAR_B_SYLLABARY, LINEAR_B_IDEOGRAMS, AEGEAN_NUMBERS, ANCIENT_GREEK_NUMBERS, ANCIENT_SYMBOLS, PHAISTOS_DISC, null, LYCIAN, CARIAN, COPTIC_EPACT_NUMBERS, OLD_ITALIC, GOTHIC, OLD_PERMIC, UGARITIC, OLD_PERSIAN, null, DESERET, SHAVIAN, OSMANYA, OSAGE, ELBASAN, CAUCASIAN_ALBANIAN, VITHKUQI, null, LINEAR_A, LATIN_EXTENDED_F, null, CYPRIOT_SYLLABARY, IMPERIAL_ARAMAIC, PALMYRENE, NABATAEAN, null, HATRAN, PHOENICIAN, LYDIAN, null, MEROITIC_HIEROGLYPHS, MEROITIC_CURSIVE, KHAROSHTHI, OLD_SOUTH_ARABIAN, OLD_NORTH_ARABIAN, null, MANICHAEAN, AVESTAN, INSCRIPTIONAL_PARTHIAN, INSCRIPTIONAL_PAHLAVI, PSALTER_PAHLAVI, null, OLD_TURKIC, null, OLD_HUNGARIAN, HANIFI_ROHINGYA, null, RUMI_NUMERAL_SYMBOLS, YEZIDI, ARABIC_EXTENDED_C, OLD_SOGDIAN, SOGDIAN, OLD_UYGHUR, CHORASMIAN, ELYMAIC, BRAHMI, KAITHI, SORA_SOMPENG, CHAKMA, MAHAJANI, SHARADA, SINHALA_ARCHAIC_NUMBERS, KHOJKI, null, MULTANI, KHUDAWADI, GRANTHA, null, NEWA, TIRHUTA, null, SIDDHAM, MODI, MONGOLIAN_SUPPLEMENT, TAKRI, null, AHOM, null, DOGRA, null, WARANG_CITI, DIVES_AKURU, null, NANDINAGARI, ZANABAZAR_SQUARE, SOYOMBO, UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED_A, PAU_CIN_HAU, DEVANAGARI_EXTENDED_A, null, BHAIKSUKI, MARCHEN, null, MASARAM_GONDI, GUNJALA_GONDI, null, MAKASAR, KAWI, null, LISU_SUPPLEMENT, TAMIL_SUPPLEMENT, CUNEIFORM, CUNEIFORM_NUMBERS_AND_PUNCTUATION, EARLY_DYNASTIC_CUNEIFORM, null, CYPRO_MINOAN, EGYPTIAN_HIEROGLYPHS, EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS, null, ANATOLIAN_HIEROGLYPHS, null, BAMUM_SUPPLEMENT, MRO, TANGSA, BASSA_VAH, PAHAWH_HMONG, null, MEDEFAIDRIN, null, MIAO, null, IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION, TANGUT, TANGUT_COMPONENTS, KHITAN_SMALL_SCRIPT, TANGUT_SUPPLEMENT, null, KANA_EXTENDED_B, KANA_SUPPLEMENT, KANA_EXTENDED_A, SMALL_KANA_EXTENSION, NUSHU, null, DUPLOYAN, SHORTHAND_FORMAT_CONTROLS, null, ZNAMENNY_MUSICAL_NOTATION, null, BYZANTINE_MUSICAL_SYMBOLS, MUSICAL_SYMBOLS, ANCIENT_GREEK_MUSICAL_NOTATION, null, KAKTOVIK_NUMERALS, MAYAN_NUMERALS, TAI_XUAN_JING_SYMBOLS, COUNTING_ROD_NUMERALS, null, MATHEMATICAL_ALPHANUMERIC_SYMBOLS, SUTTON_SIGNWRITING, null, LATIN_EXTENDED_G, GLAGOLITIC_SUPPLEMENT, CYRILLIC_EXTENDED_D, null, NYIAKENG_PUACHUE_HMONG, null, TOTO, WANCHO, null, NAG_MUNDARI, null, ETHIOPIC_EXTENDED_B, MENDE_KIKAKUI, null, ADLAM, null, INDIC_SIYAQ_NUMBERS, null, OTTOMAN_SIYAQ_NUMBERS, null, ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS, null, MAHJONG_TILES, DOMINO_TILES, PLAYING_CARDS, ENCLOSED_ALPHANUMERIC_SUPPLEMENT, ENCLOSED_IDEOGRAPHIC_SUPPLEMENT, MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS, EMOTICONS, ORNAMENTAL_DINGBATS, TRANSPORT_AND_MAP_SYMBOLS, ALCHEMICAL_SYMBOLS, GEOMETRIC_SHAPES_EXTENDED, SUPPLEMENTAL_ARROWS_C, SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS, CHESS_SYMBOLS, SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A, SYMBOLS_FOR_LEGACY_COMPUTING, null, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B, null, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F, null, CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT, null, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G, CJK_UNIFIED_IDEOGRAPHS_EXTENSION_H, null, TAGS, null, VARIATION_SELECTORS_SUPPLEMENT, null, SUPPLEMENTARY_PRIVATE_USE_AREA_A, SUPPLEMENTARY_PRIVATE_USE_AREA_B};

        private UnicodeBlock(String idName) {
            super(idName);
            map.put(idName, this);
        }

        private UnicodeBlock(String idName, String alias) {
            this(idName);
            map.put(alias, this);
        }

        private UnicodeBlock(String idName, String ... aliases) {
            this(idName);
            for (String alias : aliases) {
                map.put(alias, this);
            }
        }

        public static UnicodeBlock of(char c) {
            return UnicodeBlock.of((int)c);
        }

        public static UnicodeBlock of(int codePoint) {
            if (!Character.isValidCodePoint(codePoint)) {
                throw new IllegalArgumentException(String.format("Not a valid Unicode code point: 0x%X", codePoint));
            }
            int bottom = 0;
            int top = blockStarts.length;
            int current = top / 2;
            while (top - bottom > 1) {
                if (codePoint >= blockStarts[current]) {
                    bottom = current;
                } else {
                    top = current;
                }
                current = (top + bottom) / 2;
            }
            return blocks[current];
        }

        public static final UnicodeBlock forName(String blockName) {
            UnicodeBlock block = map.get(blockName.toUpperCase(Locale.US));
            if (block == null) {
                throw new IllegalArgumentException("Not a valid block name: " + blockName);
            }
            return block;
        }
    }
}

