/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.InputStream;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.asset.ApiTestUtils;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.junit.Test;

public class ClassLoaderAssetTestCase {
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/api/asset/Test.properties";
    private static final String NON_EXISTING_RESOURCE = "org/jboss/shrinkwrap/api/asset/NoFileShouldBePlacedHere.properties";

    @Test
    public void shouldBeAbleToReadResource() throws Exception {
        ClassLoaderAsset asset = new ClassLoaderAsset(EXISTING_RESOURCE);
        InputStream io = asset.openStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Should be able to read the content of the resource", (String)"shrinkwrap=true", (String)ApiTestUtils.convertToString(io));
    }

    @Test
    public void shouldThrowExceptionOnNullName() {
        try {
            new ClassLoaderAsset(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A null resourceName argument should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void shouldThrowExceptionOnNullClassloader() {
        try {
            new ClassLoaderAsset(EXISTING_RESOURCE, null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A null classLoader argument should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void shouldThrowExceptionOnMissingResource() {
        try {
            new ClassLoaderAsset(NON_EXISTING_RESOURCE);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A resource that is not found in the classLoader should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }
}

