/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.asset.ApiTestUtils;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.junit.Test;

public class UrlAssetTestCase {
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/api/asset/Test.properties";

    @Test
    public void shouldBeAbleToReadURL() throws Exception {
        UrlAsset asset = new UrlAsset(UrlAssetTestCase.getThreadContextClassLoader().getResource(EXISTING_RESOURCE));
        InputStream io = asset.openStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Should be able to read the content of the resource", (String)"shrinkwrap=true", (String)ApiTestUtils.convertToString(io));
    }

    @Test
    public void shouldThrowExceptionOnNullURL() throws Exception {
        try {
            new UrlAsset(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A null url argument should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void shouldCreateDefensiveCopyOfURLOnConstruction() throws Exception {
        URL mutableURL = UrlAssetTestCase.getThreadContextClassLoader().getResource(EXISTING_RESOURCE);
        UrlAsset asset = new UrlAsset(mutableURL);
        this.mutateURL(mutableURL);
        InputStream io = null;
        try {
            io = asset.openStream();
        }
        catch (Exception e) {
            Assert.fail((String)"Mutated URL leaked into the UrlAsset");
        }
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Mutated URL leaked into the UrlAsset", (String)"shrinkwrap=true", (String)ApiTestUtils.convertToString(io));
    }

    private void mutateURL(URL mutableURL) throws Exception {
        Class[] parameterTypes = new Class[]{String.class, String.class, Integer.TYPE, String.class, String.class};
        Method m = URL.class.getDeclaredMethod("set", parameterTypes);
        Object[] arguments = new Object[]{"file", "", -1, "/UNKNOWN_FILE", null};
        m.setAccessible(true);
        m.invoke((Object)mutableURL, arguments);
    }

    @Test
    public void shouldBeAbleToReturnURL() throws Exception {
        URL url = UrlAssetTestCase.getThreadContextClassLoader().getResource(EXISTING_RESOURCE);
        UrlAsset asset = new UrlAsset(url);
        Assert.assertTrue((boolean)url.sameFile(asset.getSource()));
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

