/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.File;
import java.io.InputStream;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.asset.ApiTestUtils;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.junit.Test;

public class FileAssetTestCase {
    private static final String BASE_PATH = "src/test/resources/org/jboss/shrinkwrap/api/asset/";
    private static final String EXISTING_FILE = "src/test/resources/org/jboss/shrinkwrap/api/asset/Test.properties";
    private static final String NON_EXISTING_FILE = "src/test/resources/org/jboss/shrinkwrap/api/asset/NoFileShouldBePlacedHere.properties";

    @Test
    public void shouldBeAbleToReadFile() throws Exception {
        FileAsset asset = new FileAsset(new File(EXISTING_FILE));
        InputStream io = asset.openStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Should be able to read the content of the resource", (String)"shrinkwrap=true", (String)ApiTestUtils.convertToString(io));
    }

    @Test
    public void shouldThrowExceptionOnNullFile() throws Exception {
        try {
            new FileAsset(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A null file argument should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void shouldThrowExceptionOnMissingFile() throws Exception {
        try {
            new FileAsset(new File(NON_EXISTING_FILE));
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A non existing file should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void shouldBeAbleToReturnFile() throws Exception {
        File exitingFile = new File(EXISTING_FILE);
        FileAsset asset = new FileAsset(exitingFile);
        Assert.assertTrue((boolean)exitingFile.equals(asset.getSource()));
    }
}

