/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.impl.base.URLPackageScanner;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassAsset;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.asset.UrlAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class ContainerBase<T extends Archive<T>>
implements Archive<T>,
ManifestContainer<T>,
ResourceContainer<T>,
ClassContainer<T>,
LibraryContainer<T> {
    private final Archive<?> archive;
    private final Class<T> actualType;

    protected ContainerBase(Class<T> actualType, Archive<?> archive) {
        Validate.notNull(actualType, "ActualType should be specified");
        Validate.notNull(archive, "Archive should be specified");
        this.actualType = actualType;
        this.archive = archive;
    }

    public T add(Path path, Archive<?> archive) {
        this.archive.add(path, archive);
        return this.covarientReturn();
    }

    public T add(Path target, Asset asset) throws IllegalArgumentException {
        this.archive.add(target, asset);
        return this.covarientReturn();
    }

    public T add(Path path, String name, Asset asset) {
        this.archive.add(path, name, asset);
        return this.covarientReturn();
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        this.archive.merge(source);
        return this.covarientReturn();
    }

    public T merge(Path path, Archive<?> source) throws IllegalArgumentException {
        this.archive.merge(path, source);
        return this.covarientReturn();
    }

    public T add(String name, Asset asset) {
        this.archive.add(name, asset);
        return this.covarientReturn();
    }

    public boolean contains(Path path) {
        return this.archive.contains(path);
    }

    public boolean delete(Path path) {
        return this.archive.delete(path);
    }

    public Asset get(Path path) {
        return this.archive.get(path);
    }

    public Asset get(String path) throws IllegalArgumentException {
        return this.archive.get(path);
    }

    public Map<Path, Asset> getContent() {
        return this.archive.getContent();
    }

    public String getName() {
        return this.archive.getName();
    }

    public String toString(boolean verbose) {
        return this.archive.toString(verbose);
    }

    protected abstract Path getManinfestPath();

    public final T setManifest(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.setManifest(new ClassLoaderAsset(resourceName));
    }

    public T setManifest(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest(new FileAsset(resource));
    }

    public T setManifest(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.setManifest(new UrlAsset(resource));
    }

    public T setManifest(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource("MANIFEST.FM", resource);
    }

    public final T addManifestResource(String resourceName) {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addManifestResource(resourceName, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addManifestResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource(resource.getName(), (Asset)new FileAsset(resource));
    }

    public T addManifestResource(String target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addManifestResource(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addManifestResource(String target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource(target, (Asset)new FileAsset(resource));
    }

    public T addManifestResource(String target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource(target, (Asset)new UrlAsset(resource));
    }

    public T addManifestResource(String target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource((Path)new BasicPath(target), resource);
    }

    public T addManifestResource(Path target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addManifestResource(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addManifestResource(Path target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource(target, (Asset)new FileAsset(resource));
    }

    public T addManifestResource(Path target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addManifestResource(target, (Asset)new UrlAsset(resource));
    }

    public T addManifestResource(Path target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        BasicPath location = new BasicPath(this.getManinfestPath(), target);
        return this.add((Path)location, resource);
    }

    protected abstract Path getResourcePath();

    public final T addResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addResource(resourceName, (Asset)new ClassLoaderAsset(resourceName));
    }

    public final T addResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource(resource.getName(), (Asset)new FileAsset(resource));
    }

    public final T addResource(String target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addResource(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addResource(String target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource(target, (Asset)new FileAsset(resource));
    }

    public T addResource(String target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource(target, (Asset)new UrlAsset(resource));
    }

    public T addResource(String target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource((Path)new BasicPath(target), resource);
    }

    public T addResource(Path target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        return this.addResource(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addResource(Path target, String resourceName, ClassLoader classLoader) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resourceName, "ResourceName should be specified");
        Validate.notNull(classLoader, "ClassLoader should be specified");
        return this.addResource(target, (Asset)new ClassLoaderAsset(resourceName, classLoader));
    }

    public T addResource(Path target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource(target, (Asset)new FileAsset(resource));
    }

    public T addResource(Path target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        return this.addResource(target, (Asset)new UrlAsset(resource));
    }

    public T addResource(Path target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target should be specified");
        Validate.notNull(resource, "Resource should be specified");
        BasicPath location = new BasicPath(this.getResourcePath(), target);
        return this.add((Path)location, resource);
    }

    protected abstract Path getClassesPath();

    public T addClass(Class<?> clazz) throws IllegalArgumentException {
        Validate.notNull(clazz, "Clazz must be specified");
        return this.addClasses(clazz);
    }

    public T addClasses(Class<?> ... classes) throws IllegalArgumentException {
        Validate.notNull(classes, "Classes must be specified");
        for (Class<?> clazz : classes) {
            ClassAsset resource = new ClassAsset(clazz);
            BasicPath location = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
            this.add((Path)location, (Asset)resource);
        }
        return this.covarientReturn();
    }

    public T addPackage(Package pack) throws IllegalArgumentException {
        Validate.notNull(pack, "Pack must be specified");
        return this.addPackages(false, pack);
    }

    public T addPackages(boolean recursive, Package ... packages) throws IllegalArgumentException {
        Validate.notNull(packages, "Packages must be specified");
        for (Package pack : packages) {
            URLPackageScanner scanner = new URLPackageScanner(pack, recursive, Thread.currentThread().getContextClassLoader());
            Set<Class<?>> classes = scanner.getClasses();
            for (Class<?> clazz : classes) {
                ClassAsset asset = new ClassAsset(clazz);
                BasicPath location = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(clazz));
                this.add((Path)location, (Asset)asset);
            }
        }
        return this.covarientReturn();
    }

    protected abstract Path getLibraryPath();

    public T addLibrary(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(this.getLibraryPath(), archive);
    }

    public T addLibrary(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addLibrary(resourceName, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addLibrary(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary(resource.getName(), (Asset)new FileAsset(resource));
    }

    public T addLibrary(String target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addLibrary(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addLibrary(String target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary(target, (Asset)new FileAsset(resource));
    }

    public T addLibrary(String target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary(target, (Asset)new UrlAsset(resource));
    }

    public T addLibrary(String target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary((Path)new BasicPath(target), resource);
    }

    public T addLibrary(Path target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addLibrary(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addLibrary(Path target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary(target, (Asset)new FileAsset(resource));
    }

    public T addLibrary(Path target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addLibrary(target, (Asset)new UrlAsset(resource));
    }

    public T addLibrary(Path target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        BasicPath location = new BasicPath(this.getLibraryPath(), target);
        return this.add((Path)location, resource);
    }

    protected T covarientReturn() {
        return (T)((Archive)this.getActualClass().cast(this));
    }

    protected Class<T> getActualClass() {
        return this.actualType;
    }
}

