/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.impl.base.ContainerBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.asset.FileAsset;
import org.jboss.shrinkwrap.impl.base.asset.UrlAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public abstract class EnterpriseContainerBase<T extends Archive<T>>
extends ContainerBase<T>
implements EnterpriseContainer<T> {
    protected EnterpriseContainerBase(Class<T> actualType, Archive<?> archive) {
        super(actualType, archive);
    }

    protected abstract Path getApplicationPath();

    public T setApplicationXML(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.setApplicationXML(new ClassLoaderAsset(resourceName));
    }

    public T setApplicationXML(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML(new FileAsset(resource));
    }

    public T setApplicationXML(URL resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.setApplicationXML(new UrlAsset(resource));
    }

    public T setApplicationXML(Asset resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource("application.xml", resource);
    }

    public T addApplicationResource(String resourceName) throws IllegalArgumentException {
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addApplicationResource(resourceName, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addApplicationResource(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource(resource.getName(), (Asset)new FileAsset(resource));
    }

    public T addApplicationResource(String target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addApplicationResource(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addApplicationResource(String target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource(target, (Asset)new FileAsset(resource));
    }

    public T addApplicationResource(String target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource(target, (Asset)new UrlAsset(resource));
    }

    public T addApplicationResource(String target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource((Path)new BasicPath(target), resource);
    }

    public T addApplicationResource(Path target, String resourceName) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        return this.addApplicationResource(target, (Asset)new ClassLoaderAsset(resourceName));
    }

    public T addApplicationResource(Path target, File resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource(target, (Asset)new FileAsset(resource));
    }

    public T addApplicationResource(Path target, URL resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        return this.addApplicationResource(target, (Asset)new UrlAsset(resource));
    }

    public T addApplicationResource(Path target, Asset resource) throws IllegalArgumentException {
        Validate.notNull(target, "Target must be specified");
        Validate.notNull(resource, "Resource must be specified");
        BasicPath location = new BasicPath(this.getApplicationPath(), target);
        return this.add((Path)location, resource);
    }

    protected abstract Path getModulePath();

    public T addModule(Archive<?> archive) throws IllegalArgumentException {
        Validate.notNull(archive, "Archive must be specified");
        return this.add(this.getModulePath(), archive);
    }

    public T addModule(String resourceName) {
        Validate.notNull(resourceName, "ResourceName must be specified");
        BasicPath location = new BasicPath(AssetUtil.getNameForClassloaderResource(resourceName));
        return this.addModule((Path)location, resourceName);
    }

    public T addModule(File resource) throws IllegalArgumentException {
        Validate.notNull(resource, "Resource must be specified");
        BasicPath location = new BasicPath(resource.getName());
        return this.addModule((Path)location, resource);
    }

    public T addModule(Path targetPath, File resource) throws IllegalArgumentException {
        Validate.notNull(targetPath, "Target Path must be specified");
        Validate.notNull(resource, "Resource must be specified");
        FileAsset asset = new FileAsset(resource);
        BasicPath location = new BasicPath(this.getModulePath(), targetPath);
        return this.add((Path)location, (Asset)asset);
    }

    public T addModule(Path targetPath, String resourceName) throws IllegalArgumentException {
        Validate.notNull(targetPath, "Target Path must be specified");
        Validate.notNull(resourceName, "ResourceName must be specified");
        ClassLoaderAsset asset = new ClassLoaderAsset(resourceName);
        BasicPath location = new BasicPath(this.getModulePath(), targetPath);
        return this.add((Path)location, (Asset)asset);
    }

    public T addModule(Path targetPath, URL resource) throws IllegalArgumentException {
        Validate.notNull(targetPath, "Target Path must be specified");
        Validate.notNull(resource, "Resource must be specified");
        UrlAsset asset = new UrlAsset(resource);
        BasicPath location = new BasicPath(this.getModulePath(), targetPath);
        return this.add((Path)location, (Asset)asset);
    }

    public T addModule(String targetPath, File resource) throws IllegalArgumentException {
        return this.addModule((Path)new BasicPath(targetPath), resource);
    }

    public T addModule(String targetPath, String resourceName) throws IllegalArgumentException {
        return this.addModule((Path)new BasicPath(targetPath), resourceName);
    }

    public T addModule(String targetPath, URL resource) throws IllegalArgumentException {
        return this.addModule((Path)new BasicPath(targetPath), resource);
    }
}

