/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.export;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;

public abstract class AbstractExporterDelegate<T> {
    private static final Logger log = Logger.getLogger(AbstractExporterDelegate.class.getName());
    private final Archive<?> archive;

    protected AbstractExporterDelegate(Archive<?> archive) {
        this.archive = archive;
    }

    protected void export() {
        Archive<?> archive = this.getArchive();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Exporting archive - " + archive.getName());
        }
        Map content = archive.getContent();
        for (Map.Entry contentEntry : content.entrySet()) {
            Path path = (Path)contentEntry.getKey();
            Asset asset = (Asset)contentEntry.getValue();
            this.processAsset(path, asset);
        }
    }

    protected abstract void processAsset(Path var1, Asset var2);

    protected abstract T getResult();

    protected Archive<?> getArchive() {
        return this.archive;
    }
}

