/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.export;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.export.ExplodedExporter;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.export.ExplodedExporterDelegate;

public class ExplodedExporterImpl
extends ExplodedExporter {
    private static final Logger log = Logger.getLogger(ExplodedExporterImpl.class.getName());

    protected File doExportExploded(Archive<?> archive, File baseDirectory) {
        Validate.notNull(archive, "No archive provided");
        Validate.notNull(baseDirectory, "No baseDirectory provided");
        if (!baseDirectory.exists()) {
            throw new IllegalArgumentException("Parent directory does not exist");
        }
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException("Provided parent directory is not a valid directory");
        }
        ExplodedExporterDelegate exporterDelegate = new ExplodedExporterDelegate(archive, baseDirectory);
        exporterDelegate.export();
        File explodedDirectory = exporterDelegate.getResult();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created Exploded Archive: " + explodedDirectory.getAbsolutePath());
        }
        return explodedDirectory;
    }
}

