/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.io;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.StreamErrorHandler;
import org.jboss.shrinkwrap.impl.base.io.StreamTask;

public final class IOUtil {
    private static final StreamErrorHandler DEFAULT_ERROR_HANDLER = new StreamErrorHandler(){

        @Override
        public void handle(Throwable t) {
            throw new RuntimeException(t);
        }
    };

    private IOUtil() {
        throw new UnsupportedOperationException("No instances should be created; stateless class");
    }

    public static byte[] asByteArray(InputStream in) throws IllegalArgumentException {
        Validate.notNull(in, "stream must be specified");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len = 1024;
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error in obtainting bytes from " + in, ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignore) {}
        }
        byte[] content = out.toByteArray();
        return content;
    }

    public static void copy(InputStream input, OutputStream output) {
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = input.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error copying contents from " + input + " to " + output, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyWithClose(InputStream input, OutputStream output) {
        try {
            IOUtil.copy(input, output);
        }
        finally {
            try {
                input.close();
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void deleteDirectory(File directory) {
        if (directory.isDirectory() && directory.exists()) {
            for (File file : directory.listFiles()) {
                if (file.isDirectory()) {
                    IOUtil.deleteDirectory(file);
                    continue;
                }
                if (file.delete()) continue;
                throw new RuntimeException("Failed to delete file: " + file);
            }
            if (!directory.delete()) {
                throw new RuntimeException("Failed to delete directory: " + directory);
            }
        } else {
            throw new RuntimeException("Unable to delete directory: " + directory + ".  It is either not a directory or does not exist.");
        }
    }

    public static <S extends Closeable> void closeOnComplete(StreamTask<S> task, StreamErrorHandler errorHandler) {
    }

    public static <S extends Closeable> void closeOnComplete(S stream, StreamTask<S> task) {
        IOUtil.closeOnComplete(stream, task, DEFAULT_ERROR_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Closeable> void closeOnComplete(S stream, StreamTask<S> task, StreamErrorHandler errorHandler) {
        try {
            task.execute(stream);
        }
        catch (Throwable t) {
            errorHandler.handle(t);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception ex) {}
        }
    }
}

