/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.InputStream;
import org.jboss.shrinkwrap.impl.base.asset.ClassAsset;
import org.jboss.shrinkwrap.impl.base.asset.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ClassAssetTestCase {
    @Test
    public void shouldBeAbleToReadThisClass() throws Exception {
        Class<ClassAssetTestCase> clazz = ClassAssetTestCase.class;
        ClassAsset asset = new ClassAsset(clazz);
        InputStream io = asset.getStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Loaded class should have the same size", (long)TestUtils.findLengthOfStream(io), (long)TestUtils.findLengthOfClass(clazz));
    }

    @Test
    public void shouldBeAbleAddBootstrapClass() throws Exception {
        Class<Class> bootstrapClass = Class.class;
        ClassAsset asset = new ClassAsset(bootstrapClass);
        InputStream io = asset.getStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Loaded class should have the same size", (long)TestUtils.findLengthOfStream(io), (long)TestUtils.findLengthOfClass(bootstrapClass));
    }

    @Test
    public void shouldThrowExceptionOnNullClass() throws Exception {
        try {
            new ClassAsset(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A null clazz argument should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }
}

