/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.InputStream;
import junit.framework.Assert;
import org.jboss.shrinkwrap.impl.base.asset.TestUtils;
import org.jboss.shrinkwrap.impl.base.asset.UrlAsset;
import org.junit.Test;

public class UrlAssetTestCase {
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";

    @Test
    public void shouldBeAbleToReadURL() throws Exception {
        UrlAsset asset = new UrlAsset(Thread.currentThread().getContextClassLoader().getResource(EXISTING_RESOURCE));
        InputStream io = asset.getStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Should be able to read the content of the resource", (String)"shrinkwrap=true", (String)TestUtils.convertToString(io));
    }

    @Test
    public void shouldThrowExceptionOnNullURL() throws Exception {
        try {
            new UrlAsset(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A null url argument should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }
}

