/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.export;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.export.ArchiveExportException;
import org.jboss.shrinkwrap.api.export.ZipExporter;
import org.jboss.shrinkwrap.impl.base.export.ExportTestBase;
import org.jboss.shrinkwrap.impl.base.export.ZipExporterUtil;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Assert;
import org.junit.Test;

public class ZipExporterTestCase
extends ExportTestBase {
    private static final Logger log = Logger.getLogger(ZipExporterTestCase.class.getName());

    @Test
    public void testExportZip() throws Exception {
        log.info("testExportZip");
        File tempDirectory = this.createTempDirectory("testExportZip");
        Archive<?> archive = this.createArchiveWithAssets();
        InputStream zipStream = ZipExporter.exportZip(archive);
        ZipFile expectedZip = this.getExportedZipFile("testArchive.jar", zipStream, tempDirectory);
        this.assertAssetInZip(expectedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(expectedZip, PATH_TWO, ASSET_TWO);
    }

    @Test
    public void testExportNestedZip() throws Exception {
        log.info("testExportNestedZip");
        File tempDirectory = this.createTempDirectory("testExportNestedZip");
        Archive<?> archive = this.createArchiveWithNestedArchives();
        InputStream zipStream = ZipExporter.exportZip(archive);
        ZipFile expectedZip = this.getExportedZipFile("testArchive.jar", zipStream, tempDirectory);
        this.assertAssetInZip(expectedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(expectedZip, PATH_TWO, ASSET_TWO);
        BasicPath nestedArchivePath = new BasicPath("nestedArchive.jar");
        String nestedArchiveZipEntryPath = ZipExporterUtil.toZipEntryPath((Path)nestedArchivePath);
        ZipEntry nestedArchiveEntry = expectedZip.getEntry(nestedArchiveZipEntryPath);
        InputStream nesterArchiveStream = expectedZip.getInputStream(nestedArchiveEntry);
        ZipFile nestedZip = this.getExportedZipFile("nestedArchive.jar", nesterArchiveStream, tempDirectory);
        this.assertAssetInZip(nestedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(nestedZip, PATH_TWO, ASSET_TWO);
        BasicPath nestedArchiveTwoPath = new BasicPath(NESTED_PATH, "nestedArchive2.jar");
        String nestedArchiveTwoZipEntryPath = ZipExporterUtil.toZipEntryPath((Path)nestedArchiveTwoPath);
        ZipEntry nestedArchiveTwoEntry = expectedZip.getEntry(nestedArchiveTwoZipEntryPath);
        InputStream nesterArchiveTwoStream = expectedZip.getInputStream(nestedArchiveTwoEntry);
        ZipFile nestedZipTwo = this.getExportedZipFile("nestedArchive2.jar", nesterArchiveTwoStream, tempDirectory);
        this.assertAssetInZip(nestedZipTwo, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(nestedZipTwo, PATH_TWO, ASSET_TWO);
    }

    @Test
    public void testExportZipRequiresArchive() throws Exception {
        log.info("testExportZipRequiresArchive");
        try {
            ZipExporter.exportZip(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExportThrowsArchiveExcepitonOnAssetWriteFailure() {
        log.info("testExportThrowsArchiveExcepitonOnAssetWriteFailure");
        try {
            Archive<?> archive = this.createArchiveWithAssets();
            archive.add(PATH_ONE, new Asset(){

                public InputStream getStream() {
                    throw new RuntimeException("Mock Exception from an Asset write");
                }
            });
            ZipExporter.exportZip(archive);
            Assert.fail((String)"Should have thrown ArchiveExportException");
        }
        catch (ArchiveExportException archiveExportException) {
            // empty catch block
        }
    }

    private ZipFile getExportedZipFile(String archiveName, InputStream zipStream, File tempDirectory) throws Exception {
        Assert.assertNotNull((Object)zipStream);
        File outFile = new File(tempDirectory, archiveName);
        this.writeOutFile(outFile, zipStream);
        ZipFile expectedZip = new ZipFile(outFile);
        return expectedZip;
    }

    private void assertAssetInZip(ZipFile expectedZip, Path path, Asset asset) throws IllegalArgumentException, IOException {
        String entryPath = ZipExporterUtil.toZipEntryPath((Path)path);
        ZipEntry entry = expectedZip.getEntry(entryPath);
        Assert.assertNotNull((Object)entry);
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.getStream());
        byte[] actualContents = IOUtil.asByteArray((InputStream)expectedZip.getInputStream(entry));
        Assert.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }

    private void writeOutFile(File outFile, InputStream inputStream) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(outFile);
        IOUtil.copyWithClose((InputStream)inputStream, (OutputStream)fileOutputStream);
    }
}

