/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.EnterpriseArchiveImpl;
import org.jboss.shrinkwrap.impl.base.spec.JavaArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class EnterpriseArchiveImplTestCase
extends ContainerTestBase<EnterpriseArchive> {
    private static final String TEST_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    private static final Path PATH_APPLICATION = new BasicPath("META-INF");
    private static final Path PATH_LIBRARY = new BasicPath("lib");
    private static final Path PATH_MODULE = new BasicPath("/");
    private EnterpriseArchive archive;

    @Before
    public void createEnterpriseArchive() throws Exception {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected EnterpriseArchive getArchive() {
        return this.archive;
    }

    protected EnterpriseArchive createNewArchive() {
        return new EnterpriseArchiveImpl((Archive)new MemoryMapArchiveImpl());
    }

    @Override
    protected ClassContainer<EnterpriseArchive> getClassContainer() {
        throw new UnsupportedOperationException("EnterpriseArchives do not support classes");
    }

    @Override
    protected Path getClassesPath() {
        throw new UnsupportedOperationException("EnterpriseArchives do not support classes");
    }

    @Override
    protected LibraryContainer<EnterpriseArchive> getLibraryContainer() {
        return this.archive;
    }

    @Override
    protected Path getManifestPath() {
        return PATH_APPLICATION;
    }

    @Override
    protected Path getResourcePath() {
        return PATH_APPLICATION;
    }

    @Override
    protected Path getLibraryPath() {
        return PATH_LIBRARY;
    }

    @Override
    protected ManifestContainer<EnterpriseArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<EnterpriseArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Test
    public void shouldBeAbleToAddApplicationXML() throws Exception {
        this.archive.setApplicationXML(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(PATH_APPLICATION, "application.xml");
        Assert.assertTrue((String)"applicaton.xml should be located in /META-INF/application.xml", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void shouldBeAbleToAddApplicationResource() throws Exception {
        this.archive.addApplicationResource(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(PATH_APPLICATION, TEST_RESOURCE);
        Assert.assertTrue((String)"A application resource should be located in /META-INF/", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void shouldBeAbleToAddApplicationResourceWithNewName() throws Exception {
        String newName = "test.txt";
        this.archive.addApplicationResource((Path)new BasicPath(newName), TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(PATH_APPLICATION, newName);
        Assert.assertTrue((String)"A application resource should be located in /META-INF/", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void shouldBeAbleToAddModule() throws Exception {
        this.archive.addModule(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(PATH_MODULE, AssetUtil.getNameForClassloaderResource((String)TEST_RESOURCE));
        Assert.assertTrue((String)"A application module should be located in /", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void shouldBeAbleToAddArchiveModule() throws Exception {
        JavaArchiveImpl moduleArchive = new JavaArchiveImpl((Archive)new MemoryMapArchiveImpl("test.jar"));
        moduleArchive.addResource(TEST_RESOURCE);
        moduleArchive.addResource((Path)new BasicPath("test.txt"), TEST_RESOURCE);
        this.archive.addModule((Archive)moduleArchive);
        BasicPath expectedPath = new BasicPath(PATH_MODULE, moduleArchive.getName());
        Assert.assertTrue((String)"A application module should be located in /", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Override
    @Ignore
    public void testAddClass() throws Exception {
    }

    @Override
    @Ignore
    public void testAddClasses() throws Exception {
    }

    @Override
    @Ignore
    public void testAddPackage() throws Exception {
    }

    @Override
    @Ignore
    public void testAddPackageNonRecursive() throws Exception {
    }
}

