/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.JavaArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class JavaArchiveImplTestCase
extends ContainerTestBase<JavaArchive> {
    private static final Logger log = Logger.getLogger(JavaArchiveImplTestCase.class.getName());
    private static final String TEST_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    private static final Path PATH_MANIFEST = new BasicPath("META-INF");
    private static final Path PATH_CLASS = new BasicPath("/");
    private static final Path PATH_RESOURCE = new BasicPath();
    private JavaArchive archive;

    @Before
    public void createArchive() {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected JavaArchive getArchive() {
        return this.archive;
    }

    protected JavaArchive createNewArchive() {
        return new JavaArchiveImpl((Archive)new MemoryMapArchiveImpl());
    }

    @Override
    protected ManifestContainer<JavaArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<JavaArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected ClassContainer<JavaArchive> getClassContainer() {
        return this.archive;
    }

    @Override
    protected LibraryContainer<JavaArchive> getLibraryContainer() {
        throw new UnsupportedOperationException("JavaArchive does not support libraries");
    }

    @Override
    protected Path getManifestPath() {
        return PATH_MANIFEST;
    }

    @Override
    protected Path getResourcePath() {
        return PATH_RESOURCE;
    }

    @Override
    protected Path getClassesPath() {
        return PATH_CLASS;
    }

    @Override
    protected Path getLibraryPath() {
        throw new UnsupportedOperationException("JavaArchive does not support libraries");
    }

    @Test
    public void shouldBeAbleToSetManifestFile() throws Exception {
        this.archive.setManifest(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(PATH_MANIFEST, "MANIFEST.MF");
        Assert.assertTrue((String)"The MANIFEST.MF file should be located under /META-INF/MANIFEST.MF", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Override
    @Ignore
    public void testAddLibrary() throws Exception {
    }

    @Override
    @Ignore
    public void testAddLibraryToPath() throws Exception {
    }

    @Override
    @Ignore
    public void testAddArchiveAsLibrary() throws Exception {
    }
}

