/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.ResourceAdapterArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ResourceAdapterArchiveImplTestCase
extends ContainerTestBase<ResourceAdapterArchive> {
    private static final String TEST_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    private static final Path PATH_RESOURCE = new BasicPath("/");
    private static final Path PATH_MANIFEST = new BasicPath("META-INF");
    private static final Path PATH_LIBRARY = new BasicPath("/");
    private ResourceAdapterArchive archive;

    @Before
    public void createResourceAdapterArchive() throws Exception {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected ResourceAdapterArchive getArchive() {
        return this.archive;
    }

    protected ResourceAdapterArchive createNewArchive() {
        return new ResourceAdapterArchiveImpl((Archive)new MemoryMapArchiveImpl());
    }

    @Override
    protected ClassContainer<ResourceAdapterArchive> getClassContainer() {
        throw new UnsupportedOperationException("ResourceAdapterArchive do not support classes");
    }

    @Override
    protected Path getClassesPath() {
        throw new UnsupportedOperationException("ResourceAdapterArchive do not support classes");
    }

    @Override
    protected LibraryContainer<ResourceAdapterArchive> getLibraryContainer() {
        return this.archive;
    }

    @Override
    protected Path getManifestPath() {
        return PATH_MANIFEST;
    }

    @Override
    protected Path getResourcePath() {
        return PATH_RESOURCE;
    }

    @Override
    protected Path getLibraryPath() {
        return PATH_LIBRARY;
    }

    @Override
    protected ManifestContainer<ResourceAdapterArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<ResourceAdapterArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Test
    public void testAddResourceAdapterXML() throws Exception {
        this.archive.setResourceAdapterXML(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(PATH_MANIFEST, "ra.xml");
        Assert.assertTrue((String)"ra.xml should be located in /META-INF/ra.xml", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void testAddResourceAdapterXMLRequireResource() throws Exception {
        try {
            this.archive.setResourceAdapterXML(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    @Ignore
    public void testAddClass() throws Exception {
    }

    @Override
    @Ignore
    public void testAddClasses() throws Exception {
    }

    @Override
    @Ignore
    public void testAddPackage() throws Exception {
    }

    @Override
    @Ignore
    public void testAddPackageNonRecursive() throws Exception {
    }
}

