/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WebArchiveImplTestCase
extends ContainerTestBase<WebArchive> {
    private static final Path PATH_WEBINF = new BasicPath("WEB-INF");
    private static final Path PATH_LIBRARY = new BasicPath(PATH_WEBINF, "lib");
    private static final Path PATH_CLASSES = new BasicPath(PATH_WEBINF, "classes");
    private static final Path PATH_MANIFEST = new BasicPath("META-INF");
    private static final Path PATH_RESOURCE = new BasicPath();
    private WebArchive archive;

    @Before
    public void createWebArchive() throws Exception {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected WebArchive getArchive() {
        return this.archive;
    }

    protected WebArchive createNewArchive() {
        return new WebArchiveImpl((Archive)new MemoryMapArchiveImpl());
    }

    @Override
    protected ManifestContainer<WebArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<WebArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected ClassContainer<WebArchive> getClassContainer() {
        return this.archive;
    }

    @Override
    protected LibraryContainer<WebArchive> getLibraryContainer() {
        return this.archive;
    }

    @Override
    protected Path getManifestPath() {
        return PATH_MANIFEST;
    }

    @Override
    protected Path getResourcePath() {
        return PATH_RESOURCE;
    }

    @Override
    protected Path getClassesPath() {
        return PATH_CLASSES;
    }

    @Override
    protected Path getLibraryPath() {
        return PATH_LIBRARY;
    }

    @Test
    public void shouldBeAbleToSetWebXML() throws Exception {
        this.archive.setWebXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(PATH_WEBINF, "web.xml");
        Assert.assertTrue((String)"web.xml should be located in /WEB-INF/web.xml", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void shouldBeAbleToAddWebResource() throws Exception {
        this.archive.addWebResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(PATH_WEBINF, "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)"A resource should be located in /WEB-INF/", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void shouldBeAbleToAddWebResourceWithNewName() throws Exception {
        String newName = "test.txt";
        this.archive.addWebResource((Path)new BasicPath(newName), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(PATH_WEBINF, newName);
        Assert.assertTrue((String)"A resource should be located in /WEB-INF/", (boolean)this.archive.contains((Path)expectedPath));
    }

    @Test
    public void shouldBeAbleToAddLibrary() throws Exception {
        this.archive.addLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(PATH_LIBRARY, "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)"A library should be located in /WEB-INF/lib/", (boolean)this.archive.contains((Path)expectedPath));
    }
}

