/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.net.URL;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassUsedForClassResourceTest;
import org.jboss.shrinkwrap.impl.base.test.ArchiveTestBase;
import org.junit.Assert;
import org.junit.Test;

public abstract class ContainerTestBase<T extends Archive<T>>
extends ArchiveTestBase<T> {
    protected static final String TEST_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    protected static final Path NESTED_PATH = new BasicPath("nested");

    protected abstract ResourceContainer<T> getResourceContainer();

    protected abstract Path getResourcePath();

    protected abstract ManifestContainer<T> getManifestContainer();

    protected abstract Path getManifestPath();

    protected abstract ClassContainer<T> getClassContainer();

    protected abstract Path getClassesPath();

    protected abstract LibraryContainer<T> getLibraryContainer();

    protected abstract Path getLibraryPath();

    @Test
    public void testAddResource() throws Exception {
        ResourceContainer<T> container = this.getResourceContainer();
        container.addResource(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(this.getResourcePath(), TEST_RESOURCE);
        Assert.assertTrue((String)("A resource should be located under " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddResourceToPath() throws Exception {
        ResourceContainer<T> container = this.getResourceContainer();
        BasicPath path = new BasicPath(NESTED_PATH, TEST_RESOURCE);
        container.addResource((Path)path, TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath((Path)new BasicPath(this.getResourcePath(), NESTED_PATH), TEST_RESOURCE);
        Assert.assertTrue((String)("A resource should be located under " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddResourceWithNewName() throws Exception {
        ResourceContainer<T> container = this.getResourceContainer();
        String newName = "test.txt";
        container.addResource(TEST_RESOURCE, newName);
        BasicPath expectedPath = new BasicPath(this.getResourcePath(), "/org/jboss/shrinkwrap/impl/base/asset/" + newName);
        Assert.assertTrue((String)("A resource should be located under " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddResourceFromUrl() throws Exception {
        ResourceContainer<T> container = this.getResourceContainer();
        URL url = this.getClass().getResource("/org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        container.addResource(url);
        BasicPath expectedPath = new BasicPath(this.getResourcePath(), AssetUtil.getFullPathForURLResource((URL)url));
        Assert.assertTrue((String)("A resource should be located under " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddResourceToPathFromUrl() throws Exception {
        ResourceContainer<T> container = this.getResourceContainer();
        URL url = this.getClass().getResource("/org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath path = new BasicPath(TEST_RESOURCE);
        container.addResource((Path)path, url);
        BasicPath expectedPath = new BasicPath(this.getResourcePath(), TEST_RESOURCE);
        Assert.assertTrue((String)("A resource should be located under " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddResourceFromClassloader() throws Exception {
        ResourceContainer<T> container = this.getResourceContainer();
        BasicPath path = new BasicPath(TEST_RESOURCE);
        container.addResource((Path)path, TEST_RESOURCE, this.getClass().getClassLoader());
        BasicPath expectedPath = new BasicPath(this.getResourcePath(), TEST_RESOURCE);
        Assert.assertTrue((String)("A resource should be located under " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddManifestResource() throws Exception {
        ManifestContainer<T> container = this.getManifestContainer();
        container.addManifestResource(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(this.getManifestPath(), TEST_RESOURCE);
        Assert.assertTrue((String)("A manifest resource should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddManifestResourceWithNewName() throws Exception {
        ManifestContainer<T> container = this.getManifestContainer();
        String newName = "test.txt";
        container.addManifestResource((Path)new BasicPath(newName), TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(this.getManifestPath(), newName);
        Assert.assertTrue((String)("A manifest resoruce should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddClass() throws Exception {
        ClassContainer<T> container = this.getClassContainer();
        container.addClass(DummyClassUsedForClassResourceTest.class);
        BasicPath expectedPath = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddClasses() throws Exception {
        ClassContainer<T> container = this.getClassContainer();
        container.addClasses(new Class[]{DummyClassUsedForClassResourceTest.class});
        BasicPath expectedPath = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddPackage() throws Exception {
        ClassContainer<T> container = this.getClassContainer();
        container.addPackage(DummyClassUsedForClassResourceTest.class.getPackage());
        BasicPath expectedPath = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located  at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddPackageNonRecursive() throws Exception {
        ClassContainer<T> container = this.getClassContainer();
        container.addPackages(false, new Package[]{DummyClassUsedForClassResourceTest.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassesPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located  at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddLibrary() throws Exception {
        LibraryContainer<T> container = this.getLibraryContainer();
        container.addLibrary(TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(this.getLibraryPath(), TEST_RESOURCE);
        Assert.assertTrue((String)("A library should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddLibraryToPath() throws Exception {
        LibraryContainer<T> container = this.getLibraryContainer();
        BasicPath path = new BasicPath(TEST_RESOURCE);
        container.addLibrary((Path)path, TEST_RESOURCE);
        BasicPath expectedPath = new BasicPath(this.getLibraryPath(), (Path)path);
        Assert.assertTrue((String)("A library should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    public void testAddArchiveAsLibrary() throws Exception {
        Archive library = this.createNewArchive();
        LibraryContainer<T> container = this.getLibraryContainer();
        container.addLibrary(library);
        BasicPath expectedPath = new BasicPath(this.getLibraryPath(), library.getName());
        Assert.assertTrue((String)("A library should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }
}

