/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;

class TestUtils {
    private TestUtils() {
    }

    static String convertToString(InputStream in) throws Exception {
        int b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        out.close();
        in.close();
        return new String(out.toByteArray(), "UTF-8");
    }

    static int findLengthOfStream(InputStream in) throws Exception {
        int length = 0;
        while (in.read() != -1) {
            ++length;
        }
        in.close();
        return length;
    }

    static int findLengthOfClass(Class<?> clazz) throws Exception {
        String classResourceName = TestUtils.getResourceNameForClass(clazz);
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(classResourceName);
        return TestUtils.findLengthOfStream(in);
    }

    static String getResourceNameForClass(Class<?> clazz) {
        String classResourceDelimiter = clazz.getName().replaceAll("\\.", "/");
        String classFullPath = classResourceDelimiter + ".class";
        return classFullPath;
    }
}

