/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.export.ArchiveExportException;
import org.jboss.shrinkwrap.api.export.ExplodedExporter;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.export.ExportTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Assert;
import org.junit.Test;

public class ExplodedExporterTestCase
extends ExportTestBase {
    private static final Logger log = Logger.getLogger(ExplodedExporterTestCase.class.getName());

    @Test
    public void testExportExploded() throws Exception {
        log.info("testExportExploded");
        File tempDirectory = this.createTempDirectory("testExportExploded");
        Archive<?> archive = this.createArchiveWithAssets();
        File explodedDirectory = ExplodedExporter.exportExploded(archive, (File)tempDirectory);
        Assert.assertNotNull((Object)explodedDirectory);
        File expectedDirectory = new File(tempDirectory, archive.getName());
        Assert.assertEquals((Object)expectedDirectory, (Object)explodedDirectory);
        this.assertAssetInExploded(explodedDirectory, PATH_ONE, ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, PATH_TWO, ASSET_TWO);
    }

    @Test
    public void testExportNestedExploded() throws Exception {
        log.info("testExportNestedExploded");
        File tempDirectory = this.createTempDirectory("testExportNestedExploded");
        Archive<?> archive = this.createArchiveWithNestedArchives();
        File explodedDirectory = ExplodedExporter.exportExploded(archive, (File)tempDirectory);
        Assert.assertNotNull((Object)explodedDirectory);
        File expectedDirectory = new File(tempDirectory, archive.getName());
        Assert.assertEquals((Object)expectedDirectory, (Object)explodedDirectory);
        BasicPath nestedArchivePath = new BasicPath("nestedArchive.jar");
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePath, PATH_ONE), ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePath, PATH_TWO), ASSET_TWO);
        BasicPath nestedArchivePathTwo = new BasicPath(NESTED_PATH, "nestedArchive2.jar");
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePathTwo, PATH_ONE), ASSET_ONE);
        this.assertAssetInExploded(explodedDirectory, (Path)new BasicPath((Path)nestedArchivePathTwo, PATH_TWO), ASSET_TWO);
    }

    @Test
    public void testExportExplodedRequiresArchive() throws Exception {
        log.info("testExportExplodedRequiresArchive");
        try {
            ExplodedExporter.exportExploded(null, (File)this.getNonexistantDirectory());
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExportExplodedRequiresBaseDirectroy() throws Exception {
        log.info("testExportExplodedRequiresBaseDirectroy");
        try {
            ExplodedExporter.exportExploded((Archive)new MemoryMapArchiveImpl(), null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExportExplodedRequiresExisitingDirectroy() throws Exception {
        log.info("testExportExplodedRequiresExisitingDirectroy");
        try {
            File directory = this.getNonexistantDirectory();
            ExplodedExporter.exportExploded((Archive)new MemoryMapArchiveImpl(), (File)directory);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExportExplodedRequiresExistingDirectory() throws Exception {
        log.info("testExportExplodedRequiresExistingDirectory");
        try {
            File directory = this.getNonexistantDirectory();
            ExplodedExporter.exportExploded((Archive)new MemoryMapArchiveImpl(), (File)directory);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExportExplodedRequiresValidDirectory() throws Exception {
        log.info("testExportExplodedRequiresValidDirectory");
        try {
            File nonDirectory = new File(this.getTarget(), "tempFile.txt");
            nonDirectory.createNewFile();
            ExplodedExporter.exportExploded((Archive)new MemoryMapArchiveImpl(), (File)nonDirectory);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExportExplodedOutpuDirCreationFails() throws Exception {
        log.info("testExportExplodedOutpuDirCreationFails");
        try {
            File directory = this.createTempDirectory("testExportExplodedOutpuDirCreationFails");
            File existingFile = new File(directory, "testArchive.jar");
            existingFile.createNewFile();
            ExplodedExporter.exportExploded((Archive)new MemoryMapArchiveImpl("testArchive.jar"), (File)directory);
            Assert.fail((String)"Should have thrown ArchiveExportException");
        }
        catch (ArchiveExportException archiveExportException) {
            // empty catch block
        }
    }

    @Test
    public void testExportExplodedThrowsExceptionOnAssetWrite() throws Exception {
        log.info("testExportExplodedThrowsExceptionOnAssetWrite");
        try {
            Archive<?> archive = this.createArchiveWithAssets();
            archive.add((Path)new BasicPath("badAsset"), new Asset(){

                public InputStream openStream() {
                    throw new RuntimeException("Mock Esception getting Stream");
                }
            });
            File directory = this.createTempDirectory("testExportExplodedThrowsExceptionOnAssetWrite");
            ExplodedExporter.exportExploded(archive, (File)directory);
            Assert.fail((String)"Should have thrown ArchiveExportException");
        }
        catch (ArchiveExportException archiveExportException) {
            // empty catch block
        }
    }

    private File getNonexistantDirectory() {
        File directory = new File(this.getTarget(), "someNonExistentDirectory");
        if (directory.exists()) {
            IOUtil.deleteDirectory((File)directory);
        }
        Assert.assertTrue((String)("Precondition Failure: Directory should not exist: " + directory), (!directory.exists() ? 1 : 0) != 0);
        return directory;
    }

    private void assertAssetInExploded(File explodedDirectory, Path path, Asset asset) throws FileNotFoundException {
        File assetFile = new File(explodedDirectory, path.get());
        Assert.assertNotNull((Object)assetFile);
        Assert.assertTrue((boolean)assetFile.exists());
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        FileInputStream inputStream = new FileInputStream(assetFile);
        byte[] actualContents = IOUtil.asByteArray((InputStream)inputStream);
        Assert.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }
}

