/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.WebArchiveImpl;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicWebContainerTestBase;
import org.junit.After;
import org.junit.Before;

@ArchiveType(value=WebArchive.class)
public class WebArchiveImplTestCase
extends DynamicWebContainerTestBase<WebArchive> {
    private static final Path PATH_WEBINF = new BasicPath("WEB-INF");
    private static final Path PATH_LIBRARY = new BasicPath(PATH_WEBINF, "lib");
    private static final Path PATH_CLASSES = new BasicPath(PATH_WEBINF, "classes");
    private static final Path PATH_MANIFEST = new BasicPath("META-INF");
    private static final Path PATH_RESOURCE = new BasicPath();
    private WebArchive archive;

    @Before
    public void createWebArchive() throws Exception {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected WebArchive getArchive() {
        return this.archive;
    }

    protected WebArchive createNewArchive() {
        return new WebArchiveImpl((Archive)new MemoryMapArchiveImpl());
    }

    @Override
    protected ManifestContainer<WebArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<WebArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected ClassContainer<WebArchive> getClassContainer() {
        return this.archive;
    }

    @Override
    protected LibraryContainer<WebArchive> getLibraryContainer() {
        return this.archive;
    }

    @Override
    protected Path getManifestPath() {
        return PATH_MANIFEST;
    }

    @Override
    protected Path getResourcePath() {
        return PATH_RESOURCE;
    }

    @Override
    protected Path getClassPath() {
        return PATH_CLASSES;
    }

    @Override
    protected Path getLibraryPath() {
        return PATH_LIBRARY;
    }

    @Override
    public WebContainer<WebArchive> getWebContainer() {
        return this.getArchive();
    }

    @Override
    public Path getWebPath() {
        return PATH_WEBINF;
    }
}

