/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.After;
import org.junit.Test;

public abstract class ArchiveTestBase<T extends Archive<T>> {
    public static final String NAME_TEST_PROPERTIES = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    public static final String NAME_TEST_PROPERTIES_2 = "org/jboss/shrinkwrap/impl/base/asset/Test2.properties";

    protected abstract T getArchive();

    protected abstract Archive<T> createNewArchive();

    @After
    public void ls() {
        T archive = this.getArchive();
        System.out.println("test@jboss:/$ ls -l " + archive.getName());
        System.out.println(archive.toString(true));
    }

    @Test
    public void testAddAssetToPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Path)location, (Asset)asset);
        Assert.assertTrue((String)("Asset should be placed on " + location.get()), (boolean)archive.contains((Path)location));
    }

    @Test
    public void testAddRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Path)null, (Asset)asset);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Path)new BasicPath("/", "Test.properties"), (Asset)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add(location.get(), (Asset)asset);
        Assert.assertTrue((String)("Asset should be placed on " + new BasicPath("/", "test.properties")), (boolean)archive.contains((Path)location));
    }

    @Test
    public void testAddWithStringPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((String)null, (Asset)asset);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPathRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add("/Test.properties", (Asset)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithName() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/");
        archive.add((Path)location, "test.properties", (Asset)asset);
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assert.assertTrue((String)("Asset should be placed on " + expectedPath.get()), (boolean)archive.contains((Path)expectedPath));
    }

    @Test
    public void testAddAssetWithNameRequiresPath() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add(null, "test.properties", (Asset)asset);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithNameRequiresName() throws Exception {
        T archive = this.getArchive();
        BasicPath path = new BasicPath("/", "Test.properties");
        String resource = NAME_TEST_PROPERTIES;
        try {
            archive.add((Path)path, null, (Asset)new ClassLoaderAsset(NAME_TEST_PROPERTIES));
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithNameRequiresAsset() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        BasicPath path = new BasicPath("/", "Test.properties");
        try {
            archive.add((Path)path, "test.properties", null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteAsset() throws Exception {
        T archive = this.getArchive();
        String resource = NAME_TEST_PROPERTIES;
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Path)location, (Asset)new ClassLoaderAsset(resource));
        Assert.assertTrue((boolean)archive.contains((Path)location));
        Assert.assertTrue((String)"Successfully deleting an Asset should return true", (boolean)archive.delete((Path)location));
        Assert.assertFalse((String)("There should no longer be an asset at: " + location.get() + " after deleted"), (boolean)archive.contains((Path)location));
    }

    @Test
    public void testDeleteMissingAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        Assert.assertFalse((String)"Deleting a non-existent Asset should return false", (boolean)archive.delete((Path)location));
    }

    @Test
    public void testDeleteAssetRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.delete(null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Path)location, (Asset)asset);
        Asset fetchedAsset = archive.get((Path)location);
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedAsset));
    }

    @Test
    public void testGetAssetRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((Path)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAssetWithString() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Path)location, (Asset)asset);
        Asset fetchedAsset = archive.get(location.get());
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedAsset));
    }

    @Test
    public void testGetAssetWithStringRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((String)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToGetContent() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Path)location, (Asset)asset).add((Path)locationTwo, (Asset)assetTwo);
        Map content = archive.getContent();
        Asset asset1 = (Asset)content.get(location);
        Asset asset2 = (Asset)content.get(locationTwo);
        Assert.assertTrue((String)("Asset should existing in content with key: " + location.get()), (boolean)this.compareAssets((Asset)asset, asset1));
        Assert.assertTrue((String)("Asset should existing in content with key: " + locationTwo.get()), (boolean)this.compareAssets((Asset)assetTwo, asset2));
    }

    @Test
    public void testAddArchiveToPathRequirePath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add(null, (Archive)new MemoryMapArchiveImpl());
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddArchiveToPathRequireArchive() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Path)new BasicPath("/"), (Archive)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMergeRequiresSource() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMerge() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Path)location, (Asset)asset).add((Path)locationTwo, (Asset)assetTwo);
        archive.merge(sourceArchive);
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(archive.get((Path)location), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(archive.get((Path)locationTwo), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Path)location, (Asset)asset).add((Path)locationTwo, (Asset)assetTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge((Path)baseLocation, sourceArchive);
        BasicPath expectedPath = new BasicPath((Path)baseLocation, (Path)location);
        BasicPath expectedPathTwo = new BasicPath((Path)baseLocation, (Path)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(archive.get((Path)expectedPath), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPathTwo.getClass()), (boolean)this.compareAssets(archive.get((Path)expectedPathTwo), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(null, this.createNewArchive());
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddArchiveToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add((Path)baseLocation, sourceArchive);
        BasicPath expectedPath = new BasicPath((Path)baseLocation, sourceArchive.getName());
        Asset asset = archive.get((Path)expectedPath);
        Assert.assertNotNull((String)("Asset should have been added to path: " + expectedPath.get()), (Object)asset);
        Assert.assertTrue((String)("An instance of ArchiveAsset should have been added to path: " + expectedPath.get()), (boolean)(asset instanceof ArchiveAsset));
        ArchiveAsset archiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(asset);
        Archive nestedArchive = archiveAsset.getArchive();
        Assert.assertEquals((String)"Nested Archive should be same archive that was added", sourceArchive, (Object)nestedArchive);
    }

    @Test
    public void testNestedArchiveContains() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        sourceArchive.add((Path)nestedAssetPath, (Asset)asset);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add((Path)baseLocation, sourceArchive);
        BasicPath archivePath = new BasicPath((Path)baseLocation, sourceArchive.getName());
        BasicPath expectedPath = new BasicPath((Path)archivePath, "test.properties");
        Assert.assertTrue((String)"Nested archive assets should be verified through a fully qualified path", (boolean)archive.contains((Path)expectedPath));
    }

    @Test
    public void testNestedArchiveGet() throws Exception {
        T archive = this.getArchive();
        Archive<T> nestedArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add((Path)baseLocation, nestedArchive);
        Archive<T> nestedNestedArchive = this.createNewArchive();
        nestedArchive.add((Path)new BasicPath("/"), nestedNestedArchive);
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        nestedNestedArchive.add((Path)nestedAssetPath, (Asset)asset);
        BasicPath nestedArchivePath = new BasicPath((Path)baseLocation, nestedArchive.getName());
        BasicPath nestedNestedArchivePath = new BasicPath((Path)nestedArchivePath, nestedNestedArchive.getName());
        BasicPath expectedPath = new BasicPath((Path)nestedNestedArchivePath, "test.properties");
        Asset nestedAsset = archive.get((Path)expectedPath);
        Assert.assertNotNull((String)("Nested archive asset should be available through partent archive at " + expectedPath.get()), (Object)nestedAsset);
    }

    private boolean compareAssets(Asset one, Asset two) throws IllegalArgumentException {
        Validate.notNull((Object)one, (String)"Asset one must be specified");
        Validate.notNull((Object)two, (String)"Asset two must be specified");
        byte[] oneData = IOUtil.asByteArray((InputStream)one.openStream());
        byte[] twoData = IOUtil.asByteArray((InputStream)two.openStream());
        return Arrays.equals(oneData, twoData);
    }
}

