/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.exporter.StreamExporterTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.io.tar.TarEntry;
import org.jboss.shrinkwrap.impl.base.io.tar.TarInputStream;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.Assert;

public abstract class TarExporterTestBase
extends StreamExporterTestBase {
    protected abstract TarInputStream getTarInputStreamFromFile(File var1) throws IOException;

    protected final void ensureInExpectedForm(File file) throws IOException {
        this.assertAssetInTar(file, PATH_ONE, ASSET_ONE);
        this.assertAssetInTar(file, PATH_TWO, ASSET_TWO);
        this.getEntryFromTarFile(file, NESTED_PATH);
        InputStream rootEntry = this.getEntryFromTarFile(file, ArchivePaths.root());
        Assert.assertNull((String)"TAR.GZ should not have explicit root path written (SHRINKWRAP-96)", (Object)rootEntry);
    }

    protected final InputStream getContentsFromExportedFile(File file, ArchivePath path) throws IOException {
        assert (file != null) : "file must be specified";
        assert (path != null) : "path must be specified";
        return this.getEntryFromTarFile(file, path);
    }

    private void assertAssetInTar(File archive, ArchivePath path, Asset asset) throws IllegalArgumentException, IOException {
        InputStream in = this.getEntryFromTarFile(archive, path);
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        byte[] actualContents = IOUtil.asByteArray((InputStream)in);
        Assert.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }

    private InputStream getEntryFromTarFile(File archive, ArchivePath path) throws IllegalArgumentException, IOException {
        String entryPath = PathUtil.optionallyRemovePrecedingSlash((String)path.get());
        TarInputStream in = this.getTarInputStreamFromFile(archive);
        TarEntry currentEntry = null;
        while ((currentEntry = in.getNextEntry()) != null) {
            String entryName = currentEntry.getName();
            if (!entryName.equals(entryPath = currentEntry.isDirectory() ? PathUtil.optionallyAppendSlash((String)entryPath) : PathUtil.optionallyRemoveFollowingSlash((String)entryPath))) continue;
            return in;
        }
        return null;
    }
}

