/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplodedImporterImpl
extends AssignableBase<Archive<?>>
implements ExplodedImporter {
    private static final Logger log = Logger.getLogger(ExplodedImporterImpl.class.getName());

    public ExplodedImporterImpl(Archive<?> archive) {
        super(archive);
    }

    void a() {
    }

    public ExplodedImporter importDirectory(String fileName) {
        Validate.notNull(fileName, "FileName must be specified");
        return this.importDirectory(new File(fileName));
    }

    public ExplodedImporter importDirectory(File file) {
        Validate.notNull(file, "FileName must be specified");
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Given file is not a directory " + file.getAbsolutePath());
        }
        this.doImport(file, file.listFiles());
        return this;
    }

    private void doImport(File root, File[] files) {
        for (File file : files) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Importing: " + file.getAbsolutePath());
            }
            Object archive = this.getArchive();
            ArchivePath path = this.calculatePath(root, file);
            if (file.isDirectory()) {
                archive.addDirectory(path);
                this.doImport(root, file.listFiles());
                continue;
            }
            archive.add((Asset)new FileAsset(file), path);
        }
    }

    private ArchivePath calculatePath(File root, File child) {
        String rootPath = this.unifyPath(root.getPath());
        String childPath = this.unifyPath(child.getPath());
        String archiveChildPath = childPath.replaceFirst(rootPath, "");
        return new BasicPath(archiveChildPath);
    }

    private String unifyPath(String path) {
        return path.replaceAll("\\\\", "/");
    }
}

