/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExportTestBase {
    private static final Logger log = Logger.getLogger(ExportTestBase.class.getName());
    protected static final String NAME_ARCHIVE = "testArchive";
    protected static final String NAME_TEST_PROPERTIES = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    protected static final String NAME_TEST_PROPERTIES_2 = "org/jboss/shrinkwrap/impl/base/asset/Test2.properties";
    protected static final ArchivePath NESTED_PATH = new BasicPath("nested");
    protected static final String NAME_NESTED_ARCHIVE = "nestedArchive";
    protected static final String NAME_NESTED_ARCHIVE_2 = "nestedArchive2";
    protected static final Asset ASSET_ONE = new ClassLoaderAsset("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
    protected static final ArchivePath PATH_ONE = new BasicPath("Test.properties");
    protected static final Asset ASSET_TWO = new ClassLoaderAsset("org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
    protected static final ArchivePath PATH_TWO = new BasicPath(NESTED_PATH, "Test2.properties");
    protected static final ArchivePath PATH_EMPTY_NESTED_DIR = ArchivePaths.create((String)"/empty");
    protected static final ArchivePath PATH_EMPTY_TOPLEVEL_DIR = ArchivePaths.create((String)"/empty/directory");

    protected File createTempDirectory(String testName) throws IOException {
        File tempDirectoryParent = new File(this.getTarget(), this.getClass().getSimpleName());
        File tempDirectory = new File(tempDirectoryParent, testName);
        log.info("Temp Directory: " + tempDirectory.getCanonicalPath());
        if (tempDirectory.exists()) {
            TestIOUtil.deleteDirectory(tempDirectory);
        }
        Assert.assertTrue((String)"Temp directory should be clear before start", (!tempDirectory.exists() ? 1 : 0) != 0);
        boolean created = tempDirectory.mkdirs();
        Assert.assertEquals((String)("Could not create temp directory for tests: " + tempDirectory.getAbsolutePath()), (Object)true, (Object)created);
        return tempDirectory;
    }

    protected File getTarget() {
        try {
            return new File(new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()), "../");
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("Could not obtain the target URI", urise);
        }
    }

    protected Archive<?> createArchiveWithAssets() {
        Archive archive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)(NAME_ARCHIVE + this.getArchiveExtension()));
        this.addContent(archive);
        return archive;
    }

    protected abstract String getArchiveExtension();

    protected abstract Class<? extends StreamExporter> getExporterClass();

    protected Archive<?> createArchiveWithNestedArchives() {
        Archive<?> archive = this.createArchiveWithAssets();
        Archive nestedArchive = (Archive)ShrinkWrap.create(JavaArchive.class, (String)(NAME_NESTED_ARCHIVE + this.getArchiveExtension()));
        this.addContent(nestedArchive);
        archive.add(nestedArchive, ArchivePaths.root(), this.getExporterClass());
        Archive nestedArchiveTwo = (Archive)ShrinkWrap.create(JavaArchive.class, (String)(NAME_NESTED_ARCHIVE_2 + this.getArchiveExtension()));
        this.addContent(nestedArchiveTwo);
        archive.add(nestedArchiveTwo, NESTED_PATH, this.getExporterClass());
        archive.addAsDirectory(PATH_EMPTY_NESTED_DIR);
        archive.addAsDirectory(PATH_EMPTY_TOPLEVEL_DIR);
        return archive;
    }

    protected void addContent(Archive<?> archive) {
        archive.add(ASSET_ONE, PATH_ONE);
        archive.add(ASSET_TWO, PATH_TWO);
    }
}

