/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;

public class FileAsset
implements Asset {
    private File file;

    public FileAsset(File file) {
        Validate.notNull(file, "File must be specified");
        if (!file.exists()) {
            throw new IllegalArgumentException("File must exist: " + file.getAbsolutePath());
        }
        this.file = file;
    }

    public InputStream openStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not open file " + this.file, e);
        }
    }
}

