/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.asset;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.impl.base.Validate;

public class ServiceProviderAsset
implements Asset {
    private Class<?>[] providerImpls;

    public ServiceProviderAsset(Class<?> ... providerImpls) {
        Validate.notNullAndNoNullValues(providerImpls, "ProviderImpls must be specified and can not contain null values");
        this.providerImpls = providerImpls;
    }

    public InputStream openStream() {
        StringBuilder content = new StringBuilder();
        for (Class<?> providerImpl : this.providerImpls) {
            content.append(providerImpl.getName()).append('\n');
        }
        return new ByteArrayInputStream(content.toString().getBytes());
    }
}

