/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.asset.DirectoryAsset;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;

public class ExplodedExporterDelegate
extends AbstractExporterDelegate<File> {
    private static final Logger log = Logger.getLogger(ExplodedExporterDelegate.class.getName());
    private final File outputDirectory;

    public ExplodedExporterDelegate(Archive<?> archive, File baseDirectory) {
        super(archive);
        this.outputDirectory = this.initializeOutputDirectory(baseDirectory);
    }

    @Override
    protected void processAsset(Path path, Asset asset) {
        String assetFilePath = path.get();
        File assetFile = new File(this.outputDirectory, assetFilePath);
        File assetParent = assetFile.getParentFile();
        if (!assetParent.exists() && !assetParent.mkdirs()) {
            throw new ArchiveExportException("Failed to write asset.  Unable to create parent directory.");
        }
        if (asset instanceof ArchiveAsset) {
            ArchiveAsset nesteArchiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(asset);
            this.processArchiveAsset(assetParent, nesteArchiveAsset);
            return;
        }
        boolean isDirectory = asset instanceof DirectoryAsset;
        if (isDirectory) {
            if (!assetFile.exists() && !assetFile.mkdirs()) {
                throw new ArchiveExportException("Failed to write directory: " + assetFile.getAbsolutePath());
            }
        } else {
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Writing asset " + path.get() + " to " + assetFile.getAbsolutePath());
                }
                InputStream assetInputStream = asset.openStream();
                FileOutputStream assetFileOutputStream = new FileOutputStream(assetFile);
                BufferedOutputStream assetBufferedOutputStream = new BufferedOutputStream(assetFileOutputStream, 8192);
                IOUtil.copyWithClose(assetInputStream, assetBufferedOutputStream);
            }
            catch (Throwable t) {
                throw new ArchiveExportException("Failed to write asset " + path + " to " + assetFile);
            }
        }
    }

    @Override
    protected File getResult() {
        return this.outputDirectory;
    }

    private void processArchiveAsset(File parentDirectory, ArchiveAsset nestedArchiveAsset) {
        Archive<?> nestedArchive = nestedArchiveAsset.getArchive();
        ((ExplodedExporter)nestedArchive.as(ExplodedExporter.class)).exportExploded(parentDirectory);
    }

    private File initializeOutputDirectory(File baseDirectory) {
        Archive<?> archive = this.getArchive();
        File outputDirectory = new File(baseDirectory, archive.getName());
        if (!outputDirectory.mkdir() && !outputDirectory.exists()) {
            throw new ArchiveExportException("Unable to create archive output directory - " + outputDirectory);
        }
        if (outputDirectory.isFile()) {
            throw new IllegalArgumentException("Unable to export exploded directory to " + outputDirectory.getAbsolutePath() + ", it points to a existing file");
        }
        return outputDirectory;
    }
}

