/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.impl.base.asset.DirectoryAsset;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.io.StreamErrorHandler;
import org.jboss.shrinkwrap.impl.base.io.StreamTask;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;

public class ZipExportDelegate
extends AbstractExporterDelegate<InputStream> {
    private static final Logger log = Logger.getLogger(ZipExportDelegate.class.getName());
    private final ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
    private ZipOutputStream zipOutputStream;
    private Set<Path> pathsExported = new HashSet<Path>();

    public ZipExportDelegate(Archive<?> archive) {
        super(archive);
    }

    @Override
    protected void export() {
        this.zipOutputStream = new ZipOutputStream(this.output);
        IOUtil.closeOnComplete(this.zipOutputStream, new StreamTask<ZipOutputStream>(){

            @Override
            public void execute(ZipOutputStream stream) throws Exception {
                ZipExportDelegate.super.export();
            }
        }, new StreamErrorHandler(){

            @Override
            public void handle(Throwable t) {
                throw new ArchiveExportException("Failed to export Zip: " + ZipExportDelegate.this.getArchive().getName(), t);
            }
        });
    }

    @Override
    protected void processAsset(final Path path, Asset asset) {
        if (path == null) {
            throw new IllegalArgumentException("Path must be specified");
        }
        if (this.isParentOfAnyPathsExported(path)) {
            return;
        }
        Path parent = PathUtil.getParent(path);
        if (parent != null && !this.pathsExported.contains(parent)) {
            boolean isRoot;
            Path grandParent = PathUtil.getParent(parent);
            boolean bl = isRoot = grandParent == null;
            if (!isRoot) {
                this.processAsset(parent, null);
            }
        }
        final boolean isDirectory = asset == null || asset instanceof DirectoryAsset;
        InputStream assetStream = !isDirectory ? asset.openStream() : null;
        final String pathName = PathUtil.optionallyRemovePrecedingSlash(path.get());
        if (!this.pathsExported.contains(path)) {
            IOUtil.closeOnComplete(assetStream, new StreamTask<InputStream>(){

                @Override
                public void execute(InputStream stream) throws Exception {
                    String resolvedPath = pathName;
                    if (isDirectory) {
                        resolvedPath = PathUtil.optionallyAppendSlash(resolvedPath);
                    }
                    ZipEntry entry = new ZipEntry(resolvedPath);
                    try {
                        ZipExportDelegate.this.zipOutputStream.putNextEntry(entry);
                    }
                    catch (ZipException ze) {
                        log.log(Level.SEVERE, ZipExportDelegate.this.pathsExported.toString());
                        throw new RuntimeException(ze);
                    }
                    ZipExportDelegate.this.pathsExported.add(path);
                    if (!isDirectory) {
                        IOUtil.copy(stream, ZipExportDelegate.this.zipOutputStream);
                    }
                    ZipExportDelegate.this.zipOutputStream.closeEntry();
                }
            }, new StreamErrorHandler(){

                @Override
                public void handle(Throwable t) {
                    throw new ArchiveExportException("Failed to write asset to Zip: " + pathName, t);
                }
            });
        }
    }

    @Override
    protected InputStream getResult() {
        byte[] zipContent = this.output.toByteArray();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Created Zip of size: " + zipContent.length + " bytes");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(zipContent);
        return inputStream;
    }

    private boolean isParentOfAnyPathsExported(Path path) {
        for (Path exportedPath : this.pathsExported) {
            if (!this.isParentOfSpecifiedHierarchy(path, exportedPath)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOfSpecifiedHierarchy(Path path, Path compare) {
        Path parent = PathUtil.getParent(compare);
        if (parent == null) {
            return false;
        }
        if (path.equals(compare)) {
            return true;
        }
        return this.isParentOfSpecifiedHierarchy(path, parent);
    }
}

