/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.InputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.exporter.ZipArchiveInputStreamFactory;

public abstract class ArchiveInputStreamFactory {
    private static ArchiveInputStreamFactory instance;

    public static InputStream getInputStream(Archive<?> archive) {
        Validate.notNull(archive, "archive was not provided");
        ArchiveInputStreamFactory factory = ArchiveInputStreamFactory.getInstance(archive);
        return factory.doGetInputStream(archive);
    }

    private static synchronized ArchiveInputStreamFactory getInstance(Archive<?> archive) {
        if (instance == null) {
            instance = new ZipArchiveInputStreamFactory();
        }
        return instance;
    }

    protected abstract InputStream doGetInputStream(Archive<?> var1);
}

