/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.impl.base.Validate;

public class URLPackageScanner {
    private static final Logger log = Logger.getLogger(URLPackageScanner.class.getName());
    private final String packageName;
    private final String packageNamePath;
    private final boolean addRecursively;
    private final ClassLoader classLoader;
    private final Set<Class<?>> classes = new HashSet();

    public static URLPackageScanner newInstance(Package pkg, boolean addRecursively, ClassLoader classLoader) {
        Validate.notNull(pkg, "Pkg must be specified");
        Validate.notNull(pkg.getName(), "Pkg must have a name");
        Validate.notNull(addRecursively, "AddRecursively must be specified");
        Validate.notNull(classLoader, "ClassLoader must be specified");
        return new URLPackageScanner(pkg, addRecursively, classLoader);
    }

    private URLPackageScanner(Package pkg, boolean addRecursively, ClassLoader classLoader) {
        this.packageName = pkg.getName();
        this.packageNamePath = this.packageName.replace(".", "/");
        this.addRecursively = addRecursively;
        this.classLoader = classLoader;
    }

    private void scanPackage() {
        try {
            HashSet<String> paths = new HashSet<String>();
            for (URL url : this.loadResources(this.packageNamePath)) {
                String urlPath = url.getFile();
                if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                paths.add(urlPath);
            }
            this.handle(paths);
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "could not read: " + this.packageName, ioe);
        }
        catch (ClassNotFoundException ioe) {
            log.log(Level.WARNING, "Class coud not be loaded in package: " + this.packageName, ioe);
        }
    }

    private void handleArchiveByFile(File file) throws IOException, ClassNotFoundException {
        try {
            log.fine("archive: " + file);
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(this.packageNamePath) || !name.endsWith(".class") || !this.addRecursively && name.substring(this.packageNamePath.length() + 1).contains("/")) continue;
                String className = name.replace("/", ".").replace(".class", "");
                this.classes.add(this.classLoader.loadClass(className));
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handle(Set<String> paths) throws IOException, ClassNotFoundException {
        for (String urlPath : paths) {
            log.fine("scanning: " + urlPath);
            File file = new File(urlPath);
            if (file.isDirectory()) {
                this.handle(file, this.packageName);
                continue;
            }
            this.handleArchiveByFile(file);
        }
    }

    private void handle(File file, String packageName) throws ClassNotFoundException {
        for (File child : file.listFiles()) {
            if (!child.isDirectory() && child.getName().endsWith(".class")) {
                this.classes.add(this.classLoader.loadClass(packageName + "." + child.getName().substring(0, child.getName().lastIndexOf(".class"))));
                continue;
            }
            if (!child.isDirectory() || !this.addRecursively) continue;
            this.handle(child, packageName + "." + child.getName());
        }
    }

    public List<URL> loadResources(String name) throws IOException {
        return Collections.list(this.classLoader.getResources(name));
    }

    public Set<Class<?>> getClasses() {
        this.scanPackage();
        return this.classes;
    }
}

