/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.api.exporter.FileExistsException;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.exporter.AbstractExporterDelegate;
import org.jboss.shrinkwrap.impl.base.exporter.JdkZipExporterDelegate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;

public class ZipExporterImpl
extends AssignableBase
implements ZipExporter {
    private static final Logger log = Logger.getLogger(ZipExporterImpl.class.getName());
    private Archive<?> archive;

    public ZipExporterImpl(Archive<?> archive) {
        Validate.notNull(archive, "Archive must be specified");
        this.archive = archive;
    }

    @Override
    protected Archive<?> getArchive() {
        return this.archive;
    }

    public InputStream exportZip() {
        JdkZipExporterDelegate exportDelegate = new JdkZipExporterDelegate(this.archive);
        ((AbstractExporterDelegate)exportDelegate).export();
        InputStream stream = (InputStream)((AbstractExporterDelegate)exportDelegate).getResult();
        return stream;
    }

    public void exportZip(OutputStream target) throws ArchiveExportException, IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("Target must be specified");
        }
        InputStream in = this.exportZip();
        try {
            IOUtil.copyWithClose(in, target);
        }
        catch (IOException e) {
            throw new ArchiveExportException("Error encountered in exporting archive to " + target, (Throwable)e);
        }
    }

    public void exportZip(File target, boolean overwrite) throws ArchiveExportException, FileExistsException, IllegalArgumentException {
        FileOutputStream out;
        if (target == null) {
            throw new IllegalArgumentException("Target file must be specified");
        }
        if (target.exists() && !overwrite) {
            throw new FileExistsException("Target exists and we haven't been flagged to overwrite it: " + target.getAbsolutePath());
        }
        try {
            out = new FileOutputStream(target);
        }
        catch (FileNotFoundException e) {
            throw new ArchiveExportException("File could not be created: " + target);
        }
        this.exportZip(out);
    }

    public void exportZip(File target) throws ArchiveExportException, FileExistsException, IllegalArgumentException {
        this.exportZip(target, false);
    }
}

