/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.impl.base.asset.DirectoryAsset;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public class ZipImporterImpl
extends AssignableBase
implements ZipImporter {
    private static final Logger log = Logger.getLogger(ZipImporter.class.getName());
    private Archive<?> archive;

    public ZipImporterImpl(Archive<?> archive) {
        Validate.notNull(archive, "Archive must be specified");
        this.archive = archive;
    }

    @Override
    protected Archive<?> getArchive() {
        return this.archive;
    }

    public ZipImporter importZip(ZipInputStream stream) {
        Validate.notNull(stream, "Stream must be specified");
        try {
            ZipEntry entry;
            while ((entry = stream.getNextEntry()) != null) {
                int readBytes;
                String entryName = entry.getName();
                if (entry.isDirectory()) {
                    this.archive.add((Asset)DirectoryAsset.INSTANCE, entryName);
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
                byte[] content = new byte[4096];
                while ((readBytes = stream.read(content, 0, content.length)) != -1) {
                    output.write(content, 0, readBytes);
                }
                this.archive.add((Asset)new ByteArrayAsset(output.toByteArray()), entryName);
                stream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new ArchiveImportException("Could not import stream", (Throwable)e);
        }
        finally {
            block13: {
                try {
                    stream.close();
                }
                catch (Exception ignore) {
                    if (!log.isLoggable(Level.FINER)) break block13;
                    log.finer("Caught and ignoring exception while closing instream during import" + ignore);
                }
            }
        }
        return this;
    }

    public ZipImporter importZip(ZipFile file) {
        Validate.notNull(file, "File must be specified");
        try {
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entry.isDirectory()) {
                    this.archive.add((Asset)DirectoryAsset.INSTANCE, entryName);
                    continue;
                }
                this.archive.add((Asset)new ZipFileEntryAsset(file, entry), (ArchivePath)new BasicPath(entryName));
            }
        }
        catch (Exception e) {
            throw new ArchiveImportException("Could not import file", (Throwable)e);
        }
        return this;
    }
}

