/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.path;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;

public class BasicPath
implements ArchivePath,
Comparable<ArchivePath> {
    private static final Logger log = Logger.getLogger(BasicPath.class.getName());
    private final String context;

    public BasicPath() {
        this(null);
    }

    public BasicPath(String context) {
        String resolvedContext = PathUtil.optionallyPrependSlash(context);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Resolved \"" + context + "\" to absolute form: " + resolvedContext);
        }
        this.context = resolvedContext;
    }

    public BasicPath(ArchivePath basePath, ArchivePath context) {
        this(basePath, context.get());
    }

    public BasicPath(ArchivePath basePath, String context) {
        this(basePath.get(), context);
    }

    public BasicPath(String basePath, String context) {
        this(PathUtil.composeAbsoluteContext(basePath, context));
    }

    public String get() {
        return this.context;
    }

    public ArchivePath getParent() {
        return PathUtil.getParent(this);
    }

    @Override
    public int compareTo(ArchivePath path) {
        if (path == null) {
            return 1;
        }
        ArchivePath parentOfSpecified = PathUtil.getParent(path);
        ArchivePath parentOfThis = PathUtil.getParent(this);
        if (this.equals(parentOfSpecified)) {
            return -1;
        }
        if (path.equals(parentOfThis)) {
            return 1;
        }
        int comparedContexts = path.get().compareTo(this.get());
        int adjusted = 0 - comparedContexts;
        return adjusted;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        String adjustedOther;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicPath other = (BasicPath)obj;
        if (this.context == null && other.context != null) {
            return false;
        }
        String adjustedContext = PathUtil.optionallyRemoveFollowingSlash(this.context);
        return adjustedContext.equals(adjustedOther = PathUtil.optionallyRemoveFollowingSlash(other.context));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [context=" + this.context + "]";
    }
}

