/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.path;

import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

public final class PathUtil {
    public static final char SLASH = '/';
    public static final String EMPTY = "";

    private PathUtil() {
        throw new UnsupportedOperationException("Constructor should never be invoked; this is a static util class");
    }

    public static String composeAbsoluteContext(String base, String context) {
        PathUtil.assertSpecified(base);
        PathUtil.assertSpecified(context);
        String relative = PathUtil.adjustToAbsoluteDirectoryContext(base);
        String reformedContext = PathUtil.optionallyRemovePrecedingSlash(context);
        String actual = relative + reformedContext;
        return actual;
    }

    public static String adjustToRelativeDirectoryContext(String path) {
        if (path == null) {
            return path;
        }
        String removedPrefix = PathUtil.optionallyRemovePrecedingSlash(path);
        String addedPostfix = PathUtil.optionallyAppendSlash(removedPrefix);
        return addedPostfix;
    }

    public static String adjustToAbsoluteDirectoryContext(String path) {
        if (path == null) {
            return path;
        }
        String prefixedPath = PathUtil.optionallyPrependSlash(path);
        String addedPostfix = PathUtil.optionallyAppendSlash(prefixedPath);
        return addedPostfix;
    }

    public static String optionallyRemovePrecedingSlash(String path) {
        PathUtil.assertSpecified(path);
        if (PathUtil.isFirstCharSlash(path)) {
            return path.substring(1);
        }
        return path;
    }

    public static String optionallyRemoveFollowingSlash(String path) {
        PathUtil.assertSpecified(path);
        if (PathUtil.isLastCharSlash(path)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String optionallyAppendSlash(String path) {
        PathUtil.assertSpecified(path);
        if (!PathUtil.isLastCharSlash(path)) {
            return path + '/';
        }
        return path;
    }

    public static String optionallyPrependSlash(String path) {
        String resolved = path;
        if (resolved == null) {
            resolved = EMPTY;
        }
        if (!PathUtil.isFirstCharSlash(resolved)) {
            return '/' + resolved;
        }
        return resolved;
    }

    static ArchivePath getParent(ArchivePath path) {
        assert (path != null) : "Path must be specified";
        String resolvedContext = PathUtil.optionallyRemoveFollowingSlash(path.get());
        int lastIndex = resolvedContext.lastIndexOf(47);
        if (lastIndex == -1 || lastIndex == 0 && resolvedContext.length() == 1) {
            return null;
        }
        String sub = resolvedContext.substring(0, lastIndex);
        return new BasicPath(PathUtil.optionallyAppendSlash(sub));
    }

    private static boolean isFirstCharSlash(String path) {
        PathUtil.assertSpecified(path);
        if (path.length() == 0) {
            return false;
        }
        return path.charAt(0) == '/';
    }

    private static boolean isLastCharSlash(String path) {
        PathUtil.assertSpecified(path);
        if (path.length() == 0) {
            return false;
        }
        return path.charAt(path.length() - 1) == '/';
    }

    private static void assertSpecified(String path) {
        assert (path != null) : "Path must be specified";
    }
}

