/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.impl.base.exporter.ExportTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.Test;

public class ZipExporterStressTest
extends ExportTestBase {
    private static final Logger log = Logger.getLogger(ZipExporterStressTest.class.getName());
    private static BigDecimal MEGA = new BigDecimal(0x100000);

    @Test
    public void exportHugeArchive() throws IOException {
        long startFreeMemBytes;
        log.info("exportHugeArchive");
        log.info("This test may take awhile as it's intended to fill memory");
        JavaArchive archive = (JavaArchive)Archives.create((String)"hugeArchive.jar", JavaArchive.class);
        Runtime runtime = Runtime.getRuntime();
        long beforeExportFreeMemBytes = startFreeMemBytes = ZipExporterStressTest.totalFreeMemory(runtime);
        int counter = 0;
        String pathPrefix = "path";
        while ((double)beforeExportFreeMemBytes > (double)startFreeMemBytes * 0.3) {
            archive.add((Asset)MegaByteAsset.newInstance(), "path" + counter++);
            System.gc();
            beforeExportFreeMemBytes = ZipExporterStressTest.totalFreeMemory(runtime);
            log.info("Current Free Memory (MB): " + this.megaBytesFromBytes(beforeExportFreeMemBytes));
        }
        log.info("Wrote: " + archive.toString());
        log.info("Started w/ free memory (MB): " + this.megaBytesFromBytes(startFreeMemBytes));
        log.info("Free memory before export (MB): " + this.megaBytesFromBytes(beforeExportFreeMemBytes));
        InputStream in = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
        CountingOutputStream out = new CountingOutputStream();
        IOUtil.copyWithClose((InputStream)in, (OutputStream)out);
        TestCase.assertTrue((String)"Test setup failed; we should be writing out more bytes than we have free memory", (out.bytesWritten > beforeExportFreeMemBytes ? 1 : 0) != 0);
        log.info("Final ZIP export was: " + this.megaBytesFromBytes(out.bytesWritten) + " MB");
        long afterExportFreeMemBytes = ZipExporterStressTest.totalFreeMemory(runtime);
        log.info("Free memory after export (MB): " + this.megaBytesFromBytes(afterExportFreeMemBytes));
    }

    private BigDecimal megaBytesFromBytes(long bytes) {
        return new BigDecimal(bytes).divide(MEGA).setScale(2, RoundingMode.HALF_UP);
    }

    private static long totalFreeMemory(Runtime runtime) {
        return runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
    }

    private static class CountingOutputStream
    extends OutputStream {
        long bytesWritten = 0L;

        private CountingOutputStream() {
        }

        public void write(int b) throws IOException {
            ++this.bytesWritten;
        }
    }

    private static class MegaByteAsset
    extends ByteArrayAsset
    implements Asset {
        private static int MEGA = 0x100000;
        private static final Random random = new Random();

        private MegaByteAsset(byte[] content) {
            super(content);
        }

        static MegaByteAsset newInstance() {
            byte[] content = new byte[MEGA];
            random.nextBytes(content);
            return new MegaByteAsset(content);
        }
    }
}

