/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.api.exporter.FileExistsException;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.exporter.ExportTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.junit.Assert;
import org.junit.Test;

public class ZipExporterTestCase
extends ExportTestBase {
    private static final Logger log = Logger.getLogger(ZipExporterTestCase.class.getName());

    @Test
    public void testExportZip() throws Exception {
        log.info("testExportZip");
        File tempDirectory = this.createTempDirectory("testExportZip");
        Archive<?> archive = this.createArchiveWithAssets();
        InputStream zipStream = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
        ZipFile expectedZip = this.getExportedZipFile("testArchive.jar", zipStream, tempDirectory);
        this.ensureZipFileInExpectedForm(expectedZip);
    }

    @Test(expected=IllegalArgumentException.class)
    public void exportEmptyArchiveAsZip() throws Exception {
        ((ZipExporter)((JavaArchive)Archives.create((String)"testArchive.jar", JavaArchive.class)).as(ZipExporter.class)).exportZip();
    }

    @Test
    public void testExportArchiveWithOnlyDirectories() {
        ((ZipExporter)((JavaArchive)((JavaArchive)Archives.create((String)"testArchive.jar", JavaArchive.class)).addDirectories(new String[]{"/test/game"})).as(ZipExporter.class)).exportZip();
    }

    @Test
    public void testExportZipToFile() throws IOException {
        log.info("testExportZipToFile");
        File tempDirectory = this.createTempDirectory("testExportZipToFile");
        Archive<?> archive = this.createArchiveWithAssets();
        File exported = new File(tempDirectory, archive.getName());
        ((ZipExporter)archive.as(ZipExporter.class)).exportZip(exported, true);
        ZipFile expectedZip = new ZipFile(exported);
        this.ensureZipFileInExpectedForm(expectedZip);
    }

    @Test
    public void testExportZipToOutStream() throws IOException {
        log.info("testExportZipToOutStream");
        File tempDirectory = this.createTempDirectory("testExportZipToOutStream");
        Archive<?> archive = this.createArchiveWithAssets();
        File serializedArchive = new File(tempDirectory, archive.getName());
        FileOutputStream out = new FileOutputStream(serializedArchive);
        ((ZipExporter)archive.as(ZipExporter.class)).exportZip((OutputStream)out);
        ZipFile expectedZip = new ZipFile(serializedArchive);
        this.ensureZipFileInExpectedForm(expectedZip);
    }

    @Test(expected=FileExistsException.class)
    public void testExportZipToExistingFileFails() throws IOException {
        log.info("testExportZipToExistingFileFails");
        File tempDirectory = this.createTempDirectory("testExportZipToExistingFileFails");
        Archive<?> archive = this.createArchiveWithAssets();
        File alreadyExists = new File(tempDirectory, archive.getName());
        FileOutputStream alreadyExistsOutputStream = new FileOutputStream(alreadyExists);
        ((OutputStream)alreadyExistsOutputStream).write(new byte[0]);
        ((OutputStream)alreadyExistsOutputStream).close();
        TestCase.assertTrue((String)"The test setup is incorrect; an empty file should exist before writing the archive", (boolean)alreadyExists.exists());
        ((ZipExporter)archive.as(ZipExporter.class)).exportZip(alreadyExists);
    }

    @Test
    public void testExportNestedZip() throws Exception {
        log.info("testExportNestedZip");
        File tempDirectory = this.createTempDirectory("testExportNestedZip");
        Archive<?> archive = this.createArchiveWithNestedArchives();
        InputStream zipStream = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
        ZipFile expectedZip = this.getExportedZipFile("testArchive.jar", zipStream, tempDirectory);
        this.assertAssetInZip(expectedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(expectedZip, PATH_TWO, ASSET_TWO);
        BasicPath nestedArchivePath = new BasicPath("nestedArchive.jar");
        String nestedArchiveZipEntryPath = PathUtil.optionallyRemovePrecedingSlash((String)nestedArchivePath.get());
        ZipEntry nestedArchiveEntry = expectedZip.getEntry(nestedArchiveZipEntryPath);
        InputStream nesterArchiveStream = expectedZip.getInputStream(nestedArchiveEntry);
        ZipFile nestedZip = this.getExportedZipFile("nestedArchive.jar", nesterArchiveStream, tempDirectory);
        this.assertAssetInZip(nestedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(nestedZip, PATH_TWO, ASSET_TWO);
        BasicPath nestedArchiveTwoPath = new BasicPath(NESTED_PATH, "nestedArchive2.jar");
        String nestedArchiveTwoZipEntryPath = PathUtil.optionallyRemovePrecedingSlash((String)nestedArchiveTwoPath.get());
        ZipEntry nestedArchiveTwoEntry = expectedZip.getEntry(nestedArchiveTwoZipEntryPath);
        InputStream nesterArchiveTwoStream = expectedZip.getInputStream(nestedArchiveTwoEntry);
        ZipFile nestedZipTwo = this.getExportedZipFile("nestedArchive2.jar", nesterArchiveTwoStream, tempDirectory);
        this.assertAssetInZip(nestedZipTwo, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(nestedZipTwo, PATH_TWO, ASSET_TWO);
    }

    @Test(expected=ArchiveExportException.class)
    public void testExportThrowsArchiveExceptionOnAssetWriteFailure() throws IOException {
        log.info("testExportThrowsArchiveExceptionOnAssetWriteFailure");
        Archive<?> archive = this.createArchiveWithAssets();
        archive.add(new Asset(){

            public InputStream openStream() {
                throw new RuntimeException("Mock Exception from an Asset write");
            }
        }, PATH_ONE);
        InputStream in = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
        OutputStream sink = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        IOUtil.copyWithClose((InputStream)in, (OutputStream)sink);
    }

    private ZipFile getExportedZipFile(String archiveName, InputStream zipStream, File tempDirectory) throws Exception {
        Assert.assertNotNull((Object)zipStream);
        File outFile = new File(tempDirectory, archiveName);
        this.writeOutFile(outFile, zipStream);
        ZipFile expectedZip = new ZipFile(outFile);
        return expectedZip;
    }

    private void assertAssetInZip(ZipFile expectedZip, ArchivePath path, Asset asset) throws IllegalArgumentException, IOException {
        ZipEntry entry = this.getEntryFromZip(expectedZip, path);
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        byte[] actualContents = IOUtil.asByteArray((InputStream)expectedZip.getInputStream(entry));
        Assert.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }

    private ZipEntry getEntryFromZip(ZipFile expectedZip, ArchivePath path) throws IllegalArgumentException, IOException {
        String entryPath = PathUtil.optionallyRemovePrecedingSlash((String)path.get());
        ZipEntry entry = expectedZip.getEntry(entryPath);
        Assert.assertNotNull((String)("Expected path not found in ZIP: " + path), (Object)entry);
        return entry;
    }

    private void writeOutFile(File outFile, InputStream inputStream) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(outFile);
        IOUtil.copyWithClose((InputStream)inputStream, (OutputStream)fileOutputStream);
    }

    private void ensureZipFileInExpectedForm(ZipFile expectedZip) throws IOException {
        this.assertAssetInZip(expectedZip, PATH_ONE, ASSET_ONE);
        this.assertAssetInZip(expectedZip, PATH_TWO, ASSET_TWO);
        this.getEntryFromZip(expectedZip, NESTED_PATH);
        ZipEntry rootEntry = expectedZip.getEntry("/");
        Assert.assertNull((String)"ZIP should not have explicit root path written (SHRINKWRAP-96)", (Object)rootEntry);
    }
}

