/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.importer.SecurityActions;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipImporterImplTestCase {
    private static final Logger log = Logger.getLogger(ZipImporterImplTestCase.class.getName());
    private static final String EXISTING_ZIP_RESOURCE = "org/jboss/shrinkwrap/impl/base/importer/test.zip";
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    private static final String EXPECTED_EMPTY_DIR = "empty_dir/";
    private static final String EXPECTED_NESTED_EMPTY_DIR = "parent/empty_dir/";

    @Test
    public void shouldBeAbleToimportZipFile() throws Exception {
        ZipFile testZip = new ZipFile(new File(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_ZIP_RESOURCE).toURI()));
        Archive archive = (Archive)((ZipImporter)Archives.create((String)"test.jar", ZipImporter.class)).importZip(testZip).as(JavaArchive.class);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        this.assertContent(archive, SecurityActions.getThreadContextClassLoader().getResource(EXISTING_ZIP_RESOURCE).toURI());
    }

    @Test
    public void shouldBeAbleToImportAddAndExport() throws Exception {
        ZipInputStream stream = new ZipInputStream(SecurityActions.getThreadContextClassLoader().getResourceAsStream(EXISTING_ZIP_RESOURCE));
        Archive archive = (Archive)((ZipImporter)Archives.create((String)"test.jar", ZipImporter.class)).importZip(stream).as(JavaArchive.class);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        archive.add((Asset)new ClassLoaderAsset(EXISTING_RESOURCE), (ArchivePath)new BasicPath("test.properties"));
        File tempFile = new File("target/test.zip");
        tempFile.deleteOnExit();
        InputStream zipStream = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
        IOUtil.copyWithClose((InputStream)zipStream, (OutputStream)new FileOutputStream(tempFile));
        this.assertContent(archive, tempFile.toURI());
    }

    @Test
    public void shouldBeAbleToImportZipInputStream() throws Exception {
        ZipInputStream stream = new ZipInputStream(SecurityActions.getThreadContextClassLoader().getResourceAsStream(EXISTING_ZIP_RESOURCE));
        Archive archive = (Archive)((ZipImporter)Archives.create((String)"test.jar", ZipImporter.class)).importZip(stream).as(JavaArchive.class);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        this.assertContent(archive, SecurityActions.getThreadContextClassLoader().getResource(EXISTING_ZIP_RESOURCE).toURI());
    }

    @Test(expected=ArchiveImportException.class)
    public void shouldThrowExceptionOnErrorInImportFromStream() throws Exception {
        ZipInputStream stream = new ZipInputStream(new InputStream(){

            public int read() throws IOException {
                throw new IOException("Mock exception");
            }
        });
        ((ZipImporter)Archives.create((String)"test.jar", ZipImporter.class)).importZip(stream).as(JavaArchive.class);
    }

    @Test(expected=ArchiveImportException.class)
    public void shouldThrowExceptionOnErrorInImportFromFile() throws Exception {
        ZipFile testZip = new ZipFile(new File(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_ZIP_RESOURCE).toURI())){

            @Override
            public Enumeration<? extends ZipEntry> entries() {
                throw new IllegalStateException("mock  exception");
            }
        };
        ((ZipImporter)Archives.create((String)"test.jar", ZipImporter.class)).importZip(testZip).as(JavaArchive.class);
    }

    private void assertContent(Archive<?> importedArchive, URI originalSource) throws Exception {
        Assert.assertFalse((String)"Should have imported something", (boolean)importedArchive.getContent().isEmpty());
        ZipFile testZip = new ZipFile(new File(originalSource));
        ArrayList<? extends ZipEntry> entries = Collections.list(testZip.entries());
        Assert.assertFalse((String)"Test zip should contain data", (boolean)entries.isEmpty());
        Assert.assertEquals((String)"Should have imported all files and directories", (int)entries.size(), (int)importedArchive.getContent().size());
        boolean containsEmptyDir = false;
        boolean containsEmptyNestedDir = false;
        for (ZipEntry zipEntry : entries) {
            if (zipEntry.isDirectory()) {
                if (zipEntry.getName().equals(EXPECTED_EMPTY_DIR)) {
                    containsEmptyDir = true;
                }
                if (!zipEntry.getName().equals(EXPECTED_NESTED_EMPTY_DIR)) continue;
                containsEmptyNestedDir = true;
                continue;
            }
            Assert.assertTrue((String)("Importer should have imported " + zipEntry.getName() + " from " + originalSource), (boolean)importedArchive.contains((ArchivePath)new BasicPath(zipEntry.getName())));
            byte[] originalContent = IOUtil.asByteArray((InputStream)testZip.getInputStream(zipEntry));
            byte[] importedContent = IOUtil.asByteArray((InputStream)importedArchive.get((ArchivePath)new BasicPath(zipEntry.getName())).getAsset().openStream());
            log.fine(Arrays.equals(importedContent, originalContent) + "\t" + originalContent.length + "\t" + importedContent.length + "\t" + zipEntry.getName());
            Assert.assertTrue((String)("The content of " + zipEntry.getName() + " should be equal to the imported content"), (boolean)Arrays.equals(importedContent, originalContent));
        }
        Assert.assertTrue((String)"Empty directory not imported", (boolean)containsEmptyDir);
        Assert.assertTrue((String)"Empty nested directory not imported", (boolean)containsEmptyNestedDir);
    }
}

