/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader;
import org.junit.Test;

public class ServiceExtensionLoaderTestCase {
    @Test
    public void shouldBeAbleToLoadExtension() throws Exception {
        Extension extension = (Extension)new ServiceExtensionLoader().load(Extension.class, (Archive)Archives.create((String)"test.jar", JavaArchive.class));
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((extension.getClass() == ExtensionImpl.class ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeAbleToOverrideExtension() throws Exception {
        Extension extension = (Extension)new ServiceExtensionLoader().addOverride(Extension.class, ExtensionImpl2.class).load(Extension.class, (Archive)Archives.create((String)"test.jar", JavaArchive.class));
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((extension.getClass() == ExtensionImpl2.class ? 1 : 0) != 0);
    }

    @Test
    public void shouldBePlacedInCacheAfterLoad() throws Exception {
        ServiceExtensionLoader loader = new ServiceExtensionLoader();
        loader.load(Extension.class, (Archive)Archives.create((String)"test.jar", JavaArchive.class));
        Assert.assertTrue((String)"Should be placed in cache", (boolean)loader.isCached(Extension.class));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionOnMissingExtension() throws Exception {
        new ServiceExtensionLoader().load(MissingExtension.class, (Archive)Archives.create((String)"test.jar", JavaArchive.class));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionOnWrongImplType() throws Exception {
        new ServiceExtensionLoader().load(WrongImplExtension.class, (Archive)Archives.create((String)"test.jar", JavaArchive.class));
    }

    public static interface MissingExtension
    extends Assignable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionImpl2
    extends AssignableBase
    implements Extension {
        private Archive<?> archive;

        public ExtensionImpl2(Archive<?> archive) {
            this.archive = archive;
        }

        protected Archive<?> getArchive() {
            return this.archive;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionImpl
    extends AssignableBase
    implements Extension {
        private Archive<?> archive;

        public ExtensionImpl(Archive<?> archive) {
            this.archive = archive;
        }

        protected Archive<?> getArchive() {
            return this.archive;
        }
    }

    public static interface Extension
    extends Assignable {
    }

    public static interface WrongImplExtension
    extends Assignable {
    }
}

