/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.util.UUID;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicEnterpriseContainerTestBase;
import org.junit.After;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ArchiveType(value=EnterpriseArchive.class)
public class EnterpriseArchiveImplTestCase
extends DynamicEnterpriseContainerTestBase<EnterpriseArchive> {
    private static final ArchivePath PATH_APPLICATION = new BasicPath("META-INF");
    private static final ArchivePath PATH_LIBRARY = new BasicPath("lib");
    private static final ArchivePath PATH_MODULE = new BasicPath("/");
    private EnterpriseArchive archive;

    @Before
    public void createEnterpriseArchive() throws Exception {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected EnterpriseArchive getArchive() {
        return this.archive;
    }

    protected EnterpriseArchive createNewArchive() {
        return (EnterpriseArchive)Archives.create((String)(UUID.randomUUID().toString() + ".jar"), EnterpriseArchive.class);
    }

    @Override
    protected ClassContainer<EnterpriseArchive> getClassContainer() {
        throw new UnsupportedOperationException("EnterpriseArchives do not support classes");
    }

    @Override
    protected ArchivePath getClassPath() {
        throw new UnsupportedOperationException("EnterpriseArchives do not support classes");
    }

    @Override
    protected LibraryContainer<EnterpriseArchive> getLibraryContainer() {
        return this.archive;
    }

    @Override
    protected ArchivePath getManifestPath() {
        return PATH_APPLICATION;
    }

    @Override
    protected ArchivePath getResourcePath() {
        return PATH_APPLICATION;
    }

    @Override
    protected ArchivePath getLibraryPath() {
        return PATH_LIBRARY;
    }

    @Override
    protected ManifestContainer<EnterpriseArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<EnterpriseArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected ArchivePath getModulePath() {
        return PATH_MODULE;
    }

    @Override
    protected ArchivePath getApplicationPath() {
        return PATH_APPLICATION;
    }

    @Override
    protected EnterpriseContainer<EnterpriseArchive> getEnterpriseContainer() {
        return this.getArchive();
    }
}

