/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.ExtensionLoader;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class ShrinkWrapTestCase {
    @Test
    public void createNewArchiveUnderDefaultDomain() {
        String archiveName = "test.war";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create((String)"test.war", JavaArchive.class);
        Assert.assertNotNull((String)"A archive should have been created", (Object)archive);
        Assert.assertEquals((String)"Should have the same name as given imput", (String)"test.war", (String)archive.getName());
    }

    @Test
    public void createIsolatedDomains() {
        Domain domain1 = ShrinkWrap.createDomain();
        Domain domain2 = ShrinkWrap.createDomain();
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain1);
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain2);
        TestCase.assertNotSame((String)"Creation of domains should return new instances", (Object)domain1, (Object)domain2);
        TestCase.assertNotSame((String)"Creation of domains should have unique / isolated configurations", (Object)domain1.getConfiguration(), (Object)domain2.getConfiguration());
    }

    @Test
    public void createDomainWithExplicitConfiguration() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        MockExtensionLoader loader = new MockExtensionLoader();
        Domain domain = ShrinkWrap.createDomain((Configuration)new ConfigurationBuilder().executorService(service).extensionLoader((ExtensionLoader)loader).build());
        TestCase.assertEquals((String)(ExecutorService.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)service, (Object)domain.getConfiguration().getExecutorService());
        TestCase.assertEquals((String)(ExtensionLoader.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)loader, (Object)domain.getConfiguration().getExtensionLoader());
    }

    @Test
    public void createDomainWithExplicitConfigurationBuilder() {
        ExecutorService service = Executors.newSingleThreadExecutor();
        MockExtensionLoader loader = new MockExtensionLoader();
        Domain domain = ShrinkWrap.createDomain((ConfigurationBuilder)new ConfigurationBuilder().executorService(service).extensionLoader((ExtensionLoader)loader));
        TestCase.assertEquals((String)(ExecutorService.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)service, (Object)domain.getConfiguration().getExecutorService());
        TestCase.assertEquals((String)(ExtensionLoader.class.getSimpleName() + " specified was not contained in resultant " + Domain.class.getSimpleName()), (Object)loader, (Object)domain.getConfiguration().getExtensionLoader());
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDomainRequiresConfiguration() {
        ShrinkWrap.createDomain((Configuration)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void newDomainRequiresConfigurationBuilder() {
        ShrinkWrap.createDomain((ConfigurationBuilder)null);
    }

    @Test
    public void getDefaultDomain() {
        Domain domain1 = ShrinkWrap.getDefaultDomain();
        Domain domain2 = ShrinkWrap.getDefaultDomain();
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain1);
        TestCase.assertNotNull((String)"Domain should exist", (Object)domain2);
        TestCase.assertSame((String)"Obtaining the default domain should always return the same instance (idempotent operation)", (Object)domain1, (Object)domain2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockExtensionLoader
    implements ExtensionLoader {
        private MockExtensionLoader() {
        }

        public <T extends Assignable> T load(Class<T> extensionClass, Archive<?> baseArchive) {
            return null;
        }

        public <T extends Assignable> ExtensionLoader addOverride(Class<T> extensionClass, Class<? extends T> extensionImplClass) {
            return null;
        }
    }
}

