/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.After;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveTestBase<T extends Archive<T>> {
    public static final String NAME_TEST_PROPERTIES = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    public static final String NAME_TEST_PROPERTIES_2 = "org/jboss/shrinkwrap/impl/base/asset/Test2.properties";

    protected abstract T getArchive();

    protected abstract Archive<T> createNewArchive();

    @After
    public void ls() {
        T archive = this.getArchive();
        System.out.println("test@jboss:/$ ls -l " + archive.getName());
        System.out.println(archive.toString(true));
    }

    @Test
    public void testAddAssetToPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        Assert.assertTrue((String)("Asset should be placed on " + location.get()), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testAddRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Asset)null, (ArchivePath)new BasicPath("/", "Test.properties"));
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, location.get());
        Assert.assertTrue((String)("Asset should be placed on " + new BasicPath("/", "test.properties")), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testAddWithStringPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, (String)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddWithStringPathRequiresAssets() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Asset)null, "/Test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithName() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/");
        archive.add((Asset)asset, (ArchivePath)location, "test.properties");
        BasicPath expectedPath = new BasicPath("/", "test.properties");
        Assert.assertTrue((String)("Asset should be placed on " + expectedPath.get()), (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testAddAssetWithNameRequiresPath() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        try {
            archive.add((Asset)asset, null, "test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithNameRequiresName() throws Exception {
        T archive = this.getArchive();
        BasicPath path = new BasicPath("/", "Test.properties");
        String resource = NAME_TEST_PROPERTIES;
        try {
            archive.add((Asset)new ClassLoaderAsset(NAME_TEST_PROPERTIES), (ArchivePath)path, null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddAssetWithNameRequiresAsset() throws Exception {
        T archive = this.getArchive();
        String name = "test.properties";
        BasicPath path = new BasicPath("/", "Test.properties");
        try {
            archive.add(null, (ArchivePath)path, "test.properties");
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException expectedException) {
            // empty catch block
        }
    }

    @Test
    public void testAddEmptyDirectories() throws Exception {
        T archive = this.getArchive();
        ArchivePath path1 = ArchivePaths.create((String)"path/to/dir");
        ArchivePath path2 = ArchivePaths.create((String)"path/to/dir2");
        ArchivePath path3 = ArchivePaths.create((String)"path/to");
        archive.addDirectories(new ArchivePath[]{path1, path2, path3});
        String message = "Should be able to add directory: ";
        TestCase.assertTrue((String)("Should be able to add directory: " + path1), (boolean)archive.contains(path1));
        TestCase.assertTrue((String)("Should be able to add directory: " + path2), (boolean)archive.contains(path2));
        TestCase.assertTrue((String)("Should be able to add directory: " + path3), (boolean)archive.contains(path3));
    }

    @Test
    public void testDeleteAsset() throws Exception {
        T archive = this.getArchive();
        String resource = NAME_TEST_PROPERTIES;
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)new ClassLoaderAsset(resource), (ArchivePath)location);
        Assert.assertTrue((boolean)archive.contains((ArchivePath)location));
        Assert.assertTrue((String)"Successfully deleting an Asset should return true", (boolean)archive.delete((ArchivePath)location));
        Assert.assertFalse((String)("There should no longer be an asset at: " + location.get() + " after deleted"), (boolean)archive.contains((ArchivePath)location));
    }

    @Test
    public void testDeleteMissingAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        Assert.assertFalse((String)"Deleting a non-existent Asset should return false", (boolean)archive.delete((ArchivePath)location));
    }

    @Test
    public void testDeleteAssetRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.delete(null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAsset() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get((ArchivePath)location);
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()));
    }

    @Test
    public void testGetAssetRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAssetWithString() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        archive.add((Asset)asset, (ArchivePath)location);
        Node fetchedNode = archive.get(location.get());
        Assert.assertTrue((String)("Asset should be returned from path: " + location.get()), (boolean)this.compareAssets((Asset)asset, fetchedNode.getAsset()));
    }

    @Test
    public void testGetAssetWithStringRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.get((String)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testToGetContent() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent();
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assert.assertTrue((String)("Asset should existing in content with key: " + location.get()), (boolean)this.compareAssets((Asset)asset, node1.getAsset()));
        Assert.assertTrue((String)("Asset should existing in content with key: " + locationTwo.get()), (boolean)this.compareAssets((Asset)assetTwo, node2.getAsset()));
    }

    @Test
    public void testToGetContentFiltered() throws Exception {
        T archive = this.getArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        archive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        Map content = archive.getContent(Filters.include((String)".*test2.*"));
        Node node1 = (Node)content.get(location);
        Node node2 = (Node)content.get(locationTwo);
        Assert.assertEquals((String)"Only 1 Asset should have been included", (int)1, (int)content.size());
        Assert.assertNull((String)"Should not be included in content", (Object)node1);
        Assert.assertNotNull((String)"Should be included in content", (Object)node2);
    }

    @Test
    public void testAddArchiveToPathRequirePath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Archive)ShrinkWrap.create((String)"test.jar", JavaArchive.class), null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddArchiveToPathRequireArchive() throws Exception {
        T archive = this.getArchive();
        try {
            archive.add((Archive)null, (ArchivePath)new BasicPath("/"));
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expected=IllegalArchivePathException.class)
    public void shouldNotBeAbleToAddAssetOnIllegalPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/", "test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        ArchivePath locationTwo = ArchivePaths.create((String)"/test.properties/somewhere");
        archive.add((Asset)assetTwo, locationTwo);
    }

    @Test(expected=IllegalArchivePathException.class)
    public void shouldNotBeAbleToAddDirectoryOnIllegalPath() throws Exception {
        T archive = this.getArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath location = new BasicPath("/somewhere/test.properties");
        archive.add((Asset)asset, (ArchivePath)location);
        archive.addDirectory("/somewhere/test.properties/test");
    }

    @Test
    public void testMergeRequiresSource() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMerge() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive);
        Node node1 = archive.get((ArchivePath)location);
        Node node2 = archive.get((ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(node1.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + location.get()), (boolean)this.compareAssets(node2.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)location);
        BasicPath expectedPathTwo = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Node nodeOne = archive.get((ArchivePath)expectedPath);
        Node nodeTwo = archive.get((ArchivePath)expectedPathTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(nodeOne.getAsset(), (Asset)asset));
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPathTwo.getClass()), (boolean)this.compareAssets(nodeTwo.getAsset(), (Asset)assetTwo));
    }

    @Test
    public void testMergeToPathWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.merge(sourceArchive, (ArchivePath)baseLocation, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, (ArchivePath)locationTwo);
        Assert.assertTrue((String)("Asset should have been added to path: " + expectedPath.get()), (boolean)this.compareAssets(archive.get((ArchivePath)expectedPath).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeWithFilter() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath location = new BasicPath("/", "test.properties");
        BasicPath locationTwo = new BasicPath("/", "test2.properties");
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        ClassLoaderAsset assetTwo = new ClassLoaderAsset(NAME_TEST_PROPERTIES_2);
        sourceArchive.add((Asset)asset, (ArchivePath)location).add((Asset)assetTwo, (ArchivePath)locationTwo);
        archive.merge(sourceArchive, Filters.include((String)".*test2.*"));
        Assert.assertEquals((String)"Should only have merged 1", (int)1, (int)this.numAssets((Archive<?>)archive));
        Assert.assertTrue((String)("Asset should have been added to path: " + locationTwo.get()), (boolean)this.compareAssets(archive.get((ArchivePath)locationTwo).getAsset(), (Asset)asset));
    }

    @Test
    public void testMergeToPathRequiresPath() throws Exception {
        T archive = this.getArchive();
        try {
            archive.merge(this.createNewArchive(), (ArchivePath)null);
            Assert.fail((String)"Should have throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAddArchiveToPath() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation);
        BasicPath expectedPath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        Node node = archive.get((ArchivePath)expectedPath);
        Assert.assertNotNull((String)("Asset should have been added to path: " + expectedPath.get()), (Object)node);
        Assert.assertTrue((String)("An instance of ArchiveAsset should have been added to path: " + expectedPath.get()), (boolean)(node.getAsset() instanceof ArchiveAsset));
        ArchiveAsset archiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(node.getAsset());
        Archive nestedArchive = archiveAsset.getArchive();
        Assert.assertEquals((String)"Nested Archive should be same archive that was added", sourceArchive, (Object)nestedArchive);
    }

    @Test
    public void testNestedArchiveContains() throws Exception {
        T archive = this.getArchive();
        Archive<T> sourceArchive = this.createNewArchive();
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        sourceArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(sourceArchive, (ArchivePath)baseLocation);
        BasicPath archivePath = new BasicPath((ArchivePath)baseLocation, sourceArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)archivePath, "test.properties");
        Assert.assertTrue((String)"Nested archive assets should be verified through a fully qualified path", (boolean)archive.contains((ArchivePath)expectedPath));
    }

    @Test
    public void testNestedArchiveGet() throws Exception {
        T archive = this.getArchive();
        Archive<T> nestedArchive = this.createNewArchive();
        BasicPath baseLocation = new BasicPath("somewhere");
        archive.add(nestedArchive, (ArchivePath)baseLocation);
        Archive<T> nestedNestedArchive = this.createNewArchive();
        nestedArchive.add(nestedNestedArchive, (ArchivePath)new BasicPath("/"));
        ClassLoaderAsset asset = new ClassLoaderAsset(NAME_TEST_PROPERTIES);
        BasicPath nestedAssetPath = new BasicPath("/", "test.properties");
        nestedNestedArchive.add((Asset)asset, (ArchivePath)nestedAssetPath);
        BasicPath nestedArchivePath = new BasicPath((ArchivePath)baseLocation, nestedArchive.getName());
        BasicPath nestedNestedArchivePath = new BasicPath((ArchivePath)nestedArchivePath, nestedNestedArchive.getName());
        BasicPath expectedPath = new BasicPath((ArchivePath)nestedNestedArchivePath, "test.properties");
        Node nestedNode = archive.get((ArchivePath)expectedPath);
        Assert.assertNotNull((String)("Nested archive asset should be available through partent archive at " + expectedPath.get()), (Object)nestedNode.getAsset());
    }

    private boolean compareAssets(Asset one, Asset two) throws IllegalArgumentException {
        Validate.notNull((Object)one, (String)"Asset one must be specified");
        Validate.notNull((Object)two, (String)"Asset two must be specified");
        byte[] oneData = IOUtil.asByteArray((InputStream)one.openStream());
        byte[] twoData = IOUtil.asByteArray((InputStream)two.openStream());
        return Arrays.equals(oneData, twoData);
    }

    protected int numAssets(Archive<?> archive) {
        Validate.notNull(archive, (String)"Archive must be specified");
        int assets = 0;
        Map content = archive.getContent();
        for (Map.Entry entry : content.entrySet()) {
            if (((Node)entry.getValue()).getAsset() == null) continue;
            ++assets;
        }
        return assets;
    }
}

