/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.Domain;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.api.exporter.FileExistsException;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.importer.StreamImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.exporter.ExportTestBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StreamExporterTestBase<T extends StreamImporter<T>>
extends ExportTestBase {
    private static final Logger log = Logger.getLogger(StreamExporterTestBase.class.getName());

    protected abstract void ensureInExpectedForm(File var1) throws IOException;

    protected abstract InputStream getContentsFromExportedFile(File var1, ArchivePath var2) throws IOException;

    protected abstract Class<T> getImporterClass();

    @Test
    public void testExport() throws Exception {
        log.info("testExport");
        Archive<?> archive = this.createArchiveWithAssets();
        InputStream exportStream = this.exportAsInputStream(archive);
        File tempDirectory = this.createTempDirectory("testExport");
        File serialized = new File(tempDirectory, archive.getName());
        FileOutputStream out = new FileOutputStream(serialized);
        IOUtil.copyWithClose((InputStream)exportStream, (OutputStream)out);
        this.ensureInExpectedForm(serialized);
    }

    @Test
    public void exportUsesOurExecutorService() throws Exception {
        CountingExecutorService service = new CountingExecutorService();
        Domain domain = ShrinkWrap.createDomain((Configuration)new ConfigurationBuilder().executorService((ExecutorService)service).build());
        Archive archive = ((JavaArchive)domain.getArchiveFactory().create(JavaArchive.class, "test.jar")).addClass(StreamExporterTestBase.class);
        InputStream content = this.exportAsInputStream(archive);
        OutputStream sink = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        IOUtil.copyWithClose((InputStream)content, (OutputStream)sink);
        Assert.assertEquals((String)("Custom " + ExecutorService.class.getSimpleName() + " was not used by export process"), (long)1L, (long)service.counter);
        Assert.assertFalse((String)("Export should not shut down a user-supplied " + ExecutorService.class.getName()), (boolean)service.isShutdown());
        service.shutdown();
    }

    @Test
    public void testExportArchiveWithOnlyDirectories() throws IOException {
        ArchivePath path = ArchivePaths.create((String)"/test/game");
        Archive archive = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"testArchive")).addAsDirectories(new ArchivePath[]{path});
        InputStream content = this.exportAsInputStream(archive);
        ByteArrayOutputStream exportedContents = new ByteArrayOutputStream();
        IOUtil.copyWithClose((InputStream)content, (OutputStream)exportedContents);
        GenericArchive roundtrip = (GenericArchive)((StreamImporter)ShrinkWrap.create(this.getImporterClass(), (String)"roundtrip.zip")).importFrom((InputStream)new ByteArrayInputStream(exportedContents.toByteArray())).as(GenericArchive.class);
        log.info(roundtrip.toString(true));
        Assert.assertTrue((boolean)roundtrip.contains(path));
    }

    @Test
    public void testExportToFile() throws IOException {
        log.info("testExportToFile");
        File tempDirectory = this.createTempDirectory("testExportToFile");
        Archive<?> archive = this.createArchiveWithAssets();
        File exported = new File(tempDirectory, archive.getName());
        this.exportAsFile(archive, exported, true);
        this.ensureInExpectedForm(exported);
    }

    @Test
    public void testExportToDirectoryFails() throws IOException {
        log.info("testExportToDirectoryFails");
        File tempDirectory = this.createTempDirectory("testExportToFile");
        Archive<?> archive = this.createArchiveWithAssets();
        try {
            this.exportAsFile(archive, tempDirectory, true);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        Assert.fail((String)("Should have encountered " + IllegalArgumentException.class.getSimpleName() + " exporting to a dir"));
    }

    @Test
    public void testExportToOutStream() throws IOException {
        log.info("testExportToOutStream");
        File tempDirectory = this.createTempDirectory("testExportToOutStream");
        Archive<?> archive = this.createArchiveWithAssets();
        File serializedArchive = new File(tempDirectory, archive.getName());
        FileOutputStream out = new FileOutputStream(serializedArchive);
        this.exportToOutputStream(archive, out);
        this.ensureInExpectedForm(serializedArchive);
    }

    @Test
    public void testExportToExistingFileFails() throws IOException {
        log.info("testExportToExistingFileFails");
        File tempDirectory = this.createTempDirectory("testExportToExistingFileFails");
        Archive<?> archive = this.createArchiveWithAssets();
        File alreadyExists = new File(tempDirectory, archive.getName());
        FileOutputStream alreadyExistsOutputStream = new FileOutputStream(alreadyExists);
        ((OutputStream)alreadyExistsOutputStream).write(new byte[0]);
        ((OutputStream)alreadyExistsOutputStream).close();
        Assert.assertTrue((String)"The test setup is incorrect; an empty file should exist before writing the archive", (boolean)alreadyExists.exists());
        boolean gotExpectedException = false;
        try {
            this.exportAsFile(archive, alreadyExists, false);
        }
        catch (FileExistsException fee) {
            gotExpectedException = true;
        }
        Assert.assertTrue((String)("Should get " + FileExistsException.class.getSimpleName() + " when exporting to an existing file when overwrite is false"), (boolean)gotExpectedException);
    }

    @Test
    public void testExportNested() throws Exception {
        log.info("testExportNested");
        File tempDirectory = this.createTempDirectory("testExportNested");
        Archive<?> archive = this.createArchiveWithNestedArchives();
        InputStream exportStream = this.exportAsInputStream(archive);
        File exported = new File(tempDirectory, "testArchive" + this.getArchiveExtension());
        FileOutputStream exportedOut = new FileOutputStream(exported);
        IOUtil.copyWithClose((InputStream)exportStream, (OutputStream)exportedOut);
        this.ensureAssetInExportedFile(exported, PATH_ONE, ASSET_ONE);
        this.ensureAssetInExportedFile(exported, PATH_TWO, ASSET_TWO);
        ArchivePath nestedArchivePath = ArchivePaths.create((String)("nestedArchive" + this.getArchiveExtension()));
        InputStream nestedArchiveStream = this.getContentsFromExportedFile(exported, nestedArchivePath);
        File nestedFile = new File(tempDirectory, "nestedArchive" + this.getArchiveExtension());
        FileOutputStream nestedOut = new FileOutputStream(nestedFile);
        IOUtil.copyWithClose((InputStream)nestedArchiveStream, (OutputStream)nestedOut);
        this.ensureAssetInExportedFile(nestedFile, PATH_ONE, ASSET_ONE);
        this.ensureAssetInExportedFile(nestedFile, PATH_TWO, ASSET_TWO);
        ArchivePath nestedArchiveTwoPath = ArchivePaths.create((ArchivePath)NESTED_PATH, (String)("nestedArchive2" + this.getArchiveExtension()));
        this.getContentsFromExportedFile(exported, nestedArchiveTwoPath);
        InputStream nestedArchiveTwoStream = this.getContentsFromExportedFile(exported, nestedArchiveTwoPath);
        File nestedTwoFile = new File(tempDirectory, "nestedArchive2" + this.getArchiveExtension());
        FileOutputStream nestedTwoOut = new FileOutputStream(nestedTwoFile);
        IOUtil.copyWithClose((InputStream)nestedArchiveTwoStream, (OutputStream)nestedTwoOut);
        this.ensureAssetInExportedFile(nestedTwoFile, PATH_ONE, ASSET_ONE);
        this.ensureAssetInExportedFile(nestedTwoFile, PATH_TWO, ASSET_TWO);
    }

    @Test(expected=ArchiveExportException.class)
    public void testExportThrowsArchiveExceptionOnAssetWriteFailure() throws IOException {
        log.info("testExportThrowsArchiveExceptionOnAssetWriteFailure");
        Archive<?> archive = this.createArchiveWithAssets();
        if (archive.contains(PATH_ONE)) {
            archive.delete(PATH_ONE);
        }
        archive.add(new Asset(){

            public InputStream openStream() {
                throw new RuntimeException("Mock Exception from an Asset write");
            }
        }, PATH_ONE);
        InputStream in = this.exportAsInputStream(archive);
        OutputStream sink = new OutputStream(){

            public void write(int b) throws IOException {
            }
        };
        IOUtil.copyWithClose((InputStream)in, (OutputStream)sink);
    }

    private InputStream exportAsInputStream(Archive<?> archive) {
        assert (archive != null) : "archive must be specified";
        Class<? extends StreamExporter> exporter = this.getExporterClass();
        assert (exporter != null) : "Exporter class must be specified";
        return ((StreamExporter)archive.as(this.getExporterClass())).exportAsInputStream();
    }

    private void exportAsFile(Archive<?> archive, File file, boolean overwrite) {
        assert (file != null) : "file must be specified";
        assert (archive != null) : "archive must be specified";
        Class<? extends StreamExporter> exporter = this.getExporterClass();
        assert (exporter != null) : "Exporter class must be specified";
        ((StreamExporter)archive.as(exporter)).exportTo(file, overwrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToOutputStream(Archive<?> archive, OutputStream out) {
        assert (archive != null) : "archive must be specified";
        assert (out != null) : "outstream must be specified";
        Class<? extends StreamExporter> exporter = this.getExporterClass();
        assert (exporter != null) : "Exporter class must be specified";
        try {
            ((StreamExporter)archive.as(exporter)).exportTo(out);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioe) {
                log.warning("Could not close " + out + ": " + ioe);
            }
        }
    }

    protected final void ensureAssetInExportedFile(File file, ArchivePath path, Asset asset) throws IOException {
        assert (file != null) : "file must be specified";
        assert (path != null) : "path must be specified";
        assert (asset != null) : "asset must be specified";
        InputStream actualStream = this.getContentsFromExportedFile(file, path);
        assert (actualStream != null) : "No contents found at path " + path + " in " + file.getAbsolutePath();
        byte[] actualContents = IOUtil.asByteArray((InputStream)actualStream);
        byte[] expectedContents = IOUtil.asByteArray((InputStream)asset.openStream());
        Assert.assertArrayEquals((byte[])expectedContents, (byte[])actualContents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CountingExecutorService
    implements ExecutorService {
        private final ExecutorService delegate = Executors.newSingleThreadExecutor();
        int counter = 0;

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.awaitTermination(timeout, unit);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.delegate.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.delegate.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.invokeAny(tasks, timeout, unit);
        }

        @Override
        public boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            ++this.counter;
            return this.delegate.submit(task);
        }

        @Override
        public Future<?> submit(Runnable task) {
            ++this.counter;
            return this.delegate.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            ++this.counter;
            return this.delegate.submit(task, result);
        }

        @Override
        public void execute(Runnable command) {
            ++this.counter;
            this.delegate.execute(command);
        }
    }
}

