/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerTestRunner
extends BlockJUnit4ClassRunner {
    public ContainerTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected List<FrameworkMethod> computeTestMethods() {
        return new FilterSupportedArchiveTypes(this.getTestClass(), super.computeTestMethods()).filter();
    }

    private boolean supportsArchiveType(Class<?> archiveType, Class<?> testCaseArchiveType) {
        Class<?>[] supportedInterfaces;
        for (Class<?> supportedInterface : supportedInterfaces = testCaseArchiveType.getInterfaces()) {
            if (!archiveType.isAssignableFrom(supportedInterface)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilterSupportedArchiveTypes {
        private List<FrameworkMethod> frameworkMethods;
        private TestClass testClass;

        public FilterSupportedArchiveTypes(TestClass testClass, List<FrameworkMethod> frameworkMethods) {
            this.testClass = testClass;
            this.frameworkMethods = frameworkMethods;
        }

        public List<FrameworkMethod> filter() {
            ArchiveType archiveUnderTest = this.testClass.getJavaClass().getAnnotation(ArchiveType.class);
            if (archiveUnderTest == null) {
                throw new RuntimeException("TestClass[" + this.testClass.getJavaClass().getName() + "] is missing " + ArchiveType.class.getName() + " annotation. " + "This describes the Type being tested.");
            }
            ArrayList<FrameworkMethod> testMethods = new ArrayList<FrameworkMethod>();
            for (FrameworkMethod testMethod : this.frameworkMethods) {
                ArchiveType archiveType = (ArchiveType)testMethod.getAnnotation(ArchiveType.class);
                if (archiveType != null) {
                    if (!ContainerTestRunner.this.supportsArchiveType(archiveType.value(), archiveUnderTest.value())) continue;
                    testMethods.add(testMethod);
                    continue;
                }
                testMethods.add(testMethod);
            }
            return testMethods;
        }
    }
}

