/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.serialization.SerializableView;
import org.jboss.shrinkwrap.api.serialization.ZipSerializableView;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.serialization.ZipSerializableOriginalImpl;
import org.jboss.shrinkwrap.impl.base.serialization.ZipSerializableViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationTestCase {
    private static final Logger log = Logger.getLogger(SerializationTestCase.class.getName());
    private static final String NAME_PAYLOAD_ARCHIVE = "serializedArchive.jar";
    private JavaArchive payload;

    @Before
    public void createPayload() {
        this.payload = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)NAME_PAYLOAD_ARCHIVE)).addClasses(new Class[]{SerializationTestCase.class, JavaArchive.class});
    }

    @Test
    public void zipSerializableView() throws Exception {
        this.testSerializableView(ZipSerializableView.class);
    }

    @Test
    public void serializableView() throws Exception {
        this.testSerializableView(SerializableView.class);
    }

    private <S extends SerializableView> void testSerializableView(Class<S> serializableView) throws Exception {
        log.info("Before: " + this.payload.toString(true));
        JavaArchive roundtrip = (JavaArchive)SerializationTestCase.serializeAndDeserialize((SerializableView)this.payload.as(serializableView)).as(JavaArchive.class);
        log.info("After: " + roundtrip.toString(true));
        Map originalContents = this.payload.getContent();
        Map roundtripContents = roundtrip.getContent();
        Assert.assertEquals((String)"Contents after serialization were not as expected", (Object)originalContents, (Object)roundtripContents);
        Assert.assertEquals((String)"Name of original archive was not as expected", (Object)NAME_PAYLOAD_ARCHIVE, (Object)this.payload.getName());
        Assert.assertEquals((String)"Name not as expected after serialization", (Object)this.payload.getName(), (Object)roundtrip.getName());
    }

    @Test
    public void zipWireProtocolCurrentToOriginal() throws Exception {
        SerializableView currentWireFormat = (SerializableView)this.payload.as(SerializableView.class);
        this.testWireProtocol(currentWireFormat, ZipSerializableOriginalImpl.class);
    }

    @Test
    public void zipWireProtocolOriginalToCurrent() throws Exception {
        ZipSerializableOriginalImpl originalWireFormat = new ZipSerializableOriginalImpl((Archive<?>)this.payload);
        this.testWireProtocol((SerializableView)originalWireFormat, ZipSerializableViewImpl.class);
    }

    private void testWireProtocol(SerializableView clientObject, Class<? extends SerializableView> targetType) throws IOException {
        SerializableView roundtrip = SerializationTestCase.serializeAndDeserialize(clientObject, targetType);
        TestCase.assertEquals(targetType, roundtrip.getClass());
    }

    private static SerializableView serializeAndDeserialize(SerializableView archive) throws IOException, ClassNotFoundException {
        assert (archive != null) : "Archive must be specified";
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(archive);
        out.flush();
        out.close();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        SerializableView roundtrip = (SerializableView)in.readObject();
        in.close();
        return roundtrip;
    }

    private static <S extends SerializableView> S serializeAndDeserialize(SerializableView archive, Class<S> targetType) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        SpoofingObjectOutputStream oout = new SpoofingObjectOutputStream(bout, archive.getClass(), targetType);
        oout.writeObject(archive);
        oout.flush();
        oout.close();
        ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream oin = new ObjectInputStream(bin);
        try {
            Object obj = oin.readObject();
            oin.close();
            log.info("Original type " + archive.getClass().getName() + " now represented as " + obj.getClass().getName());
            return (S)((SerializableView)targetType.cast(obj));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SpoofingObjectOutputStream
    extends ObjectOutputStream {
        String oldName;
        String newName;

        public SpoofingObjectOutputStream(OutputStream out, Class<?> oldClass, Class<?> newClass) throws IOException {
            super(out);
            this.oldName = oldClass.getName();
            this.newName = newClass.getName();
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass descriptor) throws IOException {
            Class<?> clazz = descriptor.forClass();
            boolean externalizable = Externalizable.class.isAssignableFrom(clazz);
            boolean serializable = Serializable.class.isAssignableFrom(clazz);
            boolean hasWriteObjectData = this.hasWriteObjectMethod(clazz);
            boolean isEnum = Enum.class.isAssignableFrom(clazz);
            this.writeUTF(this.replace(descriptor.getName()));
            this.writeLong(descriptor.getSerialVersionUID());
            int flags = 0;
            if (externalizable) {
                flags = (byte)(flags | 4);
                flags = (byte)(flags | 8);
            } else if (serializable) {
                flags = (byte)(flags | 2);
            }
            if (hasWriteObjectData) {
                flags = (byte)(flags | 1);
            }
            if (isEnum) {
                flags = (byte)(flags | 0x10);
            }
            this.writeByte(flags);
            ObjectStreamField[] fields = descriptor.getFields();
            this.writeShort(fields.length);
            for (ObjectStreamField field : fields) {
                this.writeByte(field.getTypeCode());
                this.writeUTF(field.getName());
                if (field.isPrimitive()) continue;
                this.writeObject(this.replace(field.getTypeString()));
            }
        }

        String replace(String className) {
            if (className.equals(this.newName)) {
                throw new RuntimeException("Found instance of " + className + "." + " Expected instance of " + this.oldName + ".");
            }
            return className == this.oldName ? this.newName : className;
        }

        boolean hasWriteObjectMethod(Class<?> clazz) {
            try {
                Method method = clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class);
                int modifiers = method.getModifiers();
                return method.getReturnType() == Void.TYPE && !Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
    }
}

