/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ArchiveExportException;
import org.jboss.shrinkwrap.api.exporter.FileExistsException;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStreamExporterImpl
extends AssignableBase<Archive<?>>
implements StreamExporter {
    private static final Logger log = Logger.getLogger(AbstractStreamExporterImpl.class.getName());

    public AbstractStreamExporterImpl(Archive<?> archive) {
        super(archive);
    }

    protected final OutputStream getOutputStreamToFile(File target, boolean overwrite) throws FileExistsException, IllegalArgumentException {
        FileOutputStream out;
        if (target == null) {
            throw new IllegalArgumentException("Target file must be specified");
        }
        if (target.isDirectory()) {
            throw new IllegalArgumentException("Cannot export a stream file to existing directory: " + target.getAbsolutePath());
        }
        if (target.exists() && !overwrite) {
            throw new FileExistsException("Target exists and we haven't been flagged to overwrite it: " + target.getAbsolutePath());
        }
        try {
            out = new FileOutputStream(target);
        }
        catch (FileNotFoundException e) {
            throw new ArchiveExportException("File could not be created: " + target);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTo(OutputStream target) throws ArchiveExportException, IllegalArgumentException {
        if (target == null) {
            throw new IllegalArgumentException("Target must be specified");
        }
        InputStream in = this.exportAsInputStream();
        try {
            try {
                IOUtil.copy(in, target);
            }
            catch (IOException e) {
                throw new ArchiveExportException("Error encountered in exporting archive to " + target, (Throwable)e);
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {
                log.warning("Could not close " + in + ": " + ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportTo(File target, boolean overwrite) throws ArchiveExportException, FileExistsException, IllegalArgumentException {
        OutputStream out = this.getOutputStreamToFile(target, overwrite);
        try {
            this.exportTo(out);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ioe) {
                log.warning("Could not close " + out + ": " + ioe);
            }
        }
    }

    public final void exportTo(File target) throws ArchiveExportException, FileExistsException, IllegalArgumentException {
        this.exportTo(target, false);
    }
}

