/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.importer.SecurityActions;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ExplodedImporterTestCase {
    private static final String EXISTING_DIRECTORY_RESOURCE = "exploded_import_test";
    private static final String EXISTING_FILE_RESOURCE = "exploded_import_test/Test.properties";
    private static final String EMPTY_DIR_NAME = "empty_dir";
    private static final String PARENT_DIR_NAME = "parent";

    @BeforeClass
    public static void makeEmptyDirectories() throws IOException, URISyntaxException {
        File root = new File(ExplodedImporterTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        File exlodedImportTest = new File(root, EXISTING_DIRECTORY_RESOURCE);
        Assert.assertTrue((String)("Import test folder does not exist: " + exlodedImportTest.getAbsolutePath()), (boolean)exlodedImportTest.exists());
        File empty = new File(exlodedImportTest, EMPTY_DIR_NAME);
        Assert.assertTrue((String)"Could not create the empty directory", (boolean)empty.mkdir());
        File parent = new File(exlodedImportTest, PARENT_DIR_NAME);
        File parentEmpty = new File(parent, EMPTY_DIR_NAME);
        Assert.assertTrue((String)"Could not create the parent empty directory", (boolean)parentEmpty.mkdirs());
        parentEmpty.deleteOnExit();
        empty.deleteOnExit();
    }

    @Test
    public void shouldBeAbleToImportADriectory() throws Exception {
        Archive archive = (Archive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"test.jar")).importDirectory(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_DIRECTORY_RESOURCE).toURI().getPath()).as(JavaArchive.class);
        Logger.getLogger(ExplodedImporterTestCase.class.getName()).info(archive.toString(true));
        Assert.assertTrue((String)"Root files should be imported", (boolean)archive.contains((ArchivePath)new BasicPath("/Test.properties")));
        Assert.assertTrue((String)"Nested files should be imported", (boolean)archive.contains((ArchivePath)new BasicPath("/META-INF/MANIFEST.FM")));
        Assert.assertTrue((String)"Nested files should be imported", (boolean)archive.contains((ArchivePath)new BasicPath("/org/jboss/Test.properties")));
        Assert.assertTrue((String)"Empty directories should be imported", (boolean)archive.contains((ArchivePath)new BasicPath("/empty_dir")));
        Assert.assertTrue((String)"Nested empty directories should be imported", (boolean)archive.contains((ArchivePath)new BasicPath("/parent/empty_dir")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfImportingAFile() throws Exception {
        ((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"test.jar")).importDirectory(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_FILE_RESOURCE).toURI().getPath());
    }
}

