/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.IllegalOverwriteException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.container.ServiceProviderContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.TestIOUtil;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassA;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassParent;
import org.jboss.shrinkwrap.impl.base.test.ArchiveTestBase;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestRunner;
import org.jboss.shrinkwrap.impl.base.test.SecurityActions;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyClassForTest;
import org.jboss.shrinkwrap.impl.base.test.dummy.DummyInterfaceForTest;
import org.jboss.shrinkwrap.impl.base.test.dummy.nested1.EmptyClassForFiltersTest1;
import org.jboss.shrinkwrap.impl.base.test.dummy.nested2.EmptyClassForFiltersTest2;
import org.jboss.shrinkwrap.impl.base.test.dummy.nested3.EmptyClassForFiltersTest3;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=ContainerTestRunner.class)
public abstract class DynamicContainerTestBase<T extends Archive<T>>
extends ArchiveTestBase<T> {
    public static String MANIFEST_FILE = "MANIFEST.MF";

    protected abstract ArchivePath getResourcePath();

    protected abstract ResourceContainer<T> getResourceContainer();

    protected abstract ArchivePath getClassPath();

    protected abstract ClassContainer<T> getClassContainer();

    protected abstract ArchivePath getManifestPath();

    protected abstract ManifestContainer<T> getManifestContainer();

    protected abstract ServiceProviderContainer<T> getServiceProviderContainer();

    protected abstract ArchivePath getLibraryPath();

    protected abstract LibraryContainer<T> getLibraryContainer();

    protected URL getURLForClassResource(String name) {
        return SecurityActions.getThreadContextClassLoader().getResource(name);
    }

    protected File getFileForClassResource(String name) throws Exception {
        return new File(this.getURLForClassResource(name).toURI());
    }

    protected Asset getAssetForClassResource(String name) {
        return new ClassLoaderAsset(name);
    }

    @Before
    public void createEmptyDirectory() throws Exception {
        File emptyDir = this.createDirectory("org/jboss/shrinkwrap/impl/base/recursion/empty");
        junit.framework.Assert.assertTrue((String)("Empty directory not found at " + emptyDir.getAbsolutePath()), (boolean)emptyDir.exists());
        junit.framework.Assert.assertEquals((String)"Directory not empty", (int)emptyDir.list().length, (int)0);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestResource() throws Exception {
        this.getManifestContainer().setManifest("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestResourceInPackage() throws Exception {
        this.getManifestContainer().setManifest(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestFile() throws Exception {
        this.getManifestContainer().setManifest(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestURL() throws Exception {
        this.getManifestContainer().setManifest(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestAsset() throws Exception {
        this.getManifestContainer().setManifest(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), MANIFEST_FILE);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResource() throws Exception {
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test(expected=IllegalArgumentException.class)
    @ArchiveType(value=ManifestContainer.class)
    public void testAddNonExistentManifestResource() throws Exception {
        String nonExistentResourceName = "ejb/security/ejb-jar.xml";
        this.getManifestContainer().addAsManifestResource("ejb/security/ejb-jar.xml");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResourceRecursively() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolder), this.getManifestPath(), baseFolder);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFile() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResourceRecursivelyWithTarget() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource(baseFolder, baseFolder);
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolder), this.getManifestPath(), baseFolder);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testArchiveContainsEmptyManifestResourceDirectory() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource(baseFolder);
        String emptyFolderPath = baseFolder + "/empty";
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(emptyFolderPath), this.getManifestPath(), emptyFolderPath);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFileRecursively() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getManifestContainer().addAsManifestResource(baseFolder);
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getManifestPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFileRecursivelyWithTarget() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getManifestContainer().addAsManifestResource(baseFolder, "/new-name");
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFileRecursivelyWithArchivePath() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getManifestContainer().addAsManifestResource(baseFolder, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResourceRecursivelyWithTargetArchivePath() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getManifestContainer().addAsManifestResource(baseFolderPath, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getManifestContainer().addAsManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getManifestPath(), (ArchivePath)targetPath);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestURLRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        URL baseFolderURL = this.getURLForClassResource(baseFolderPath);
        this.getManifestContainer().addAsManifestResource(baseFolderURL, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getManifestPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetResource() throws Exception {
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetFile() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetURL() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetAsset() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetResource() throws Exception {
        this.getManifestContainer().addAsManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetFile() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetURL() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetAsset() throws Exception {
        this.getManifestContainer().addAsManifestResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProvider() throws Exception {
        this.getManifestContainer().addAsServiceProvider(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        BasicPath testPath = new BasicPath(this.getManifestPath(), "services/" + DummyInterfaceForTest.class.getName());
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderString() throws Exception {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        String serviceInterface = "do.not.exist.api.Dummy";
        this.getManifestContainer().addAsServiceProvider(serviceInterface, impls);
        BasicPath testPath = new BasicPath(this.getManifestPath(), "services/" + serviceInterface);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        this.assertServiceProviderContent(this.getArchive().get((ArchivePath)testPath), impls);
    }

    @Test(expected=IllegalArgumentException.class)
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderStringInterfaceValidation() throws Exception {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", "do.not.exist.impl.Dummy2", "do.not.exist.impl.Dummy3"};
        this.getManifestContainer().addAsServiceProvider(null, impls);
    }

    @Test(expected=IllegalArgumentException.class)
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderStringImplementationsValidation() throws Exception {
        this.getManifestContainer().addAsServiceProvider("do.not.exist.impl.Dummy1", (String[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    @ArchiveType(value=ManifestContainer.class)
    public void testAddServiceProviderStringImplementationsValueValidation() throws Exception {
        String[] impls = new String[]{"do.not.exist.impl.Dummy1", null};
        this.getManifestContainer().addAsServiceProvider("do.not.exist.impl.Dummy", impls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertServiceProviderContent(Node node, String[] impls) throws IOException {
        BufferedReader reader = this.createReader(node.getAsset());
        try {
            for (String impl : impls) {
                junit.framework.Assert.assertEquals((String)("Wrong entry in service provider: " + impl), (String)impl, (String)reader.readLine());
            }
        }
        finally {
            reader.close();
        }
    }

    private BufferedReader createReader(Asset asset) {
        InputStream openStream = asset.openStream();
        return new BufferedReader(new InputStreamReader(openStream));
    }

    @Test
    @ArchiveType(value=ServiceProviderContainer.class)
    public void testAddServiceProviderWithClasses() throws Exception {
        Class[] expectedResources;
        this.getServiceProviderContainer().addAsServiceProviderAndClasses(DummyInterfaceForTest.class, new Class[]{DummyClassForTest.class});
        BasicPath testPath = new BasicPath(this.getManifestPath(), "services/" + DummyInterfaceForTest.class.getName());
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        for (Class expectedResource : expectedResources = new Class[]{DummyInterfaceForTest.class, DummyClassForTest.class}) {
            BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((Class)expectedResource));
            this.assertContainsClass((ArchivePath)expectedClassPath);
        }
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackage() throws Exception {
        this.getManifestContainer().addAsManifestResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackages() throws Exception {
        this.getManifestContainer().addAsManifestResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackageStringTarget() throws Exception {
        this.getManifestContainer().addAsManifestResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPackagePathTarget() throws Exception {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getManifestContainer().addAsManifestResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getManifestPath(), targetPath);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceResource() throws Exception {
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFile() throws Exception {
        this.getResourceContainer().addAsResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFileRecusively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        File baseFolder = this.getFileForClassResource(baseFolderPath);
        this.getResourceContainer().addAsResource(baseFolder);
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getResourcePath(), "/recursion");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFileRecusivelyWithTarget() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getResourceContainer().addAsResource(baseFolder, "/new-name");
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceRecusively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolderPath);
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), baseFolderPath);
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceRecusivelyWithTarget() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolderPath, "/new-name");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceRecusivelyWithTargetPath() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolderPath, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getResourceContainer().addAsResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getResourcePath(), (ArchivePath)targetPath);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetResourceFromJar() throws Exception {
        this.getManifestContainer().addAsManifestResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "String.class");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResourceFromJar() throws Exception {
        this.getResourceContainer().addAsResource("java/lang/String.class", "String.class");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "String.class");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        Logger.getAnonymousLogger().info(this.getArchive().toString(true));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResource() throws Exception {
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResourceOverride() throws Exception {
        BasicPath targetPath = new BasicPath("META-INF/Test.txt");
        BasicPath targetPath2 = new BasicPath("META-INF");
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)targetPath);
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)targetPath2);
        BasicPath testPath = new BasicPath(this.getResourcePath(), "META-INF/Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetFile() throws Exception {
        this.getResourceContainer().addAsResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetURL() throws Exception {
        this.getResourceContainer().addAsResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceUrlWithTargetStringRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        URL baseFolderUrl = this.getURLForClassResource(baseFolderPath);
        this.getResourceContainer().addAsResource(baseFolderUrl, "/new-name");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceUrlWithTargetArchviePathRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        URL baseFolderUrl = this.getURLForClassResource(baseFolderPath);
        this.getResourceContainer().addAsResource(baseFolderUrl, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getResourcePath(), "/new-name");
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testArchiveContainsEmptyResourceDirectory() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getResourceContainer().addAsResource(baseFolder);
        String emptyFolderPath = baseFolder + "/empty";
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(emptyFolderPath), this.getResourcePath(), emptyFolderPath);
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetAsset() throws Exception {
        this.getResourceContainer().addAsResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetResource() throws Exception {
        this.getResourceContainer().addAsResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetFile() throws Exception {
        this.getResourceContainer().addAsResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetURL() throws Exception {
        this.getResourceContainer().addAsResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetAsset() throws Exception {
        this.getResourceContainer().addAsResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackage() throws Exception {
        this.getResourceContainer().addAsResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackages() throws Exception {
        this.getResourceContainer().addAsResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackageStringTarget() throws Exception {
        this.getResourceContainer().addAsResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePackagePathTarget() throws Exception {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getResourceContainer().addAsResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getResourcePath(), targetPath);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClass() throws Exception {
        this.getClassContainer().addClass(DummyClassA.class);
        this.ensureClassesAdded();
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClasses() throws Exception {
        this.getClassContainer().addClasses(new Class[]{DummyClassA.class});
        this.ensureClassesAdded();
    }

    private void ensureClassesAdded() {
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
        BasicPath expectedPathInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class));
        BasicPath expectedPathInnerClassParent = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassParent.ParentInnerClass.class));
        junit.framework.Assert.assertTrue((String)"Adding a class should also add its inner classes", (boolean)this.getArchive().contains((ArchivePath)expectedPathInnerClass));
        junit.framework.Assert.assertFalse((String)"Adding a class should not add the public inner classes of its parent", (boolean)this.getArchive().contains((ArchivePath)expectedPathInnerClassParent));
        BasicPath expectedPathPrivateInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class).get().replaceAll("InnerClass", "Test"));
        BasicPath expectedPathAnonymousInnerClass = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.InnerClass.class).get().replaceAll("InnerClass", "1"));
        junit.framework.Assert.assertTrue((String)"Adding a class should also add its private inner classes", (boolean)this.getArchive().contains((ArchivePath)expectedPathPrivateInnerClass));
        junit.framework.Assert.assertTrue((String)"Adding a class should also add the anonymous inner classes", (boolean)this.getArchive().contains((ArchivePath)expectedPathAnonymousInnerClass));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesByFqn() throws Exception {
        Class<DummyClassA> classToAdd = DummyClassA.class;
        this.getClassContainer().addClass(classToAdd.getName());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(classToAdd));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesByFqnAndTccl() throws Exception {
        Class<DummyClassA> classToAdd = DummyClassA.class;
        this.getClassContainer().addClass(classToAdd.getName(), classToAdd.getClassLoader());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(classToAdd));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassByFqnAndClassLoader() throws Exception {
        ClassLoader emptyClassLoader = new ClassLoader(null){};
        ClassLoader originalClassLoader = SecurityActions.getThreadContextClassLoader();
        ClassLoaderTester classCl = new ClassLoaderTester("cl-test.jar");
        try {
            Thread.currentThread().setContextClassLoader(emptyClassLoader);
            this.getClassContainer().addClass("test.classloader.DummyClass", (ClassLoader)classCl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        junit.framework.Assert.assertTrue((String)"Classloader not used to load inner class", (boolean)classCl.isUsedForInnerClasses());
        BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((String)"/test/classloader/DummyClass"));
        this.assertContainsClass((ArchivePath)expectedClassPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassFromBootstrapCl() throws Exception {
        ClassContainer<T> archive = this.getClassContainer();
        archive.addClass(String.class);
        ArchivePath classRoot = this.getClassPath();
        junit.framework.Assert.assertTrue((String)"Archive does not contain class added from bootstrap CL", (boolean)((Archive)archive).contains(ArchivePaths.create((ArchivePath)classRoot, (String)"/java/lang/String.class")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassFromCustomClassloader() throws Exception {
        ClassLoader emptyClassLoader = new ClassLoader(null){};
        ClassLoader originalClassLoader = SecurityActions.getThreadContextClassLoader();
        ClassLoaderTester myClassLoader = new ClassLoaderTester("cl-test.jar");
        try {
            Thread.currentThread().setContextClassLoader(emptyClassLoader);
            Class<?> dummyClass = myClassLoader.loadClass("test.classloader.DummyClass");
            this.getClassContainer().addClass(dummyClass);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        junit.framework.Assert.assertTrue((String)"Classloader not used to load inner class", (boolean)myClassLoader.isUsedForInnerClasses());
        BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((String)"/test/classloader/DummyClass"));
        this.assertContainsClass((ArchivePath)expectedClassPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClassesFromCustomClassloader() throws Exception {
        String[] expetedResources;
        ClassLoader emptyClassLoader = new ClassLoader(null){};
        ClassLoader originalClassLoader = SecurityActions.getThreadContextClassLoader();
        ClassLoaderTester myClassLoader = new ClassLoaderTester("cl-test.jar");
        try {
            Thread.currentThread().setContextClassLoader(emptyClassLoader);
            Class<?> dummyClass = myClassLoader.loadClass("test.classloader.DummyClass");
            Class<?> dummyInnerClass = myClassLoader.loadClass("test.classloader.DummyClass$DummyInnerClass");
            this.getClassContainer().addClasses(new Class[]{dummyClass, dummyInnerClass});
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        junit.framework.Assert.assertTrue((String)"Classloader not used to load inner class", (boolean)myClassLoader.isUsedForInnerClasses());
        for (String expectedResource : expetedResources = new String[]{"/test/classloader/DummyClass", "/test/classloader/DummyClass$DummyInnerClass"}) {
            BasicPath expectedClassPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource((String)expectedResource));
            this.assertContainsClass((ArchivePath)expectedClassPath);
        }
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackage() throws Exception {
        this.getClassContainer().addPackage(DummyClassA.class.getPackage());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageNonRecursive() throws Exception {
        this.getClassContainer().addPackages(false, new Package[]{DummyClassA.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageRecursiveFiltered() throws Exception {
        this.getClassContainer().addPackages(true, Filters.include((Class[])new Class[]{DynamicContainerTestBase.class}), new Package[]{DynamicContainerTestBase.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        junit.framework.Assert.assertEquals((String)"Should only be one class added", (int)1, (int)this.numAssets((Archive<?>)this.getArchive()));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageAsString() throws Exception {
        this.getClassContainer().addPackage(DummyClassA.class.getPackage().getName());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageAsStringNonRecursive() throws Exception {
        this.getClassContainer().addPackages(false, new String[]{DummyClassA.class.getPackage().getName()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassA.class));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageAsStringRecursiveFiltered() throws Exception {
        this.getClassContainer().addPackages(true, Filters.include((Class[])new Class[]{DynamicContainerTestBase.class}), new String[]{DynamicContainerTestBase.class.getPackage().getName()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        junit.framework.Assert.assertEquals((String)"Should only be one class added", (int)1, (int)this.numAssets((Archive<?>)this.getArchive()));
        this.assertContainsClass((ArchivePath)expectedPath);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddNonExistentPackage() {
        String packageName = "non.existent.package";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addPackages(true, new Package[]{Package.getPackage("non.existent.package")});
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testShouldIcludeOnlySelectedPackages() throws Exception {
        Package parent = DummyClassForTest.class.getPackage();
        Package nested1 = EmptyClassForFiltersTest1.class.getPackage();
        Package nested2 = EmptyClassForFiltersTest2.class.getPackage();
        this.getClassContainer().addPackages(true, Filters.include((Package[])new Package[]{nested1, nested2}), new String[]{parent.getName()});
        BasicPath expectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest1.class));
        BasicPath expectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest2.class));
        BasicPath notExpectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest3.class));
        BasicPath notExpectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassForTest.class));
        junit.framework.Assert.assertEquals((String)"Should only include selected packages", (int)2, (int)this.numAssets((Archive<?>)this.getArchive()));
        this.assertContainsClass((ArchivePath)expectedPath1);
        this.assertContainsClass((ArchivePath)expectedPath2);
        this.assertNotContainsClass((ArchivePath)notExpectedPath1);
        this.assertNotContainsClass((ArchivePath)notExpectedPath2);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testShouldExcludeOnlySelectedPackages() throws Exception {
        Package parent = DummyClassForTest.class.getPackage();
        Package nested1 = EmptyClassForFiltersTest1.class.getPackage();
        Package nested2 = EmptyClassForFiltersTest2.class.getPackage();
        this.getClassContainer().addPackages(true, Filters.exclude((Package[])new Package[]{nested1, nested2}), new String[]{parent.getName()});
        BasicPath expectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest3.class));
        BasicPath expectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassForTest.class));
        BasicPath notExpectedPath1 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest1.class));
        BasicPath notExpectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(EmptyClassForFiltersTest2.class));
        this.assertContainsClass((ArchivePath)expectedPath1);
        this.assertContainsClass((ArchivePath)expectedPath2);
        this.assertNotContainsClass((ArchivePath)notExpectedPath1);
        this.assertNotContainsClass((ArchivePath)notExpectedPath2);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void shouldIncludeOnlySelectedClasses() throws Exception {
        this.getClassContainer().addPackages(true, Filters.include((Class[])new Class[]{DynamicContainerTestBase.class, ArchiveType.class}), new String[]{DynamicContainerTestBase.class.getPackage().getName()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        BasicPath expectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(ArchiveType.class));
        junit.framework.Assert.assertEquals((String)"Should only include selected classes", (int)2, (int)this.numAssets((Archive<?>)this.getArchive()));
        this.assertContainsClass((ArchivePath)expectedPath);
        this.assertContainsClass((ArchivePath)expectedPath2);
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void shouldExcludeOnlySelectedClasses() throws Exception {
        this.getClassContainer().addPackages(true, Filters.exclude((Class[])new Class[]{DynamicContainerTestBase.class, ArchiveType.class}), new String[]{DynamicContainerTestBase.class.getPackage().getName()});
        BasicPath notExpectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DynamicContainerTestBase.class));
        BasicPath notExpectedPath2 = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(ArchiveType.class));
        junit.framework.Assert.assertFalse((String)("Archive should not contain " + notExpectedPath.get()), (boolean)this.getArchive().contains((ArchivePath)notExpectedPath));
        junit.framework.Assert.assertFalse((String)("Archive should not contain " + notExpectedPath2.get()), (boolean)this.getArchive().contains((ArchivePath)notExpectedPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResource() throws Exception {
        this.getLibraryContainer().addAsLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryFile() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResourceRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolderPath);
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getLibraryPath(), baseFolderPath);
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testArchiveContainsEmptyLibraryDirectory() throws Exception {
        String baseFolder = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolder);
        String emptyFolderPath = baseFolder + "/empty";
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(emptyFolderPath), this.getLibraryPath(), emptyFolderPath);
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResourceWithTargetRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolderPath, "/new-name");
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getLibraryPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResourceWithTargetPathRecursively() throws Exception {
        String baseFolderPath = "org/jboss/shrinkwrap/impl/base/recursion";
        this.getLibraryContainer().addAsLibrary(baseFolderPath, (ArchivePath)new BasicPath("/new-name"));
        this.assertArchiveContainsFolderRecursively(this.getFileForClassResource(baseFolderPath), this.getLibraryPath(), "/new-name");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryFileRecursively() throws Exception {
        File baseFolder = this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getLibraryContainer().addAsLibrary(baseFolder);
        this.assertArchiveContainsFolderRecursively(baseFolder, this.getLibraryPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURLRecursively() throws Exception {
        URL baseFolder = this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getLibraryContainer().addAsLibrary(baseFolder, "/recursion");
        this.assertArchiveContainsFolderRecursively(new File(baseFolder.getFile()), this.getLibraryPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURLWithArchivePathRecursively() throws Exception {
        URL baseFolder = this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/recursion");
        this.getLibraryContainer().addAsLibrary(baseFolder, (ArchivePath)new BasicPath("/recursion"));
        this.assertArchiveContainsFolderRecursively(new File(baseFolder.getFile()), this.getLibraryPath(), "/recursion");
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getLibraryContainer().addAsLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), (ArchivePath)targetPath);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetResource() throws Exception {
        this.getLibraryContainer().addAsLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetFile() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetURL() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetAsset() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetResource() throws Exception {
        this.getLibraryContainer().addAsLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetFile() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetURL() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetAsset() throws Exception {
        this.getLibraryContainer().addAsLibrary(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryArchive() throws Exception {
        Archive archive = this.createNewArchive();
        this.getLibraryContainer().addAsLibrary(archive);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesResource() throws Exception {
        this.getLibraryContainer().addAsLibraries(new String[]{"org/jboss/shrinkwrap/impl/base/asset/Test.properties", "org/jboss/shrinkwrap/impl/base/asset/Test2.properties"});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesFile() throws Exception {
        this.getLibraryContainer().addAsLibraries(new File[]{this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test2.properties")});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.properties");
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), "Test2.properties");
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchive() throws Exception {
        Archive archive = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        this.getLibraryContainer().addAsLibraries(new Archive[]{archive, archive2});
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), archive.getName());
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveCollection() throws Exception {
        Archive archive = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        ArrayList archives = new ArrayList();
        archives.add(archive);
        archives.add(archive2);
        this.getLibraryContainer().addAsLibraries(archives);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), archive.getName());
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveArrays() throws Exception {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        Archive archive3 = this.createNewArchive();
        Archive archive4 = this.createNewArchive();
        Archive[] archiveArray1 = new Archive[]{archive1, archive2};
        Archive[] archiveArray2 = new Archive[]{archive3, archive4};
        this.getLibraryContainer().addAsLibraries((Archive[][])new Archive[][]{archiveArray1, archiveArray2});
        BasicPath testPath1 = new BasicPath(this.getLibraryPath(), archive1.getName());
        BasicPath testPath2 = new BasicPath(this.getLibraryPath(), archive2.getName());
        BasicPath testPath3 = new BasicPath(this.getLibraryPath(), archive3.getName());
        BasicPath testPath4 = new BasicPath(this.getLibraryPath(), archive4.getName());
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath1), (boolean)this.getArchive().contains((ArchivePath)testPath1));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath3), (boolean)this.getArchive().contains((ArchivePath)testPath3));
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath4), (boolean)this.getArchive().contains((ArchivePath)testPath4));
    }

    @Test(expected=IllegalArgumentException.class)
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveArraysWithNullArguments() throws Exception {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        Archive archive3 = this.createNewArchive();
        Archive archive4 = this.createNewArchive();
        Archive[] archives = new Archive[]{archive1, archive2, archive3, archive4};
        this.getLibraryContainer().addAsLibraries((Archive[][])new Archive[][]{archives, null, null});
    }

    @Test(expected=IllegalArgumentException.class)
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibrariesArchiveArraysWithNullValues() throws Exception {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        Archive archive3 = this.createNewArchive();
        Archive archive4 = this.createNewArchive();
        Archive[] archives = new Archive[]{archive1, archive2, archive3, null, archive4, null};
        this.getLibraryContainer().addAsLibraries(archives);
    }

    @Test
    public void testAddManifest() throws Exception {
        String expectedManifestPath = "META-INF/MANIFEST.MF";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        junit.framework.Assert.assertFalse((String)"Archive should not contain manifest file", (boolean)archive.contains(expectedManifestPath));
        archive.addManifest();
        junit.framework.Assert.assertTrue((String)("Archive should contain manifest file: " + expectedManifestPath), (boolean)archive.contains(expectedManifestPath));
    }

    @Test
    public void testAddFileWithWhitespaceInFilename() {
        String manifest = "Whitespace manifest.MF";
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        Assert.assertFalse((String)"Archive should not contain file", (boolean)archive.contains(manifest));
        archive.addAsResource(manifest);
        junit.framework.Assert.assertTrue((String)("Archive should contain file: " + manifest), (boolean)archive.contains(manifest));
    }

    @Test
    public void testAddingEmptyResourceDirectory() throws Exception {
        File directory = File.createTempFile("resources", null);
        directory.delete();
        directory.deleteOnExit();
        File svn = new File(directory, ".svn");
        svn.deleteOnExit();
        svn.mkdirs();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ((ZipExporter)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addAsResource(directory, "/")).as(ZipExporter.class)).exportTo((OutputStream)out);
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(out.toByteArray()));
        ZipEntry entry = zis.getNextEntry();
        junit.framework.Assert.assertNotNull((String)"Missing '.svn/' Entry from Exported Archive", (Object)entry);
        junit.framework.Assert.assertEquals((String)"Zip Entry Missing Expected Name '.svn/'", (String)".svn/", (String)entry.getName());
        junit.framework.Assert.assertEquals((String)"Zip Entry '.svn/' Not A Directory", (boolean)true, (boolean)entry.isDirectory());
        zis.closeEntry();
        zis.close();
    }

    @Test
    public void addDuplicateResourceThrowsIllegalOverwriteException() {
        Archive archive = this.createNewArchive();
        ArchivePath path = ArchivePaths.create((String)"testPath");
        archive.add((Asset)EmptyAsset.INSTANCE, path);
        try {
            archive.add((Asset)new StringAsset("failContent"), path);
        }
        catch (IllegalOverwriteException ioe) {
            return;
        }
        TestCase.fail((String)("Expected " + IllegalOverwriteException.class.getName() + " not received"));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void containsShouldReturnFalseWhenParentNodeHasBeenDeleted() {
        Archive archive = this.createNewArchive();
        String archivePath = "WEB-INF/classes/org/drools/guvnor/gwtutil/";
        String file = "WEB-INF/classes/org/drools/guvnor/gwtutil/file";
        archive.add((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        junit.framework.Assert.assertTrue((boolean)archive.contains("WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        archive.delete(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil"));
        junit.framework.Assert.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/")));
        junit.framework.Assert.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file")));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void shouldDeleteArchivePathWithTrailingSlash() {
        Archive archive = this.createNewArchive();
        String archivePath = "WEB-INF/classes/org/drools/guvnor/gwtutil/";
        String file = "WEB-INF/classes/org/drools/guvnor/gwtutil/file";
        archive.add((Asset)EmptyAsset.INSTANCE, ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        junit.framework.Assert.assertTrue((boolean)archive.contains("WEB-INF/classes/org/drools/guvnor/gwtutil/file"));
        archive.delete(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/"));
        junit.framework.Assert.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/")));
        junit.framework.Assert.assertFalse((boolean)archive.contains(ArchivePaths.create((String)"WEB-INF/classes/org/drools/guvnor/gwtutil/file")));
    }

    private void assertNotContainsClass(ArchivePath notExpectedPath) {
        junit.framework.Assert.assertFalse((String)("Located unexpected class at " + notExpectedPath.get()), (boolean)this.getArchive().contains(notExpectedPath));
    }

    private void assertContainsClass(ArchivePath expectedPath) {
        junit.framework.Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains(expectedPath));
    }

    private void assertArchiveContainsFolderRecursively(File file, ArchivePath base, String target) throws Exception {
        BasicPath testPath = new BasicPath(base, target);
        junit.framework.Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.assertArchiveContainsFolderRecursively(child, base, target + "/" + child.getName());
            }
            int folderInArchiveSize = this.getArchive().get((ArchivePath)testPath).getChildren().size();
            junit.framework.Assert.assertEquals((String)("Wrong number of files in the archive folder: " + testPath.get()), (int)file.listFiles().length, (int)folderInArchiveSize);
        }
    }

    protected File getTarget() {
        try {
            return new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("Could not obtain the target URI", urise);
        }
    }

    private File createDirectory(String resourcePath) throws IOException {
        String[] split;
        File directory = this.getTarget();
        for (String folder : split = resourcePath.split("/")) {
            boolean created;
            if ((directory = new File(directory, folder)).exists() || (created = directory.mkdir())) continue;
            throw new RuntimeException("Impossible to create directory at path:" + directory.getAbsolutePath());
        }
        return directory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassLoaderTester
    extends URLClassLoader {
        private boolean usedForInnerClasses;

        public ClassLoaderTester(String resource) throws MalformedURLException, URISyntaxException {
            this(TestIOUtil.createFileFromResourceName(resource));
        }

        private ClassLoaderTester(File jar) throws MalformedURLException {
            super(new URL[]{jar.toURI().toURL()}, (ClassLoader)null);
            this.usedForInnerClasses = false;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            this.usedForInnerClasses = true;
            return super.getResources(name);
        }

        public boolean isUsedForInnerClasses() {
            return this.usedForInnerClasses;
        }
    }
}

