/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveFormat;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.formatter.Formatters;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.StreamImporter;
import org.jboss.shrinkwrap.impl.base.ArchiveFormatStreamBindings;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.spi.ArchiveFormatAssociable;
import org.jboss.shrinkwrap.spi.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveBase<T extends Archive<T>>
implements Archive<T>,
Configurable,
ArchiveFormatAssociable {
    private static final Logger log = Logger.getLogger(ArchiveBase.class.getName());
    private final String name;
    private final Configuration configuration;

    protected ArchiveBase(String name, Configuration configuration) throws IllegalArgumentException {
        Validate.notNullOrEmpty(name, "name must be specified");
        Validate.notNull(configuration, "configuration must be specified");
        this.name = name;
        this.configuration = configuration;
    }

    public ArchiveFormat getArchiveFormat() {
        return ArchiveFormat.UNKNOWN;
    }

    public T add(Asset asset, String target) throws IllegalArgumentException {
        Validate.notNullOrEmpty(target, "target must be specified");
        Validate.notNull(asset, "asset must be specified");
        BasicPath path = new BasicPath(target);
        return (T)this.add(asset, path);
    }

    public T add(Asset asset, String target, String name) throws IllegalArgumentException {
        Validate.notNull(target, "target must be specified");
        ArchivePath path = ArchivePaths.create((String)target);
        return this.add(asset, path, name);
    }

    public T add(Asset asset, ArchivePath path, String name) {
        Validate.notNull(path, "No path was specified");
        Validate.notNullOrEmpty(name, "No target name name was specified");
        Validate.notNull(asset, "No asset was was specified");
        BasicPath resolvedPath = new BasicPath(path, name);
        return (T)this.add(asset, resolvedPath);
    }

    public Node get(String path) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "No path was specified");
        BasicPath realPath = new BasicPath(path);
        return this.get(realPath);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path) {
        Validate.notNull(path, "Path must be specified");
        return this.getAsType(type, ArchivePaths.create((String)path));
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(filter, "Filter must be specified");
        ArrayList<X> archives = new ArrayList<X>();
        Map matches = this.getContent(filter);
        for (ArchivePath path : matches.keySet()) {
            archives.add(this.getAsType(type, path));
        }
        return archives;
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(path, "ArchivePath must be specified");
        Node content = this.get(path);
        if (content == null) {
            return null;
        }
        Asset asset = content.getAsset();
        if (asset == null) {
            return null;
        }
        if (asset instanceof ArchiveAsset) {
            ArchiveAsset archiveAsset = (ArchiveAsset)asset;
            return (X)((Archive)archiveAsset.getArchive().as(type));
        }
        ArchiveFormat archiveFormat = this.configuration.getExtensionLoader().getArchiveFormatFromExtensionMapping(type);
        return this.getAsType(type, path, archiveFormat);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path, ArchiveFormat archiveFormat) {
        Validate.notNull(path, "ArchiveFormat must be specified");
        return this.getAsType(type, ArchivePaths.create((String)path), archiveFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path, ArchiveFormat archiveFormat) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(path, "ArchivePath must be specified");
        Validate.notNull(archiveFormat, "ArchiveFormat must be specified");
        ArchiveFormatStreamBindings formatBinding = new ArchiveFormatStreamBindings(archiveFormat);
        Node content = this.get(path);
        if (content == null) {
            return null;
        }
        Asset asset = content.getAsset();
        if (asset == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = asset.openStream();
            Archive archive = (Archive)((StreamImporter)ShrinkWrap.create(formatBinding.getImporter(), (String)path.get())).importFrom(stream).as(type);
            this.delete(path);
            this.add((Asset)new ArchiveAsset(archive, formatBinding.getExporter()), path);
            Archive archive2 = archive;
            return (X)archive2;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new ArchiveImportException("Stream not closed after import", (Throwable)e);
                }
            }
        }
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter, ArchiveFormat archiveFormat) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(filter, "Filter must be specified");
        Validate.notNull(archiveFormat, "ArchiveFormat must be specified");
        ArrayList<X> archives = new ArrayList<X>();
        Map matches = this.getContent(filter);
        for (ArchivePath path : matches.keySet()) {
            archives.add(this.getAsType(type, path, archiveFormat));
        }
        return archives;
    }

    public T add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) {
        Validate.notNull(path, "No path was specified");
        Validate.notNull(archive, "No archive was specified");
        Validate.notNull(exporter, "No exporter was specified");
        String archiveName = archive.getName();
        BasicPath contentPath = new BasicPath(path, archiveName);
        ArchiveAsset archiveAsset = new ArchiveAsset(archive, exporter);
        return (T)this.add((Asset)archiveAsset, contentPath);
    }

    public T add(NamedAsset namedAsset) {
        Validate.notNull(namedAsset, "No named asset was specified");
        return this.add((Asset)namedAsset, namedAsset.getName());
    }

    public T addAsDirectory(String path) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "path must be specified");
        return (T)this.addAsDirectory(ArchivePaths.create((String)path));
    }

    public T addAsDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        Validate.notNull(paths, "paths must be specified");
        for (ArchivePath path : paths) {
            this.addAsDirectory(path);
        }
        return this.covariantReturn();
    }

    public T addAsDirectories(String ... paths) throws IllegalArgumentException {
        Validate.notNull(paths, "paths must be specified");
        ArrayList<ArchivePath> pathsCollection = new ArrayList<ArchivePath>(paths.length);
        for (String path : paths) {
            pathsCollection.add(ArchivePaths.create((String)path));
        }
        return this.addAsDirectories(pathsCollection.toArray(new ArchivePath[0]));
    }

    public final String getName() {
        return this.name;
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        return this.merge(source, new BasicPath());
    }

    public T merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        return this.merge(source, new BasicPath(), filter);
    }

    public T merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        Validate.notNull(source, "No source archive was specified");
        Validate.notNull(path, "No path was specified");
        return this.merge(source, path, (Filter<ArchivePath>)Filters.includeAll());
    }

    public T merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        Validate.notNull(path, "path must be specified");
        return this.merge(source, ArchivePaths.create((String)path), filter);
    }

    public T merge(Archive<?> source, String path) throws IllegalArgumentException {
        Validate.notNull(path, "path must be specified");
        return this.merge(source, ArchivePaths.create((String)path));
    }

    public final Archive<T> shallowCopy() {
        Configuration configuration = this.getConfiguration();
        ArchiveBase from = this;
        Archive to = (Archive)Archive.class.cast(new MemoryMapArchiveImpl(configuration));
        for (ArchivePath path : from.getContent().keySet()) {
            to.add(from.get(path).getAsset(), path);
        }
        return to;
    }

    public T merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        Validate.notNull(source, "No source archive was specified");
        Validate.notNull(path, "No path was specified");
        Validate.notNull(filter, "No filter was specified");
        Map sourceContent = source.getContent();
        Validate.notNull(sourceContent, "Source archive content can not be null.");
        for (Map.Entry contentEntry : sourceContent.entrySet()) {
            Node node = (Node)contentEntry.getValue();
            BasicPath nodePath = new BasicPath(path, (ArchivePath)contentEntry.getKey());
            if (!filter.include((Object)nodePath)) continue;
            if (node.getAsset() == null) {
                this.addAsDirectory(nodePath);
                continue;
            }
            this.add(node.getAsset(), nodePath);
        }
        return this.covariantReturn();
    }

    public T move(ArchivePath source, ArchivePath target) throws IllegalArgumentException, IllegalArchivePathException {
        Validate.notNull(source, "The source path was not specified");
        Validate.notNull(target, "The target path was not specified");
        Node nodeToMove = this.get(source);
        if (null == nodeToMove) {
            throw new IllegalArchivePathException(source.get() + " doesn't specify any node in the archive to move");
        }
        this.add(nodeToMove.getAsset(), target);
        this.delete(source);
        return this.covariantReturn();
    }

    public T move(String source, String target) throws IllegalArgumentException, IllegalArchivePathException {
        Validate.notNullOrEmpty(source, "The source path was not specified");
        Validate.notNullOrEmpty(target, "The target path was not specified");
        BasicPath sourcePath = new BasicPath(source);
        BasicPath targetPath = new BasicPath(target);
        return this.move(sourcePath, targetPath);
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        Validate.notNull(clazz, "Class must be specified");
        return (TYPE)this.configuration.getExtensionLoader().load(clazz, (Archive)this);
    }

    public String toString() {
        return this.toString((Formatter)Formatters.SIMPLE);
    }

    public String toString(boolean verbose) {
        return verbose ? this.toString((Formatter)Formatters.VERBOSE) : this.toString();
    }

    public String toString(Formatter formatter) throws IllegalArgumentException {
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter must be specified");
        }
        return formatter.format((Archive)this);
    }

    public void writeTo(OutputStream outputStream, Formatter formatter) throws IllegalArgumentException {
        try {
            IOUtil.bufferedWriteWithFlush(outputStream, this.toString(formatter).getBytes());
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not write Archive contents to specified OutputStream", ioe);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getContent() == null ? 0 : ((Object)this.getContent()).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveBase)) {
            return false;
        }
        ArchiveBase other = (ArchiveBase)obj;
        if (this.getContent() == null ? other.getContent() != null : !((Object)this.getContent()).equals(other.getContent())) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected abstract Class<T> getActualClass();

    protected final T covariantReturn() {
        try {
            return (T)((Archive)this.getActualClass().cast(this));
        }
        catch (ClassCastException cce) {
            log.log(Level.SEVERE, "The class specified by getActualClass is not a valid assignment target for this instance; developer error");
            throw cce;
        }
    }
}

