/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchiveEvent;
import org.jboss.shrinkwrap.api.ArchiveEventHandler;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.IllegalArchivePathException;
import org.jboss.shrinkwrap.api.IllegalOverwriteException;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.ArchiveAsset;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.NodeImpl;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemoryMapArchiveBase<T extends Archive<T>>
extends ArchiveBase<T>
implements Archive<T> {
    private final Map<ArchivePath, NodeImpl> content = new ConcurrentHashMap<ArchivePath, NodeImpl>();
    private final Map<ArchivePath, ArchiveAsset> nestedArchives = new ConcurrentHashMap<ArchivePath, ArchiveAsset>();
    private List<ArchiveEventHandler> handlers = new ArrayList<ArchiveEventHandler>();

    public MemoryMapArchiveBase(Configuration configuration) throws IllegalArgumentException {
        this("Archive-" + UUID.randomUUID().toString() + ".jar", configuration);
    }

    public MemoryMapArchiveBase(String archiveName, Configuration configuration) throws IllegalArgumentException {
        super(archiveName, configuration);
        BasicPath rootPath = new BasicPath("/");
        this.content.put(rootPath, new NodeImpl(rootPath));
    }

    public T add(Asset asset, ArchivePath path) {
        Validate.notNull(asset, "No asset was specified");
        Validate.notNull(path, "No path was specified");
        return this.addAsset(path, asset);
    }

    public T add(Archive<?> archive, String path, Class<? extends StreamExporter> exporter) {
        Validate.notNull(archive, "Archive must be specified");
        Validate.notNullOrEmpty(path, "Archive Path must be specified");
        Validate.notNull(exporter, "exporter must be specified");
        return this.add(archive, ArchivePaths.create((String)path), exporter);
    }

    @Override
    public T add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) {
        super.add(archive, path, exporter);
        BasicPath archivePath = new BasicPath(path, archive.getName());
        Node node = this.get(archivePath);
        if (node.getAsset() != null && node.getAsset() instanceof ArchiveAsset) {
            ArchiveAsset archiveAsset = (ArchiveAsset)ArchiveAsset.class.cast(node.getAsset());
            this.nestedArchives.put(archivePath, archiveAsset);
        }
        return this.covariantReturn();
    }

    public T addAsDirectory(ArchivePath path) throws IllegalArgumentException {
        Validate.notNull(path, "path must be specified");
        BasicPath adjustedPath = new BasicPath(PathUtil.optionallyRemoveFollowingSlash(path.get()));
        return this.addAsset(adjustedPath, null);
    }

    private T addAsset(ArchivePath path, Asset asset) {
        Asset handledAsset = this.invokeHandlers(path, asset);
        if (!this.contains(path)) {
            NodeImpl node = new NodeImpl(path, handledAsset);
            this.content.put(path, node);
            NodeImpl parentNode = this.obtainParent(path.getParent());
            if (parentNode != null) {
                parentNode.addChild(node);
            }
        } else {
            Node node = this.get(path);
            if (node.getAsset() != null) {
                throw new IllegalOverwriteException("Cannot add requested path " + path.get() + " to archive " + this.getName() + "; path already exists");
            }
        }
        return this.covariantReturn();
    }

    public T addHandlers(ArchiveEventHandler ... handlers) {
        for (ArchiveEventHandler handler : handlers) {
            this.handlers.add(handler);
        }
        return this.covariantReturn();
    }

    private Asset invokeHandlers(ArchivePath path, Asset asset) {
        ArchiveEvent event = new ArchiveEvent(path, asset);
        for (ArchiveEventHandler handler : this.handlers) {
            handler.handle(event);
        }
        return event.getHandledAsset();
    }

    public boolean contains(ArchivePath path) {
        Validate.notNull(path, "No path was specified");
        boolean found = this.content.containsKey(path);
        if (!found) {
            found = this.nestedContains(path);
        }
        return found;
    }

    public boolean contains(String path) throws IllegalArgumentException {
        Validate.notNull(path, "Path must be specified");
        ArchivePath archivePath = ArchivePaths.create((String)path);
        return this.contains(archivePath);
    }

    public Node delete(ArchivePath path) {
        Validate.notNull(path, "No path was specified");
        ArchivePath safePath = path;
        NodeImpl node = this.content.get(safePath);
        if (node == null) {
            if (path.get().endsWith("/")) {
                safePath = ArchivePaths.create((String)path.get().substring(0, path.get().length() - 1));
                node = this.content.get(safePath);
            }
            if (node == null) {
                return null;
            }
        }
        return this.removeNodeRecursively(node, safePath);
    }

    private Node removeNodeRecursively(NodeImpl node, ArchivePath path) {
        NodeImpl parentNode = this.content.get(path.getParent());
        if (parentNode != null) {
            parentNode.removeChild(node);
        }
        if (node.getChildren() != null) {
            for (Node child : node.getChildren()) {
                node.removeChild(child);
                this.content.remove(child.getPath());
            }
        }
        return this.content.remove(path);
    }

    public Node delete(String archivePath) {
        Validate.notNull(archivePath, "No path was specified");
        return this.delete(ArchivePaths.create((String)archivePath));
    }

    public Node get(ArchivePath path) {
        Validate.notNull(path, "No path was specified");
        Node node = this.content.get(path);
        if (node == null && this.contains(path)) {
            node = this.getNestedNode(path);
        }
        return node;
    }

    public Map<ArchivePath, Node> getContent() {
        HashMap<ArchivePath, NodeImpl> ret = new HashMap<ArchivePath, NodeImpl>();
        for (Map.Entry<ArchivePath, NodeImpl> item : this.content.entrySet()) {
            if (item.getKey().equals(new BasicPath("/"))) continue;
            ret.put(item.getKey(), item.getValue());
        }
        return Collections.unmodifiableMap(ret);
    }

    public Map<ArchivePath, Node> getContent(Filter<ArchivePath> filter) {
        Validate.notNull(filter, "Filter must be specified");
        HashMap<ArchivePath, Node> filteredContent = new HashMap<ArchivePath, Node>();
        for (Map.Entry<ArchivePath, NodeImpl> contentEntry : this.content.entrySet()) {
            if (!filter.include((Object)contentEntry.getKey()) || contentEntry.getKey().equals(new BasicPath("/"))) continue;
            filteredContent.put(contentEntry.getKey(), contentEntry.getValue());
        }
        return filteredContent;
    }

    private boolean nestedContains(ArchivePath path) {
        for (Map.Entry<ArchivePath, ArchiveAsset> nestedArchiveEntry : this.nestedArchives.entrySet()) {
            ArchivePath archivePath = nestedArchiveEntry.getKey();
            ArchiveAsset archiveAsset = nestedArchiveEntry.getValue();
            if (!this.startsWith(path, archivePath)) continue;
            Archive nestedArchive = archiveAsset.getArchive();
            ArchivePath nestedAssetPath = this.getNestedPath(path, archivePath);
            return nestedArchive.contains(nestedAssetPath);
        }
        return false;
    }

    private Node getNestedNode(ArchivePath path) {
        for (Map.Entry<ArchivePath, ArchiveAsset> nestedArchiveEntry : this.nestedArchives.entrySet()) {
            ArchivePath archivePath = nestedArchiveEntry.getKey();
            ArchiveAsset archiveAsset = nestedArchiveEntry.getValue();
            if (!this.startsWith(path, archivePath)) continue;
            Archive nestedArchive = archiveAsset.getArchive();
            ArchivePath nestedAssetPath = this.getNestedPath(path, archivePath);
            return nestedArchive.get(nestedAssetPath);
        }
        return null;
    }

    private boolean startsWith(ArchivePath fullPath, ArchivePath startingPath) {
        String context = fullPath.get();
        String startingContext = startingPath.get();
        return context.startsWith(startingContext);
    }

    private ArchivePath getNestedPath(ArchivePath fullPath, ArchivePath basePath) {
        String context = fullPath.get();
        String baseContent = basePath.get();
        String nestedArchiveContext = context.substring(baseContent.length());
        return new BasicPath(nestedArchiveContext);
    }

    private NodeImpl obtainParent(ArchivePath path) {
        if (path == null) {
            return null;
        }
        NodeImpl node = this.content.get(path);
        if (node != null) {
            if (node.getAsset() != null) {
                throw new IllegalArchivePathException("Could not create node under " + path.getParent() + ". It points to an asset.");
            }
            return node;
        }
        node = new NodeImpl(path);
        NodeImpl parentNode = this.obtainParent(path.getParent());
        if (parentNode != null) {
            parentNode.addChild(node);
        }
        this.content.put(path, node);
        return node;
    }
}

